/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextPane;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationResults;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationStage;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class ValidationDetailsDialog {
    private JDialog fDetailsDialog = new MJDialog();
    private JTextPane fTextPane;
    private static final Dimension DEFAULT_UI_SIZE = new Dimension(400, 400);
    private static final String REGULAR_STYLE = "regular";
    private static final String ITALIC_STYLE = "italic";
    private static final String BOLD_STYLE = "bold";
    private static final String MATLAB_OUTPUT_STYLE = "matlaboutput";
    private static final String MATLAB_ERROR_STYLE = "matlaberror";
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");

    public ValidationDetailsDialog(String string, String string2, Map<ValidationStage, ValidationResults> map) {
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        this.fTextPane = new MJTextPane();
        ValidationDetailsDialog.addStylesToDocument(this.fTextPane.getStyledDocument());
        this.updateDetails(string, string2, map);
        this.fTextPane.setEditable(false);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTextPane);
        styleGuideEmptyPanel.addLine((JComponent)mJScrollPane, 8);
        this.fDetailsDialog.setSize(DEFAULT_UI_SIZE);
        this.fDetailsDialog.setContentPane((Container)((Object)styleGuideEmptyPanel));
        this.fDetailsDialog.setTitle(MessageFormat.format(sRes.getString("ValidationDetails.DialogTitle"), string));
        this.fDetailsDialog.setName("DetailsDialog");
        this.fTextPane.setName("ResultsTextPane");
    }

    public JDialog getComponent() {
        return this.fDetailsDialog;
    }

    public void updateDetails(String string, String string2, Map<ValidationStage, ValidationResults> map) {
        this.fDetailsDialog.setTitle(MessageFormat.format(sRes.getString("ValidationDetails.DialogTitle"), string));
        this.fTextPane.setText("");
        this.appendLine(sRes.getString("ValidationDetails.Title"), BOLD_STYLE);
        this.createProfilesSection(string, string2);
        this.createStageSection(ValidationStage.PARCLUSTER, map.get((Object)ValidationStage.PARCLUSTER));
        this.createStageSection(ValidationStage.INDEPENDENT_JOB, map.get((Object)ValidationStage.INDEPENDENT_JOB));
        this.createStageSection(ValidationStage.COMMUNICATING_SPMD_JOB, map.get((Object)ValidationStage.COMMUNICATING_SPMD_JOB));
        this.createStageSection(ValidationStage.COMMUNICATING_POOL_JOB, map.get((Object)ValidationStage.COMMUNICATING_POOL_JOB));
        this.createStageSection(ValidationStage.MATLABPOOL, map.get((Object)ValidationStage.MATLABPOOL));
    }

    private void createProfilesSection(String string, String string2) {
        this.appendLine(MessageFormat.format(sRes.getString("ValidationDetails.Profile"), string), REGULAR_STYLE);
        this.appendLine(MessageFormat.format(sRes.getString("ValidationDetails.SchedulerType"), string2), REGULAR_STYLE);
    }

    private void createStageSection(ValidationStage validationStage, ValidationResults validationResults) {
        String string = validationStage.getDisplayString();
        ValidationStatus validationStatus = validationResults != null ? validationResults.getStatus() : ValidationStatus.NOT_RUN;
        String string2 = validationStatus.getDisplayString();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (validationResults != null) {
            string3 = validationResults.getCommandWindowOutput();
            string4 = validationResults.getDebugLog();
            string5 = validationResults.getDescription();
            string6 = validationResults.getErrorReport();
        }
        this.addSeparator();
        this.appendLine(MessageFormat.format(sRes.getString("ValidationDetails.Stage"), string), BOLD_STYLE);
        this.appendLine(MessageFormat.format(sRes.getString("ValidationDetails.Status"), string2));
        this.append(sRes.getString("ValidationDetails.Description"));
        if (string5 == null || string5.isEmpty()) {
            this.appendLine(sRes.getString("ValidationDetails.None"), ITALIC_STYLE);
        } else {
            this.appendLine(string5);
        }
        if (string3 == null || string3.isEmpty()) {
            this.append(sRes.getString("ValidationDetails.CommandLineOutput"));
            this.appendLine(sRes.getString("ValidationDetails.None"), ITALIC_STYLE);
        } else {
            this.appendLine(sRes.getString("ValidationDetails.CommandLineOutput"));
            this.appendLine(string3, MATLAB_OUTPUT_STYLE);
        }
        if (string6 == null || string6.isEmpty()) {
            this.append(sRes.getString("ValidationDetails.ErrorReport"));
            this.appendLine(sRes.getString("ValidationDetails.None"), ITALIC_STYLE);
        } else {
            this.appendLine(sRes.getString("ValidationDetails.ErrorReport"));
            this.appendLine(string6, MATLAB_ERROR_STYLE);
        }
        if (string4 == null || string4.isEmpty()) {
            this.append(sRes.getString("ValidationDetails.DebugLog"));
            this.appendLine(sRes.getString("ValidationDetails.None"), ITALIC_STYLE);
        } else {
            this.appendLine(sRes.getString("ValidationDetails.DebugLog"));
            this.appendLine(string4, MATLAB_OUTPUT_STYLE);
        }
    }

    private void addSeparator() {
        this.appendLine("", REGULAR_STYLE);
    }

    private void appendLine(String string) {
        this.appendLine(string, REGULAR_STYLE);
    }

    private void append(String string) {
        this.append(string, REGULAR_STYLE);
    }

    private void appendLine(String string, String string2) {
        this.append(string + "\n", string2);
    }

    private void append(String string, String string2) {
        StyledDocument styledDocument = this.fTextPane.getStyledDocument();
        try {
            styledDocument.insertString(styledDocument.getLength(), string, styledDocument.getStyle(string2));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static void addStylesToDocument(StyledDocument styledDocument) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = styledDocument.addStyle(REGULAR_STYLE, style);
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style3 = styledDocument.addStyle(ITALIC_STYLE, style2);
        StyleConstants.setItalic(style3, true);
        Style style4 = styledDocument.addStyle(BOLD_STYLE, style2);
        StyleConstants.setBold(style4, true);
        Style style5 = styledDocument.addStyle(MATLAB_OUTPUT_STYLE, style2);
        StyleConstants.setFontFamily(style5, "Monospaced");
        Style style6 = styledDocument.addStyle(MATLAB_ERROR_STYLE, style2);
        StyleConstants.setFontFamily(style6, "Monospaced");
        StyleConstants.setForeground(style6, Color.RED);
    }
}

