/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.model;

import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingAccessException;
import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingValidationException;
import com.mathworks.toolbox.distcomp.ui.model.PropertyChangeSupportAdaptor;

public final class ParallelSettings
extends PropertyChangeSupportAdaptor {
    private final Setting<Double> fPreferredNumWorkers;
    private final Setting<Boolean> fAutoCreate;
    private final Setting<Double> fIdleTimeOut;
    private final Setting<String> fDefaultProfile;
    private final Setting<Boolean> fRestartOnClusterChange;
    private final Setting<Boolean> fRestartOnPreferredNumWorkersChange;
    private static final Object IGNORE_OLD_VALUE = new Object();
    private static final Object IGNORE_NEW_VALUE = new Object();
    private static final String PARALLEL_NODE = "parallel";
    private static final String CLIENT_NODE = "client";
    private static final String POOL_NODE = "pool";
    public static final String DEFAULT_PROFILE = "DefaultProfile";
    public static final String PREFERRED_NUM_WORKERS = "PreferredNumWorkers";
    public static final String AUTO_CREATE = "AutoCreate";
    public static final String IDLE_TIMEOUT = "IdleTimeout";
    public static final String RESTART_ON_CLUSTER_CHANGE = "RestartOnClusterChange";
    public static final String RESTART_ON_PREFERRED_NUM_WORKERS_CHANGE = "RestartOnPreferredNumWorkersChange";

    public ParallelSettings() throws SettingNotFoundException {
        SettingPath settingPath = new SettingPath(new String[]{PARALLEL_NODE, CLIENT_NODE});
        this.fDefaultProfile = new Setting(settingPath, DEFAULT_PROFILE);
        SettingPath settingPath2 = new SettingPath(settingPath, new String[]{POOL_NODE});
        this.fPreferredNumWorkers = new Setting(settingPath2, PREFERRED_NUM_WORKERS);
        this.fAutoCreate = new Setting(settingPath2, AUTO_CREATE);
        this.fIdleTimeOut = new Setting(settingPath2, IDLE_TIMEOUT);
        this.fRestartOnClusterChange = new Setting(settingPath2, RESTART_ON_CLUSTER_CHANGE);
        this.fRestartOnPreferredNumWorkersChange = new Setting(settingPath2, RESTART_ON_PREFERRED_NUM_WORKERS_CHANGE);
        this.addListeners();
    }

    private void addListeners() throws SettingNotFoundException {
        this.fDefaultProfile.addListener((SettingListener)new SettingAdapter(){

            public void settingChanged(SettingChangeEvent settingChangeEvent) {
                ParallelSettings.this.firePropertyChange(ParallelSettings.DEFAULT_PROFILE, IGNORE_OLD_VALUE, IGNORE_NEW_VALUE);
            }
        });
        this.fPreferredNumWorkers.addListener((SettingListener)new SettingAdapter(){

            public void settingChanged(SettingChangeEvent settingChangeEvent) {
                ParallelSettings.this.firePropertyChange(ParallelSettings.PREFERRED_NUM_WORKERS, IGNORE_OLD_VALUE, IGNORE_NEW_VALUE);
            }
        });
        this.fAutoCreate.addListener((SettingListener)new SettingAdapter(){

            public void settingChanged(SettingChangeEvent settingChangeEvent) {
                ParallelSettings.this.firePropertyChange(ParallelSettings.AUTO_CREATE, IGNORE_OLD_VALUE, IGNORE_NEW_VALUE);
            }
        });
        this.fIdleTimeOut.addListener((SettingListener)new SettingAdapter(){

            public void settingChanged(SettingChangeEvent settingChangeEvent) {
                ParallelSettings.this.firePropertyChange(ParallelSettings.IDLE_TIMEOUT, IGNORE_OLD_VALUE, IGNORE_NEW_VALUE);
            }
        });
        this.fRestartOnClusterChange.addListener((SettingListener)new SettingAdapter(){

            public void settingChanged(SettingChangeEvent settingChangeEvent) {
                ParallelSettings.this.firePropertyChange(ParallelSettings.RESTART_ON_CLUSTER_CHANGE, IGNORE_OLD_VALUE, IGNORE_NEW_VALUE);
            }
        });
        this.fRestartOnPreferredNumWorkersChange.addListener((SettingListener)new SettingAdapter(){

            public void settingChanged(SettingChangeEvent settingChangeEvent) {
                ParallelSettings.this.firePropertyChange(ParallelSettings.RESTART_ON_PREFERRED_NUM_WORKERS_CHANGE, IGNORE_OLD_VALUE, IGNORE_NEW_VALUE);
            }
        });
    }

    public String getDefaultProfile() throws SettingTypeException, SettingNotFoundException {
        return (String)this.fDefaultProfile.get();
    }

    public void setDefaultProfile(String string) throws SettingTypeException, SettingNotFoundException, SettingAccessException, SettingValidationException {
        this.fDefaultProfile.set((Object)string);
    }

    public int getPreferredNumWorkers() throws SettingTypeException, SettingNotFoundException {
        return this.convertDoubleToInt((Double)this.fPreferredNumWorkers.get());
    }

    public void setPreferredNumWorkers(int n) throws SettingValidationException, SettingAccessException, SettingNotFoundException, SettingTypeException {
        this.fPreferredNumWorkers.set((Object)this.convertIntToDouble(n));
    }

    public int getIdleTimeout() throws SettingTypeException, SettingNotFoundException {
        return this.convertDoubleToInt((Double)this.fIdleTimeOut.get());
    }

    public int getFactoryIdleTimeout() throws SettingTypeException, SettingNotFoundException {
        return this.convertDoubleToInt((Double)this.fIdleTimeOut.get(SettingLevel.FACTORY));
    }

    public void setIdleTimeout(int n) throws SettingTypeException, SettingNotFoundException, SettingAccessException, SettingValidationException {
        this.fIdleTimeOut.set((Object)this.convertIntToDouble(n));
    }

    public boolean isAutoCreate() throws SettingTypeException, SettingNotFoundException {
        return (Boolean)this.fAutoCreate.get();
    }

    public void setAutoCreate(boolean bl) throws SettingTypeException, SettingNotFoundException, SettingAccessException, SettingValidationException {
        this.fAutoCreate.set((Object)bl);
    }

    public boolean isRestartOnClusterChange() throws SettingTypeException, SettingNotFoundException {
        return (Boolean)this.fRestartOnClusterChange.get();
    }

    public void setRestartOnClusterChange(boolean bl) throws SettingTypeException, SettingNotFoundException, SettingAccessException, SettingValidationException {
        this.fRestartOnClusterChange.set((Object)bl);
    }

    public boolean isRestartOnPreferredNumWorkersChange() throws SettingTypeException, SettingNotFoundException {
        return (Boolean)this.fRestartOnPreferredNumWorkersChange.get();
    }

    public void setRestartOnPreferredNumWorkersChange(boolean bl) throws SettingTypeException, SettingNotFoundException, SettingAccessException, SettingValidationException {
        this.fRestartOnPreferredNumWorkersChange.set((Object)bl);
    }

    private int convertDoubleToInt(Double d) {
        if (d > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return d.intValue();
    }

    private double convertIntToDouble(int n) {
        if (Integer.valueOf(n).equals(Integer.MAX_VALUE)) {
            return Double.POSITIVE_INFINITY;
        }
        return n;
    }
}

