/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.jobmonitor;

import com.mathworks.toolbox.distcomp.ui.jobmonitor.ColumnInfo;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobCorruptionInfo;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobCorruptionLevel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobTableRowModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

final class JobMonitorTableModel
extends AbstractTableModel {
    private List<JobTableRowModel> fTableData = new ArrayList<JobTableRowModel>();

    JobMonitorTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.fTableData != null ? this.fTableData.size() : 0;
    }

    @Override
    public String getColumnName(int n) {
        return ColumnInfo.getColumnInfo(n).getColumnTitle();
    }

    @Override
    public int getColumnCount() {
        return ColumnInfo.values().length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        JobTableRowModel jobTableRowModel = this.fTableData.get(n);
        switch (ColumnInfo.getColumnInfo(n2)) {
            case ID: {
                return jobTableRowModel.getJobID();
            }
            case USERNAME: {
                return jobTableRowModel.getUsername();
            }
            case SUBMIT_TIME: {
                return jobTableRowModel.getSubmitTime();
            }
            case FINISH_TIME: {
                return jobTableRowModel.getFinishTime();
            }
            case NUM_TASKS: {
                return jobTableRowModel.getNumTasks();
            }
            case STATE: {
                return jobTableRowModel.getJobStateModel();
            }
            case DESCRIPTION: {
                return jobTableRowModel.getDescription();
            }
        }
        return null;
    }

    public boolean isCorruptedWith(int n, JobCorruptionLevel ... jobCorruptionLevelArray) {
        List<JobCorruptionLevel> list = Arrays.asList(jobCorruptionLevelArray);
        for (JobCorruptionInfo jobCorruptionInfo : this.fTableData.get(n).getCorruptionInfo()) {
            if (!list.contains((Object)jobCorruptionInfo.getLevel())) continue;
            return true;
        }
        return false;
    }

    public boolean isHealthy(int n) {
        return this.fTableData.get(n).isHealthy();
    }

    public JobCorruptionInfo[] getCorruptionInfo(int n) {
        return this.fTableData.get(n).getCorruptionInfo();
    }

    void updateTableData(List<JobTableRowModel> list) {
        this.fTableData.clear();
        this.fTableData.addAll(list);
        this.fireTableDataChanged();
    }

    public boolean hasAnyErrors() {
        for (JobTableRowModel jobTableRowModel : this.fTableData) {
            if (jobTableRowModel.getJobStateModel().hasErrors()) {
                return true;
            }
            if (jobTableRowModel.isHealthy()) continue;
            return true;
        }
        return false;
    }
}

