/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.desk;

import com.mathworks.toolbox.distcomp.pmode.SessionCreatedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionCreationListener;
import com.mathworks.toolbox.distcomp.pmode.SessionEndedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionFactory;
import com.mathworks.toolbox.distcomp.pmode.SessionInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionListener;
import com.mathworks.toolbox.distcomp.ui.model.SessionInfoProvider;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;

final class ClientSessionInfoProvider
implements SessionCreationListener,
SessionListener,
SessionInfoProvider {
    private static SessionInfoProvider sInstance = null;
    private SessionInfo fClientSessionInfo;
    private final ReentrantLock fLock = new ReentrantLock();

    private ClientSessionInfoProvider() {
        this.fClientSessionInfo = SessionInfo.NULL_SESSION_INFO;
    }

    @Override
    public void sessionCreated(SessionCreatedEvent sessionCreatedEvent) {
        this.cacheSessionInfo(sessionCreatedEvent);
        sessionCreatedEvent.getSessionService().addSessionListener(this);
    }

    @Override
    public void sessionStarting(SessionEvent sessionEvent) {
        this.cacheSessionInfo(sessionEvent);
    }

    @Override
    public void sessionFailedToStart(SessionEvent sessionEvent) {
        this.cacheSessionInfo(sessionEvent);
    }

    @Override
    public void sessionClosed(SessionEndedEvent sessionEndedEvent) {
        this.cacheSessionInfo(sessionEndedEvent);
        sessionEndedEvent.getSessionService().removeSessionListener(this);
    }

    @Override
    public void sessionErrored(SessionEndedEvent sessionEndedEvent) {
        this.cacheSessionInfo(sessionEndedEvent);
        sessionEndedEvent.getSessionService().removeSessionListener(this);
    }

    @Override
    public void sessionChangedSize(SessionEvent sessionEvent) {
        this.cacheSessionInfo(sessionEvent);
    }

    @Override
    public void sessionChangedIdleTimeout(SessionEvent sessionEvent) {
        this.cacheSessionInfo(sessionEvent);
    }

    @Override
    public void sessionChangedRestartOnClusterChange(SessionEvent sessionEvent) {
        this.cacheSessionInfo(sessionEvent);
    }

    @Override
    public void sessionBusy(SessionEvent sessionEvent) {
        this.cacheSessionInfo(sessionEvent);
    }

    @Override
    public void sessionIdle(SessionEvent sessionEvent) {
        this.cacheSessionInfo(sessionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionInfo getSessionInfo() {
        this.fLock.lock();
        try {
            SessionInfo sessionInfo = this.fClientSessionInfo;
            return sessionInfo;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheSessionInfo(SessionEvent sessionEvent) {
        this.fLock.lock();
        try {
            this.fClientSessionInfo = sessionEvent.getSessionInfo();
        }
        finally {
            this.fLock.unlock();
        }
    }

    static synchronized SessionInfoProvider getInstance() {
        if (sInstance == null) {
            sInstance = new ClientSessionInfoProvider();
            SessionFactory.addSessionCreationListener((SessionCreationListener)((Object)sInstance));
        }
        return sInstance;
    }
}

