/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class DetailsDialog
extends MJDialog {
    private JLabel fMessageLabel;
    private AbstractStyleGuidePanel fDetailsSection;
    private JTextArea fDetailsTextArea;
    private JButton fDetailsButton;
    private JButton fOkButton;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    private static final int UI_WIDTH = 400;
    private static final int UI_HEIGHT = 120;
    private static final int DETAILS_HEIGHT = 150;
    private static boolean QE_FLAG = false;

    public DetailsDialog(String string, String string2, int n, String string3) {
        this.initialize(string, string2, string3, n);
    }

    public DetailsDialog(Frame frame, String string, String string2, int n, String string3) {
        super(frame);
        this.initialize(string, string2, string3, n);
    }

    public DetailsDialog(Dialog dialog, String string, String string2, int n, String string3) {
        super(dialog);
        this.initialize(string, string2, string3, n);
    }

    private void initialize(String string, String string2, String string3, int n) {
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        this.setTitle(string);
        this.setSize(400, 120);
        this.setResizable(false);
        this.setModal(true);
        this.createMessageLabel(string2, n);
        this.createOkButton();
        this.createDetailsButton();
        this.createDetailsSection(string3);
        styleGuidePanel.addLine(this.fMessageLabel);
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{null, this.fOkButton, this.fDetailsButton}}, 0, 0);
        styleGuidePanel.addLine((JComponent)((Object)this.fDetailsSection), 8);
        this.setContentPane((Container)((Object)styleGuidePanel));
        this.setName("DetailsDialog");
        this.fMessageLabel.setName("DetailsDialog.ErrorLabel");
        this.fDetailsTextArea.setName("DetailsDialog.DetailsTextArea");
        this.fDetailsButton.setName("DetailsDialog.DetailsButton");
        this.fOkButton.setName("DetailsDialog.CloseButton");
        if (QE_FLAG) {
            System.out.println("*********************START OF ERROR DETAILS*********************");
            System.out.println(string3);
            System.out.println("*********************END OF ERROR DETAILS*********************");
            this.showDetailsSection(true);
        }
    }

    private void createDetailsSection(String string) {
        this.fDetailsSection = new StyleGuidePanel();
        this.fDetailsSection.setVisible(false);
        this.fDetailsTextArea = new MJTextArea();
        this.fDetailsTextArea.setLineWrap(true);
        this.fDetailsTextArea.setWrapStyleWord(true);
        this.fDetailsTextArea.setEditable(false);
        this.fDetailsTextArea.setText(string);
        this.fDetailsTextArea.setCaretPosition(0);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fDetailsTextArea);
        mJScrollPane.setPreferredSize(new Dimension(400, 150));
        this.fDetailsSection.addLine((JComponent)mJScrollPane, 8);
    }

    private void createDetailsButton() {
        this.fDetailsButton = new MJButton(sRes.getString("errordetailsdialog.detailsbutton.show"));
        this.fDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DetailsDialog.this.showDetailsSection(!DetailsDialog.this.fDetailsSection.isVisible());
            }
        });
    }

    private void showDetailsSection(boolean bl) {
        if (!bl) {
            this.fDetailsButton.setText(sRes.getString("errordetailsdialog.detailsbutton.show"));
        } else {
            this.fDetailsButton.setText(sRes.getString("errordetailsdialog.detailsbutton.hide"));
        }
        this.fDetailsSection.setVisible(bl);
        this.resizeDialog();
    }

    private void resizeDialog() {
        double d = this.getPreferredSize().getHeight();
        Dimension dimension = new Dimension(400, (int)d);
        this.setSize(dimension);
    }

    private void createOkButton() {
        this.fOkButton = new MJButton(sRes.getString("errordetailsdialog.okbutton"));
        this.fOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DetailsDialog.this.setVisible(false);
                DetailsDialog.this.dispose();
            }
        });
    }

    private void createMessageLabel(String string, int n) {
        this.fMessageLabel = new MJLabel();
        ImageIcon imageIcon = null;
        switch (n) {
            case 0: {
                imageIcon = DialogIcon.ERROR_32x32.getIcon();
                break;
            }
            case 1: {
                imageIcon = DialogIcon.INFO_32x32.getIcon();
                break;
            }
            case 2: {
                imageIcon = DialogIcon.WARNING_32x32.getIcon();
                break;
            }
            case 3: {
                imageIcon = DialogIcon.QUESTION_32x32.getIcon();
                break;
            }
            case -1: {
                imageIcon = null;
                break;
            }
            default: {
                assert (false) : "Unknown message type = " + n;
                break;
            }
        }
        this.fMessageLabel.setIcon(imageIcon);
        this.fMessageLabel.setText(DetailsDialog.convertToHtmlString(string));
    }

    private static String convertToHtmlString(String string) {
        String string2 = string;
        string2 = "<html>" + string2 + "</html>";
        return string2;
    }

    public static boolean getQEFlag() {
        return QE_FLAG;
    }

    public static void setQEFlag(boolean bl) {
        QE_FLAG = bl;
    }
}

