/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabIdentifiedMessage;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.Serializable;

public abstract class StorageException
extends MJSException
implements I18nMatlabIdentifiedException {
    private final HasI18nMatlabIdentifiedMessage fMessage;

    public StorageException(I18nMatlabIdentifiedMessageCreator i18nMatlabIdentifiedMessageCreator, Throwable throwable, Object ... objectArray) {
        super(throwable);
        this.fMessage = new BundleMessage(i18nMatlabIdentifiedMessageCreator, objectArray);
    }

    public StorageException(I18nMatlabIdentifiedMessageCreator i18nMatlabIdentifiedMessageCreator, Object ... objectArray) {
        this.fMessage = new BundleMessage(i18nMatlabIdentifiedMessageCreator, objectArray);
    }

    public StorageException(BaseMsgID baseMsgID, Throwable throwable) {
        super(throwable);
        this.fMessage = new CatalogMessage(baseMsgID);
    }

    public StorageException(BaseMsgID baseMsgID) {
        this.fMessage = new CatalogMessage(baseMsgID);
    }

    public String getMessageID() {
        return this.fMessage.getMessageID();
    }

    @Override
    public String getMessage() {
        return this.fMessage.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return this.fMessage.getLocalizedMessage();
    }

    private static class CatalogMessage
    implements HasI18nMatlabIdentifiedMessage,
    Serializable {
        private final I18nMessageCreator fMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fMessageID;

        CatalogMessage(BaseMsgID baseMsgID) {
            this.fMessageID = baseMsgID;
        }

        public String getMessageID() {
            return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
        }

        @Override
        public String getMessage() {
            return this.fMessageCreator.createMessage(this.fMessageID);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fMessageCreator.createLocalizedMessage(this.fMessageID);
        }
    }

    private static class BundleMessage
    implements HasI18nMatlabIdentifiedMessage,
    Serializable {
        private final I18nMatlabIdentifiedMessageCreator fMessageCreator;
        private final Object[] fArguments;

        BundleMessage(I18nMatlabIdentifiedMessageCreator i18nMatlabIdentifiedMessageCreator, Object ... objectArray) {
            this.fMessageCreator = i18nMatlabIdentifiedMessageCreator;
            this.fArguments = objectArray;
        }

        public String getMessageID() {
            return this.fMessageCreator.getMessageID();
        }

        @Override
        public String getMessage() {
            return this.fMessageCreator.createMessage(this.fArguments);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fMessageCreator.createLocalizedMessage(this.fArguments);
        }
    }
}

