/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.H2StorageFactory;
import com.mathworks.toolbox.distcomp.storage.LRUCache;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFile;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileDataStorage;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileFactory;
import com.mathworks.toolbox.distcomp.storage.fileblobs.H2BlobFileStorage;
import java.io.File;
import net.jini.id.Uuid;

public final class OnDiskH2StorageFactory
extends H2StorageFactory {
    private final String fDatabaseDirectory;
    private final int fBlobFileCacheSize;
    private final int fMaxOpenFileHandles;
    private static final String PROTOCOL = "jdbc:h2:";
    private static final String DATABASE_NAME = "database";

    public OnDiskH2StorageFactory(String string, int n, int n2) {
        super(PROTOCOL);
        String string2 = string == null ? System.getProperty("user.dir") : string;
        this.fDatabaseDirectory = string2 + File.separator + DATABASE_NAME;
        this.fBlobFileCacheSize = n;
        this.fMaxOpenFileHandles = n2;
    }

    @Override
    protected String getDatabaseURL() {
        return this.getProtocol() + this.fDatabaseDirectory;
    }

    @Override
    public DataStorage createAppendableLargeDataStorage() throws StorageInitException {
        LRUCache<Uuid, BlobFile> lRUCache = new LRUCache<Uuid, BlobFile>(this.fBlobFileCacheSize);
        BlobFileFactory blobFileFactory = new BlobFileFactory(this.fMaxOpenFileHandles);
        H2BlobFileStorage h2BlobFileStorage = new H2BlobFileStorage(lRUCache, this.getConnectionPool(), blobFileFactory);
        return new BlobFileDataStorage(this.fDatabaseDirectory, h2BlobFileStorage, blobFileFactory);
    }
}

