/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.service.RMISocketFactoryProvider;
import com.mathworks.toolbox.distcomp.service.TrustingTrustedSecureRMIClientSocketFactory;
import com.mathworks.toolbox.distcomp.util.security.SSLContextFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;

public class SecureRMISocketFactoryProvider
implements RMISocketFactoryProvider {
    private KeyStore fKeyStore;
    private char[] fPassword;
    private String fAlias;

    public SecureRMISocketFactoryProvider(KeyStore keyStore, char[] cArray, String string) {
        this.fKeyStore = keyStore;
        this.fPassword = cArray;
        this.fAlias = string;
    }

    @Override
    public RMIClientSocketFactory getClientSocketFactory() {
        try {
            return new TrustingTrustedSecureRMIClientSocketFactory(this.fKeyStore.getCertificate(this.fAlias));
        }
        catch (KeyStoreException keyStoreException) {
            throw new FailedToGetCertificateException(keyStoreException);
        }
    }

    @Override
    public RMIServerSocketFactory getServerSocketFactory() {
        SSLContext sSLContext = new SSLContextFactory().createServerSSLContext(this.fKeyStore, this.fPassword);
        return new SecureServerSocketFactory(sSLContext);
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    private static class SecureServerSocketFactory
    implements RMIServerSocketFactory {
        private ServerSocketFactory fServerSocketFactory;

        SecureServerSocketFactory(SSLContext sSLContext) {
            this.fServerSocketFactory = sSLContext.getServerSocketFactory();
        }

        @Override
        public ServerSocket createServerSocket(int n) throws IOException {
            return this.fServerSocketFactory.createServerSocket(n);
        }

        public boolean equals(Object object) {
            return object != null && this.getClass().equals(object.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class FailedToGetCertificateException
    extends RuntimeException {
        FailedToGetCertificateException(Throwable throwable) {
            super("Failed to get certificate from key store.", throwable);
        }
    }
}

