/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.service.PersistenceDirException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import org.apache.commons.io.FileUtils;

public class PersistentServiceID
extends LogHandler
implements Serializable {
    private transient ReliableLog fPersistenceDir;
    private String fPersistenceDirName;
    private boolean fValuesInitialized = false;
    private Uuid fServiceID;

    public PersistentServiceID(Configuration configuration, String string) throws ConfigurationException, PersistenceDirException {
        String string2 = (String)configuration.getEntry(string, "persistenceDirectory", String.class, (Object)this.tempDirectory());
        File file = new File(string2);
        if (!(!file.exists() ? file.mkdir() : file.isDirectory())) {
            throw new PersistenceDirException((BaseMsgID)new mjs.CreateDirectoryFail(string2), string2);
        }
        this.fPersistenceDirName = string2 + File.separator + "distcomp_service_id_dir";
        try {
            this.fPersistenceDir = new ReliableLog(this.fPersistenceDirName, (LogHandler)this);
        }
        catch (IOException iOException) {
            throw new PersistenceDirException((BaseMsgID)new mjs.CreateDirectoryFail(this.fPersistenceDirName), this.fPersistenceDirName, iOException);
        }
        this.recover();
        if (!this.fValuesInitialized) {
            this.fServiceID = this.getDefaultServiceID();
            this.fValuesInitialized = true;
            this.snapshot();
        }
    }

    public Uuid getServiceID() {
        return this.fServiceID;
    }

    public void snapshot() throws PersistenceDirException {
        try {
            this.fPersistenceDir.snapshot();
        }
        catch (IOException iOException) {
            throw new PersistenceDirException((BaseMsgID)new mjs.WriteFilesFailure(this.fPersistenceDirName), this.fPersistenceDirName, iOException);
        }
    }

    public void recover() throws PersistenceDirException {
        try {
            this.fPersistenceDir.recover();
        }
        catch (IOException iOException) {
            throw new PersistenceDirException((BaseMsgID)new mjs.ReadFilesFailure(this.fPersistenceDirName), this.fPersistenceDirName, iOException);
        }
    }

    public void destroy() {
        this.fPersistenceDir.deletePersistentStore();
        try {
            FileUtils.deleteDirectory((File)new File(this.fPersistenceDirName));
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to delete persistence directory: " + this.fPersistenceDirName, iOException);
        }
    }

    public synchronized void applyUpdate(Object object) throws Exception {
    }

    public synchronized void recover(InputStream inputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.fValuesInitialized = (Boolean)objectInputStream.readObject();
        this.fServiceID = (Uuid)objectInputStream.readObject();
    }

    public synchronized void snapshot(OutputStream outputStream) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this.fValuesInitialized);
        objectOutputStream.writeObject(this.fServiceID);
        objectOutputStream.flush();
    }

    private String tempDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        if (File.separator.equals("\\")) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = 0; i < stringBuffer.length() - 1; ++i) {
                if (stringBuffer.charAt(i) != '\\') continue;
                stringBuffer.insert(i, '\\');
                ++i;
            }
            string = stringBuffer.toString();
        }
        return string + File.separator + "distcomp_tmp_dir";
    }

    private Uuid getDefaultServiceID() {
        return UuidFactory.generate();
    }
}

