/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.CredentialParameter;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.PasswordCredentialDescription;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;

public class SshParameter<V>
extends ParameterImpl<V> {
    private static final String RESOURCE_BASE_NAME = "com.mathworks.toolbox.distcomp.remote.resources.RES_remote";
    private static final ResourceBundle fResourceBundle = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.remote.resources.RES_remote");
    private static final String SSH_KNOWN_HOSTS_KEY = fResourceBundle.getString("SshParameter.KNOWN_HOSTS.KEY");
    private static final String SSH_PORT_KEY = fResourceBundle.getString("SshParameter.PORT.KEY");
    public static final SshParameter<Boolean> STRICT_HOST_KEY_CHECKING = new SshParameter<Boolean>((Parameter.PersistentKey)SshPersistentKey.STRICT_HOST_KEY_CHECKING, false, false, Boolean.class, false);
    public static final SshParameter<File> KNOWN_HOSTS = new SshParameter<File>((Parameter.PersistentKey)SshPersistentKey.KNOWN_HOSTS, false, false, File.class){

        @Override
        public void checkValueImpl(File file) throws InvalidValueException {
            if (file == null) {
                throw new KnownHostNullException(SSH_KNOWN_HOSTS_KEY);
            }
            if (!file.exists()) {
                throw new KnownHostExistenceException(file, SSH_KNOWN_HOSTS_KEY);
            }
            if (!file.isFile()) {
                throw new KnownHostFileException(file, SSH_KNOWN_HOSTS_KEY);
            }
        }
    };
    public static final CredentialParameter SSH_CREDENTIAL;
    public static final int MAX_PORT_NUMBER = 49151;
    public static final int MIN_PORT_NUMBER = 1;
    public static final int DEFAULT_PORT_NUMBER = 22;
    public static final Parameter<Integer> PORT;
    public static final Parameter<Integer> IDLE_SECONDS_BEFORE_DISCONNECT;
    public static final ParameterSet SSH_PARAMETER_SET;

    private SshParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
        super(persistentKey, bl, bl2, clazz, v);
    }

    private SshParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz) {
        super(persistentKey, bl, bl2, clazz);
    }

    @Override
    protected String getSimpleName() {
        return SshParameter.class.getSimpleName();
    }

    static {
        LinkedHashSet<CredentialDescription> linkedHashSet = new LinkedHashSet<CredentialDescription>();
        linkedHashSet.add(PasswordCredentialDescription.INSTANCE);
        linkedHashSet.add(IdentityFileCredentialDescription.INSTANCE);
        SSH_CREDENTIAL = new CredentialParameter((Parameter.PersistentKey)SshPersistentKey.SSH_CREDENTIAL, Collections.unmodifiableSet(linkedHashSet), PasswordCredentialDescription.INSTANCE);
        PORT = new SshParameter<Integer>((Parameter.PersistentKey)SshPersistentKey.PORT, false, false, Integer.class, Integer.valueOf(22)){

            @Override
            public void checkValueImpl(Integer n) throws InvalidValueException {
                if (n == null) {
                    throw new NullPortException(SSH_PORT_KEY);
                }
                if (n < 1 || n > 49151) {
                    throw new InvalidPortException(n, SSH_PORT_KEY);
                }
            }
        };
        IDLE_SECONDS_BEFORE_DISCONNECT = new SshParameter<Integer>((Parameter.PersistentKey)SshPersistentKey.IDLE_SECONDS_BEFORE_DISCONNECT, false, false, Integer.class, Integer.valueOf(300)){

            @Override
            public void checkValueImpl(Integer n) throws InvalidValueException {
                if (n == null) {
                    throw new IdleNullException();
                }
                if (n <= 1) {
                    throw new IdleZeroException(n);
                }
            }
        };
        SSH_PARAMETER_SET = new ParameterSet(SSH_CREDENTIAL, STRICT_HOST_KEY_CHECKING, KNOWN_HOSTS, PORT);
    }

    private static final class IdleZeroException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        IdleZeroException(Object object) {
            this.fBaseMsgID = new remote.IdleZero(object.toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class IdleNullException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID = new remote.IdleNull();

        IdleNullException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class InvalidPortException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        InvalidPortException(Object object, String string) {
            this.fBaseMsgID = new remote.InvalidPort(string, object.toString(), Integer.toString(1), Integer.toString(49151));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class NullPortException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        NullPortException(String string) {
            this.fBaseMsgID = new remote.NullPort(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class KnownHostFileException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        KnownHostFileException(Object object, String string) {
            this.fBaseMsgID = new remote.KnownHostFile(string, object.toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class KnownHostExistenceException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        KnownHostExistenceException(Object object, String string) {
            this.fBaseMsgID = new remote.KnownHostExistence(string, object.toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class KnownHostNullException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        KnownHostNullException(String string) {
            this.fBaseMsgID = new remote.KnownHostNull(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static enum SshPersistentKey implements Parameter.PersistentKey
    {
        SSH_CREDENTIAL,
        STRICT_HOST_KEY_CHECKING,
        KNOWN_HOSTS,
        PORT,
        IDLE_SECONDS_BEFORE_DISCONNECT;

    }
}

