/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.Parameter;

public abstract class ParameterImpl<V>
implements Parameter<V> {
    private final Parameter.PersistentKey fKey;
    private final boolean fRequired;
    private final boolean fPromptFor;
    private final Class<V> fValueClass;
    private final V fSuggestedValue;

    protected ParameterImpl(Parameter.PersistentKey persistentKey, boolean bl, Class<V> clazz) {
        this.fKey = persistentKey;
        this.fRequired = bl;
        this.fPromptFor = true;
        this.fValueClass = clazz;
        this.fSuggestedValue = null;
        this.checkLogic();
    }

    protected ParameterImpl(Parameter.PersistentKey persistentKey, boolean bl, Class<V> clazz, V v) {
        assert (v != null);
        this.fKey = persistentKey;
        this.fRequired = bl;
        this.fPromptFor = true;
        this.fValueClass = clazz;
        this.fSuggestedValue = v;
        this.checkLogic();
    }

    protected ParameterImpl(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz) {
        this.fKey = persistentKey;
        this.fRequired = bl;
        this.fPromptFor = bl2;
        this.fValueClass = clazz;
        this.fSuggestedValue = null;
        this.checkLogic();
    }

    protected ParameterImpl(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
        assert (v != null);
        this.fKey = persistentKey;
        this.fRequired = bl;
        this.fPromptFor = bl2;
        this.fValueClass = clazz;
        this.fSuggestedValue = v;
        this.checkLogic();
    }

    private void checkLogic() {
        if (this.fRequired & !this.fPromptFor & this.fSuggestedValue == null) {
            // empty if block
        }
    }

    @Override
    public final V getSuggestedValue() {
        return this.fSuggestedValue;
    }

    @Override
    public final Parameter.PersistentKey getPersistentKey() {
        return this.fKey;
    }

    @Override
    public final Class<V> getValueClass() {
        return this.fValueClass;
    }

    @Override
    public final boolean isRequired() {
        return this.fRequired;
    }

    @Override
    public final boolean promptFor() {
        return this.fPromptFor;
    }

    @Override
    public final String getIdentifier() {
        return this.getSimpleName() + "." + this.fKey.toString();
    }

    protected abstract String getSimpleName();

    public final String toString() {
        return this.fKey.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ParameterImpl)) {
            return false;
        }
        return this.fKey.equals(((ParameterImpl)object).fKey);
    }

    public int hashCode() {
        return this.fKey.hashCode();
    }

    @Override
    public final void checkValue(Object object) throws InvalidValueException {
        if (object == null) {
            throw new ParameterValueNullException(this);
        }
        assert (this.getValueClass().isInstance(object)) : "The value to check is not an instance of " + this.getValueClass().getSimpleName();
        this.checkValueImpl(object);
    }

    public void checkValueImpl(V v) throws InvalidValueException {
    }

    private static final class ParameterValueNullException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        ParameterValueNullException(Parameter<?> parameter) {
            this.fBaseMsgID = new remote.ParameterValueNull(parameter.getPersistentKey().toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

