/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import java.io.File;
import java.util.Collections;
import java.util.Set;

public final class CopyFromRemoteCommand
implements CopyCommand {
    private final File fLocalFile;
    private final String fRemoteFile;
    private final Set<String> fExcludedPaths;

    public CopyFromRemoteCommand(File file, String string, Set<String> set) {
        this.fLocalFile = file;
        this.fRemoteFile = string;
        this.fExcludedPaths = set;
    }

    public CopyFromRemoteCommand(File file, String string) {
        this(file, string, Collections.emptySet());
    }

    @Override
    public File getLocalFile() {
        return this.fLocalFile;
    }

    @Override
    public String getRemoteFile() {
        return this.fRemoteFile;
    }

    public boolean isExcluded(String string) {
        if (this.fExcludedPaths.contains(string)) {
            return true;
        }
        int n = string.length();
        for (String string2 : this.fExcludedPaths) {
            int n2 = string2.length();
            if (n <= n2 || string.indexOf(string2) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean anyFilesExcluded() {
        return !this.fExcludedPaths.isEmpty();
    }
}

