/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.process;

import com.mathworks.toolbox.distcomp.process.PackageInfo;
import java.io.IOException;

class IoPipe {
    private long fPtr = 0L;

    IoPipe() {
    }

    private void checkPipePtr() throws IOException {
        if (this.fPtr == 0L) {
            throw new IOException("Pipe has been closed.");
        }
    }

    int read() throws IOException {
        this.checkPipePtr();
        return IoPipe.nativeReadNextByte(this.fPtr);
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkPipePtr();
        if (byArray == null) {
            throw new NullPointerException("byte array is null");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return IoPipe.nativeReadByteArray(this.fPtr, byArray, n, n2);
    }

    void write(int n) throws IOException {
        this.checkPipePtr();
        byte by = Integer.valueOf(n).byteValue();
        IoPipe.nativeWriteByte(this.fPtr, by);
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkPipePtr();
        if (byArray == null) {
            throw new NullPointerException("byte array is null");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        IoPipe.nativeWriteByteArray(this.fPtr, byArray, n, n2);
    }

    public void flush() throws IOException {
        this.checkPipePtr();
        IoPipe.nativeFlush(this.fPtr);
    }

    void close() throws IOException {
        if (this.fPtr != 0L) {
            IoPipe.nativeClose(this.fPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            PackageInfo.LOGGER.finest(this.getClass().getSimpleName() + " finalize started");
            this.fPtr = IoPipe.nativeFinalize(this.fPtr);
        }
        finally {
            super.finalize();
        }
    }

    private static native int nativeReadNextByte(long var0);

    private static native int nativeReadByteArray(long var0, byte[] var2, int var3, int var4);

    private static native void nativeWriteByte(long var0, byte var2);

    private static native void nativeWriteByteArray(long var0, byte[] var2, int var3, int var4);

    private static native void nativeFlush(long var0);

    private static native void nativeClose(long var0);

    private static native long nativeFinalize(long var0);
}

