/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.AbstractTask;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.BroadcastTask;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.DefaultTaskEvaluationResult;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.EvaluationResult;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Log;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.RemoteBroadcastFuture;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public abstract class AbstractBroadcastTask
extends AbstractTask
implements BroadcastTask {
    private final RemoteBroadcastFuture fRemoteFuture;

    protected AbstractBroadcastTask(long l, RemoteBroadcastFuture remoteBroadcastFuture) {
        super(l);
        this.fRemoteFuture = remoteBroadcastFuture;
    }

    @Override
    public final String getDiary(Instance instance) {
        return this.fRemoteFuture.getDiary(instance);
    }

    @Override
    public final EvaluationResult getResult(Instance instance) {
        EvaluationResult evaluationResult = null;
        boolean bl = false;
        if (this.getState() == Task.State.FINISHED) {
            while (true) {
                try {
                    Map map = (Map)this.fRemoteFuture.get();
                    evaluationResult = (EvaluationResult)map.get(instance);
                }
                catch (CancellationException | ExecutionException exception) {
                    evaluationResult = new DefaultTaskEvaluationResult(-1L, this.getID(), null, exception);
                }
                catch (InterruptedException interruptedException) {
                    Log.LOGGER.info("Interrupted in AbstractBroadcastTask.getResult for ID " + this.getID());
                    bl = true;
                    continue;
                }
                break;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return evaluationResult;
    }

    @Override
    public final Collection<Instance> getWorkers() {
        return new ArrayList<Instance>(this.fRemoteFuture.getWorkers());
    }

    @Override
    public final RemoteBroadcastFuture getRemoteFuture() {
        return this.fRemoteFuture;
    }
}

