/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.JoinInfo;
import com.mathworks.toolbox.distcomp.util.securesocket.SSLSocketChannel;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;

public final class SSLConnection
extends Connection {
    private final SSLSocketChannel fSSLSocketChannel;

    public SSLConnection(SSLSocketChannel sSLSocketChannel, Instance instance, JoinInfo joinInfo) {
        super(instance, joinInfo);
        this.fSSLSocketChannel = sSLSocketChannel;
    }

    @Override
    public SelectableChannel getSelectableChannel() {
        return this.fSSLSocketChannel.getSelectableChannel();
    }

    public String toString() {
        return "SSLConnection{fRemoteInstance=" + this.getRemoteInstance() + ", fSSLSocketChannel=" + this.fSSLSocketChannel + ", fJoinInfo=" + this.getJoinInfo() + '}';
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName() + " on " + this.fSSLSocketChannel + " to " + this.getRemoteInstance();
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        try {
            return this.fSSLSocketChannel.write(byteBufferArray, n, n2);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException("Buffer overflow while writing to " + this, bufferOverflowException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Buffer underflow while writing to " + this, bufferUnderflowException);
        }
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        try {
            return this.fSSLSocketChannel.write(byteBufferArray);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException("Buffer overflow while writing to " + this, bufferOverflowException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Buffer underflow while writing to " + this, bufferUnderflowException);
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.fSSLSocketChannel.write(byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException("Buffer overflow while writing to " + this, bufferOverflowException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Buffer underflow while writing to " + this, bufferUnderflowException);
        }
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        try {
            return this.fSSLSocketChannel.read(byteBufferArray, n, n2);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException("Buffer overflow while reading from " + this, bufferOverflowException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Buffer underflow while reading from " + this, bufferUnderflowException);
        }
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        try {
            return this.fSSLSocketChannel.read(byteBufferArray);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException("Buffer overflow while reading from " + this, bufferOverflowException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Buffer underflow while reading from " + this, bufferUnderflowException);
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.fSSLSocketChannel.read(byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException("Buffer overflow while reading from " + this, bufferOverflowException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Buffer underflow while reading from " + this, bufferUnderflowException);
        }
    }

    @Override
    public boolean isOpen() {
        return this.fSSLSocketChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        try {
            this.fSSLSocketChannel.close();
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException("Buffer overflow while closing " + this, bufferOverflowException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException("Buffer underflow while closing " + this, bufferUnderflowException);
        }
    }
}

