/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.SSLConnectionFactory;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;

public final class AcceptorSSLSecurityDescription
implements AcceptorSecurityDescription {
    private final SSLContext fAcceptorSSLContext;
    private final boolean fAcceptorUseClientMode;
    private final Certificate fCertificate;

    public AcceptorSSLSecurityDescription(SSLContext sSLContext, boolean bl, Certificate certificate) {
        this.fAcceptorSSLContext = sSLContext;
        this.fAcceptorUseClientMode = bl;
        this.fCertificate = certificate;
    }

    @Override
    public ConnectionFactory createConnectionFactoryForAcceptor() {
        return new SSLConnectionFactory(this.fAcceptorSSLContext, this.fAcceptorUseClientMode);
    }

    @Override
    public ConnectorSecurityDescription createConnectorSecurityDescription() {
        boolean bl = !this.fAcceptorUseClientMode;
        return new ConnectorSSLSecurityDescription(this.fCertificate, bl);
    }

    public String toString() {
        String string = this.fCertificate != null ? ((X509Certificate)this.fCertificate).getSubjectX500Principal().toString() : "not set";
        return "AcceptorSSLSecurityDescription{fAcceptorUseClientMode=" + this.fAcceptorUseClientMode + ", fCertificate=" + string + '}';
    }
}

