/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.io.broker.Log;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.SSLConnectionFactory;
import com.mathworks.toolbox.distcomp.util.security.FatalSecurityException;
import com.mathworks.toolbox.distcomp.util.security.KeyStoreFactory;
import com.mathworks.toolbox.distcomp.util.security.SSLContextFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.SSLContext;

public class BrokeredAcceptorSSLSecurityDescription
implements AcceptorSecurityDescription,
Serializable {
    private final Certificate fCertificate;
    private final boolean fUseClientMode;
    private transient SSLContext fSSLContext;

    public static BrokeredAcceptorSSLSecurityDescription createAcceptorSSLSecurityDescription(UUID uUID, String string) {
        try {
            String string2 = string + uUID.toString();
            char[] cArray = uUID.toString().toCharArray();
            String string3 = "CN=" + string2;
            KeyStore keyStore = new KeyStoreFactory().createKeyStore(string2, cArray, string3, 90);
            SSLContext sSLContext = new SSLContextFactory().createServerSSLContext(keyStore, cArray);
            Certificate certificate = keyStore.getCertificate(string2);
            boolean bl = true;
            return new BrokeredAcceptorSSLSecurityDescription(sSLContext, bl, certificate);
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to create AcceptorSSLSecurityDescription", iOException);
            throw new IllegalStateException(iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to create AcceptorSSLSecurityDescription", generalSecurityException);
            throw new FatalSecurityException(generalSecurityException);
        }
    }

    public BrokeredAcceptorSSLSecurityDescription(SSLContext sSLContext, boolean bl, Certificate certificate) {
        this.fSSLContext = sSLContext;
        this.fCertificate = certificate;
        this.fUseClientMode = bl;
    }

    @Override
    public ConnectionFactory createConnectionFactoryForAcceptor() {
        SSLContextFactory sSLContextFactory = new SSLContextFactory();
        SSLContext sSLContext = sSLContextFactory.createClientSSLContext(this.fCertificate);
        return new SSLConnectionFactory(sSLContext, this.fUseClientMode);
    }

    @Override
    public ConnectorSecurityDescription createConnectorSecurityDescription() {
        if (this.fSSLContext != null) {
            return new BrokeredConnectorSSLSecurityDescription(this.fSSLContext, !this.fUseClientMode);
        }
        return new NeverUseThisConnectorSecurityDescription();
    }

    public String toString() {
        String string = this.fCertificate == null ? "not set" : ((X509Certificate)this.fCertificate).getSubjectX500Principal().toString();
        return "BrokeredAcceptorSSLSecurityDescription{fCertificate=" + string + ", fUseClientMode=" + this.fUseClientMode + ", fSSLContext=" + this.fSSLContext + '}';
    }

    private static class NeverUseThisConnectorSecurityDescription
    implements ConnectorSecurityDescription,
    Serializable {
        private NeverUseThisConnectorSecurityDescription() {
        }

        @Override
        public ConnectionFactory createConnectionFactoryForConnector() {
            throw new IllegalStateException("Can not call createConnectionFactoryForConnector on this ConnectorSecurityDescription. In a brokered MATLAB pool this client initiated the conversation and so already has the correct ConnectorSecurityDescription");
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        public String toString() {
            return "NeverUseThisConnectorSecurityDescription";
        }
    }
}

