/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.io.DirectCommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.io.Log;
import com.mathworks.toolbox.distcomp.pmode.io.ResponseTracker;
import com.mathworks.toolbox.distcomp.pmode.io.RoutingTable;
import com.mathworks.toolbox.distcomp.pmode.io.TopologyChangeType;
import com.mathworks.toolbox.distcomp.pmode.io.TopologyMessage;
import com.mathworks.toolbox.distcomp.pmode.io.UnableToSendDueToNoAddressBookEntryException;
import com.mathworks.toolbox.distcomp.pmode.shared.BufferTransferrable;
import com.mathworks.toolbox.distcomp.pmode.shared.CommunicationObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.NoSuchDestinationException;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageRegistry;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.Pair;
import com.mathworks.toolbox.parallel.util.concurrent.Awaitable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;

public class IndirectCommunicationGroup
implements CommunicationGroup {
    private final List<CommunicationObserver> fCommunicationObservers = Collections.synchronizedList(new LinkedList());
    private final DirectCommunicationGroup fDirectCommunicationGroup;
    private final ObservableMessageRegistry fObservableMessageRegistry;
    private final ReentrantLock fRoutingLock = new ReentrantLock();
    private final RoutingTable fRoutingTable;
    private boolean fCanRoute = false;
    private final Set<Instance> fSeenInstances = new HashSet<Instance>();
    private final ResponseTracker<Instance> fResponseTracker = new ResponseTracker();
    private static final Connection[] EMPTY_CONNECTION_ARRAY = new Connection[0];

    private IndirectCommunicationGroup(DirectCommunicationGroup directCommunicationGroup, ObservableMessageRegistry observableMessageRegistry) {
        this.fDirectCommunicationGroup = directCommunicationGroup;
        this.fObservableMessageRegistry = observableMessageRegistry;
        this.fRoutingTable = new RoutingTable(directCommunicationGroup.getLocalInstance());
        this.fSeenInstances.add(directCommunicationGroup.getLocalInstance());
    }

    public static IndirectCommunicationGroup build(ErrorHandler errorHandler, ObservableMessageRegistry observableMessageRegistry, Connection[] connectionArray, Instance instance) {
        ForwardingErrorHandler forwardingErrorHandler = new ForwardingErrorHandler(errorHandler);
        DirectCommunicationGroup directCommunicationGroup = DirectCommunicationGroup.build(forwardingErrorHandler, new NullReturnRegistry(), EMPTY_CONNECTION_ARRAY, instance);
        IndirectCommunicationGroup indirectCommunicationGroup = new IndirectCommunicationGroup(directCommunicationGroup, observableMessageRegistry);
        forwardingErrorHandler.setIndirectCommunicationGroup(indirectCommunicationGroup);
        for (Connection connection : connectionArray) {
            indirectCommunicationGroup.addConnection(connection);
        }
        return indirectCommunicationGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTopologyMessage(TopologyMessage topologyMessage, Instance instance) {
        Log.LOGGER.fine("Got a topology message: " + topologyMessage + " from " + instance);
        this.fRoutingLock.lock();
        try {
            this.fRoutingTable.handleTopologyMessage(topologyMessage);
            if (topologyMessage.getType() == TopologyChangeType.ESTABLISHED_COMMUNICATION) {
                this.fSeenInstances.add(topologyMessage.getSource());
                this.fSeenInstances.addAll(topologyMessage.getTargets());
            }
        }
        finally {
            this.fRoutingLock.unlock();
        }
        ArrayList<CommunicationObserver> arrayList = new ArrayList<CommunicationObserver>(this.fCommunicationObservers);
        if (topologyMessage.getType() == TopologyChangeType.ESTABLISHED_COMMUNICATION) {
            this.notifyListenersCommunicationEstablished(arrayList, topologyMessage.getTargets());
        } else {
            this.notifyListenersCommunicationLost(arrayList, topologyMessage.getTargets());
        }
        this.fResponseTracker.addResponder(instance);
    }

    private void notifyListenersCommunicationLost(List<CommunicationObserver> list, Collection<Instance> collection) {
        for (CommunicationObserver communicationObserver : list) {
            for (Instance instance : collection) {
                communicationObserver.communicationLost(instance, null);
            }
        }
    }

    private void notifyListenersCommunicationEstablished(List<CommunicationObserver> list, Collection<Instance> collection) {
        for (CommunicationObserver communicationObserver : list) {
            for (Instance instance : collection) {
                communicationObserver.communicationEstablished(instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Awaitable setDispatcher(Dispatcher<Message> dispatcher, ExecutorService executorService) {
        this.fRoutingLock.lock();
        try {
            this.fDirectCommunicationGroup.setDispatcher(new ForwardingDispatcher(dispatcher), executorService);
            this.fCanRoute = true;
            this.routePendingInstances();
            ResponseTracker<Instance> responseTracker = this.fResponseTracker;
            return responseTracker;
        }
        finally {
            this.fRoutingLock.unlock();
        }
    }

    private void routePendingInstances() {
        assert (this.fRoutingLock.isHeldByCurrentThread()) : "Cannot route unless lock is held";
        List<Instance> list = this.fDirectCommunicationGroup.getConnectedInstances();
        TopologyMessage topologyMessage = TopologyMessage.buildConnectionEstablished(list, this.getLocalInstance());
        Log.LOGGER.info("routePendingInstances() - sending information to " + list);
        this.fRoutingTable.handleTopologyMessage(topologyMessage);
        this.fResponseTracker.setExpectedResponders(list);
        this.sendTo(list, (Message)topologyMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(Connection connection) {
        this.fRoutingLock.lock();
        try {
            this.fSeenInstances.add(connection.getRemoteInstance());
            this.fDirectCommunicationGroup.addConnection(connection);
            if (this.fCanRoute) {
                List<Instance> list = this.getConnectedInstances();
                HashSet<Instance> hashSet = new HashSet<Instance>(list);
                hashSet.add(connection.getRemoteInstance());
                TopologyMessage topologyMessage = TopologyMessage.buildConnectionEstablished(hashSet, this.getLocalInstance());
                Log.LOGGER.info("Sending topology message from " + this.getLocalInstance() + " now connected to " + connection.getRemoteInstance());
                this.fRoutingTable.handleTopologyMessage(topologyMessage);
                this.sendTo(list, (Message)topologyMessage);
                this.sendTo(connection.getRemoteInstance(), (Message)topologyMessage);
                Log.LOGGER.info("Adding connection info from " + this.getLocalInstance() + " to " + connection.getRemoteInstance());
            }
        }
        finally {
            this.fRoutingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void communicationLost(Instance instance) {
        Log.LOGGER.warning("Lost communication from " + this.getLocalInstance() + " to " + instance);
        this.fRoutingLock.lock();
        try {
            TopologyMessage topologyMessage = TopologyMessage.buildConnectionLost(Arrays.asList(instance));
            this.fRoutingTable.handleTopologyMessage(topologyMessage);
            this.sendTo(this.getConnectedInstances(), (Message)topologyMessage);
            this.notifyListenersCommunicationLost(new ArrayList<CommunicationObserver>(this.fCommunicationObservers), Collections.singleton(instance));
        }
        finally {
            this.fRoutingLock.unlock();
        }
    }

    private void informCommunicationLost(List<Instance> list, Collection<Instance> collection) {
        TopologyMessage topologyMessage = TopologyMessage.buildConnectionLost(collection);
        this.sendTo(list, (Message)topologyMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInstance(Instance instance) {
        this.fRoutingLock.lock();
        try {
            if (this.fDirectCommunicationGroup.getConnectedInstances().contains(instance)) {
                this.fDirectCommunicationGroup.removeInstance(instance);
                this.communicationLost(instance);
            }
        }
        finally {
            this.fRoutingLock.unlock();
        }
    }

    @Override
    public void addCommunicationObserver(CommunicationObserver communicationObserver) {
        this.fCommunicationObservers.add(communicationObserver);
    }

    @Override
    public void removeCommunicationObserver(CommunicationObserver communicationObserver) {
        this.fCommunicationObservers.remove(communicationObserver);
    }

    private ObservableMessage wrap(Instance instance, Collection<Instance> collection, Message message) {
        if (message instanceof BufferTransferrable) {
            return new BufferTransferrableMessageFacade(instance, collection, (BufferTransferrable)((Object)message));
        }
        return new PlainMessageFacade(instance, collection, message);
    }

    private void sendToWithObserverImpl(Instance instance, List<Instance> list, ObservableMessage observableMessage, MessageObserver messageObserver) {
        new MessageRouting(list, observableMessage).sendWithObserver(instance, observableMessage, messageObserver);
    }

    private List<Instance> sendToImpl(Instance instance, Collection<Instance> collection, Message message) {
        return new MessageRouting(collection, message).send(instance, message);
    }

    private void forwardTo(Instance instance, List<Instance> list, Message message) {
        List<Instance> list2 = this.sendToImpl(instance, list, message);
        HashSet<Instance> hashSet = new HashSet<Instance>(list);
        hashSet.removeAll(list2);
        if (!hashSet.isEmpty()) {
            Log.LOGGER.warning("Missing in action: " + hashSet);
            this.informCommunicationLost(Arrays.asList(instance), hashSet);
        }
    }

    private static <V> Set<V> setUnion(Collection<V> collection, Collection<V> collection2) {
        HashSet<V> hashSet = new HashSet<V>(collection);
        hashSet.addAll(collection2);
        return Collections.unmodifiableSet(hashSet);
    }

    private static <V> Set<V> setDifference(Collection<V> collection, Collection<V> collection2) {
        HashSet<V> hashSet = new HashSet<V>(collection);
        hashSet.removeAll(collection2);
        return Collections.unmodifiableSet(hashSet);
    }

    private static <V> Set<V> setIntersection(Collection<V> collection, Collection<V> collection2) {
        HashSet<V> hashSet = new HashSet<V>(collection);
        hashSet.retainAll(collection2);
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public void sendTo(List<Instance> list, Message message) throws NoSuchDestinationException {
        this.sendToImpl(this.getLocalInstance(), list, message);
    }

    @Override
    public void sendTo(List<Instance> list, ObservableMessage observableMessage, MessageObserver messageObserver) throws NoSuchDestinationException {
        this.sendToWithObserverImpl(this.getLocalInstance(), list, observableMessage, messageObserver);
    }

    @Override
    public void sendTo(Instance instance, ObservableMessage observableMessage, MessageObserver messageObserver) throws NoSuchDestinationException {
        this.sendToWithObserverImpl(this.getLocalInstance(), Arrays.asList(instance), observableMessage, messageObserver);
    }

    @Override
    public void sendTo(Instance instance, Message message) throws NoSuchDestinationException {
        this.sendToImpl(this.getLocalInstance(), Arrays.asList(instance), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStreams() {
        this.fRoutingLock.lock();
        try {
            this.fRoutingTable.clear();
        }
        finally {
            this.fRoutingLock.unlock();
        }
        this.fDirectCommunicationGroup.closeStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Instance> getConnectedInstances() {
        this.fRoutingLock.lock();
        try {
            if (this.fCanRoute) {
                HashSet<Instance> hashSet = new HashSet<Instance>(this.fRoutingTable.getAllKnownInstances());
                hashSet.remove(this.getLocalInstance());
                List<Instance> list = Collections.unmodifiableList(new ArrayList<Instance>(hashSet));
                return list;
            }
            List<Instance> list = Collections.unmodifiableList(new ArrayList<Instance>(this.fDirectCommunicationGroup.getConnectedInstances()));
            return list;
        }
        finally {
            this.fRoutingLock.unlock();
        }
    }

    @Override
    public Instance getLocalInstance() {
        return this.fDirectCommunicationGroup.getLocalInstance();
    }

    @Override
    public void returnTo(List<Instance> list, ReturnMessage returnMessage) throws NoSuchDestinationException {
        this.sendToImpl(this.getLocalInstance(), list, returnMessage);
    }

    @Override
    public void returnTo(Instance instance, ReturnMessage returnMessage) throws NoSuchDestinationException {
        this.sendToImpl(this.getLocalInstance(), Arrays.asList(instance), returnMessage);
    }

    private class MessageRouting {
        private final List<Instance> fExclusivelyDirectDestinations;
        private final List<Instance> fProxyingAndProxiedDestinations;
        private final List<Instance> fProxyingDestinations;
        private final List<Instance> fExpectReturnsFrom;
        private final List<Instance> fOriginalDestinations;

        private List<Instance> send(Instance instance, Message message) {
            this.innerSend(instance, message);
            return this.fExpectReturnsFrom;
        }

        private void sendWithObserver(Instance instance, ObservableMessage observableMessage, MessageObserver messageObserver) {
            messageObserver.expectReturnsFrom(observableMessage.getSequenceNumber(), this.fExpectReturnsFrom);
            IndirectCommunicationGroup.this.fObservableMessageRegistry.addReturnMessageObserver(observableMessage, this.fExpectReturnsFrom, messageObserver);
            this.innerSend(instance, observableMessage);
        }

        private void innerSend(Instance instance, Message message) {
            Log.LOGGER.finer("Send from " + IndirectCommunicationGroup.this.getLocalInstance() + " to " + this.fOriginalDestinations + "\n\tdirectly: " + this.fExclusivelyDirectDestinations + "\n\tindirectly: " + this.fProxyingAndProxiedDestinations + "\n\tindirectly via: " + this.fProxyingDestinations + "\n\texpecting returns from: " + this.fExpectReturnsFrom);
            if (!this.fExclusivelyDirectDestinations.isEmpty()) {
                IndirectCommunicationGroup.this.fDirectCommunicationGroup.sendTo(this.fExclusivelyDirectDestinations, (Message)IndirectCommunicationGroup.this.wrap(instance, this.fExclusivelyDirectDestinations, message));
            }
            if (!this.fProxyingAndProxiedDestinations.isEmpty()) {
                IndirectCommunicationGroup.this.fDirectCommunicationGroup.sendTo(this.fProxyingDestinations, (Message)IndirectCommunicationGroup.this.wrap(instance, this.fProxyingAndProxiedDestinations, message));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MessageRouting(Collection<Instance> collection, Message message) {
            this.fOriginalDestinations = Collections.unmodifiableList(new ArrayList<Instance>(collection));
            IndirectCommunicationGroup.this.fRoutingLock.lock();
            try {
                Set set = IndirectCommunicationGroup.setDifference(collection, IndirectCommunicationGroup.this.fSeenInstances);
                if (!set.isEmpty()) {
                    throw new UnableToSendDueToNoAddressBookEntryException(message, (Instance)set.iterator().next());
                }
                List<Instance> list = IndirectCommunicationGroup.this.fDirectCommunicationGroup.getConnectedInstances();
                Set set2 = IndirectCommunicationGroup.setIntersection(collection, list);
                Set set3 = IndirectCommunicationGroup.setIntersection(IndirectCommunicationGroup.setDifference(collection, set2), IndirectCommunicationGroup.this.fRoutingTable.getAllKnownInstances());
                Pair<Collection<Instance>, Collection<Instance>> pair = IndirectCommunicationGroup.this.fRoutingTable.mapDestinations(set3);
                Collection<Instance> collection2 = pair.getFirst();
                Set set4 = IndirectCommunicationGroup.setDifference(IndirectCommunicationGroup.setUnion(set2, set3), pair.getSecond());
                Set set5 = set2;
                Set set6 = set3;
                if (!set3.isEmpty() && !set2.isEmpty()) {
                    Set set7 = IndirectCommunicationGroup.setIntersection(set2, collection2);
                    Log.LOGGER.fine("Moving instances: " + set7 + " from exclusively-direct to proxying-and-proxied list.");
                    set5 = IndirectCommunicationGroup.setDifference(set2, set7);
                    set6 = IndirectCommunicationGroup.setUnion(set3, set7);
                }
                this.fExclusivelyDirectDestinations = Collections.unmodifiableList(new ArrayList(set5));
                this.fProxyingAndProxiedDestinations = Collections.unmodifiableList(new ArrayList(set6));
                this.fExpectReturnsFrom = Collections.unmodifiableList(new ArrayList(set4));
                this.fProxyingDestinations = Collections.unmodifiableList(new ArrayList<Instance>(collection2));
            }
            finally {
                IndirectCommunicationGroup.this.fRoutingLock.unlock();
            }
        }
    }

    private static class PlainMessageFacade
    extends MessageFacade {
        private final Message fRealMessage;

        private PlainMessageFacade(Instance instance, Collection<Instance> collection, Message message) {
            super(instance, collection);
            this.fRealMessage = message;
        }

        @Override
        Message getOriginal() {
            return this.fRealMessage;
        }
    }

    private static class BufferTransferrableMessageFacade
    extends MessageFacade
    implements BufferTransferrable {
        private final BufferTransferrable fRealMessage;

        private BufferTransferrableMessageFacade(Instance instance, Collection<Instance> collection, BufferTransferrable bufferTransferrable) {
            super(instance, collection);
            assert (bufferTransferrable instanceof Message);
            this.fRealMessage = bufferTransferrable;
        }

        @Override
        public ByteBufferHandle[] getByteBuffers() {
            return this.fRealMessage.getByteBuffers();
        }

        @Override
        public void setByteBuffers(ByteBufferHandle[] byteBufferHandleArray) {
            this.fRealMessage.setByteBuffers(byteBufferHandleArray);
        }

        @Override
        Message getOriginal() {
            return (Message)((Object)this.fRealMessage);
        }
    }

    private static abstract class MessageFacade
    implements ObservableMessage {
        private final Instance fSource;
        private final List<Instance> fDestinations;
        private final long fSequence;

        protected MessageFacade(Instance instance, Collection<Instance> collection) {
            this.fSource = instance;
            this.fDestinations = new ArrayList<Instance>(collection);
            this.fSequence = ObservableMessage.SequenceGenerator.nextID();
        }

        abstract Message getOriginal();

        private Instance getSource() {
            return this.fSource;
        }

        private List<Instance> getDestinations() {
            return Collections.unmodifiableList(this.fDestinations);
        }

        @Override
        public final long getSequenceNumber() {
            return this.fSequence;
        }
    }

    private final class ForwardingDispatcher
    implements Dispatcher<Message> {
        private final Dispatcher<Message> fMessageDispatcher;

        private ForwardingDispatcher(Dispatcher<Message> dispatcher) {
            this.fMessageDispatcher = dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(Message message, Instance instance) {
            if (message instanceof MessageFacade) {
                MessageFacade messageFacade = (MessageFacade)message;
                Message message2 = messageFacade.getOriginal();
                Instance instance2 = messageFacade.getSource();
                List list = messageFacade.getDestinations();
                Instance instance3 = IndirectCommunicationGroup.this.getLocalInstance();
                ArrayList<Instance> arrayList = new ArrayList<Instance>(list);
                boolean bl = arrayList.remove(instance3);
                IndirectCommunicationGroup.this.fRoutingLock.lock();
                try {
                    IndirectCommunicationGroup.this.fRoutingTable.filterForwardList(instance, arrayList);
                }
                finally {
                    IndirectCommunicationGroup.this.fRoutingLock.unlock();
                }
                if (!arrayList.isEmpty()) {
                    Log.LOGGER.fine("IndirectCommunicationGroup: Forwarding of " + message2 + " to " + arrayList);
                    IndirectCommunicationGroup.this.forwardTo(instance2, arrayList, message2);
                }
                if (bl) {
                    Log.LOGGER.fine("IndirectCommunicationGroup: Redispatch of " + message2 + " from " + instance2);
                    this.redispatch(message2, instance2);
                }
            } else {
                Log.LOGGER.warning("IndirectCommunicationGroup unexpectedly received message of class: " + message.getClass());
                assert (false) : "Unexpectedly did not get MessageFacade";
            }
        }

        private void redispatch(Message message, Instance instance) {
            if (message instanceof TopologyMessage) {
                IndirectCommunicationGroup.this.handleTopologyMessage((TopologyMessage)message, instance);
            } else {
                this.fMessageDispatcher.dispatch(message, instance);
            }
        }
    }

    private static class ForwardingErrorHandler
    implements ErrorHandler {
        private IndirectCommunicationGroup fCommunicationGroup = null;
        private final ErrorHandler fErrorHandler;

        private ForwardingErrorHandler(ErrorHandler errorHandler) {
            this.fErrorHandler = errorHandler;
        }

        private void setIndirectCommunicationGroup(IndirectCommunicationGroup indirectCommunicationGroup) {
            this.fCommunicationGroup = indirectCommunicationGroup;
        }

        @Override
        public void readError(Instance instance, Throwable throwable) {
            this.fErrorHandler.readError(instance, throwable);
        }

        @Override
        public void writeError(Instance instance, Throwable throwable) {
            this.fErrorHandler.writeError(instance, throwable);
        }

        @Override
        public void lostCommunication(Instance instance, Throwable throwable) {
            this.fCommunicationGroup.communicationLost(instance);
            this.fErrorHandler.lostCommunication(instance, throwable);
        }

        @Override
        public void executorError(Throwable throwable) {
            this.fErrorHandler.executorError(throwable);
        }

        @Override
        public void communicationError(Error error) {
            this.fErrorHandler.communicationError(error);
        }

        @Override
        public void activate(ShutdownHandler shutdownHandler) {
            this.fErrorHandler.activate(shutdownHandler);
        }

        @Override
        public void deactivate() {
            this.fErrorHandler.deactivate();
        }
    }

    private static class NullReturnRegistry
    implements ObservableMessageRegistry {
        private final Dispatcher<ReturnMessage> fNullDispatcher = new NullReturnDispatcher();

        private NullReturnRegistry() {
        }

        @Override
        public void addReturnMessageObserver(ObservableMessage observableMessage, Collection<Instance> collection, MessageObserver messageObserver) {
            assert (false);
        }

        @Override
        public Dispatcher<ReturnMessage> getDispatcher() {
            return this.fNullDispatcher;
        }

        @Override
        public void destroy() {
        }

        private static class NullReturnDispatcher
        implements Dispatcher<ReturnMessage> {
            private NullReturnDispatcher() {
            }

            @Override
            public void dispatch(ReturnMessage returnMessage, Instance instance) {
                assert (false);
            }
        }
    }
}

