/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.CmdExecResults;
import com.mathworks.toolbox.distcomp.pmode.CmdWinOutput;
import com.mathworks.toolbox.distcomp.pmode.LabsStateTracker;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.RemoteResultsHandler;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

class RemoteResultsHandlerImpl
implements RemoteResultsHandler {
    private final ExecutorService fListenerExec;
    private final ErrorHandler fErrorHandler;
    private final LabsStateTracker fLabsStateTracker;
    private long fSequenceNumber;
    private LabsCompletionObserver fCmdObserver;

    RemoteResultsHandlerImpl(SessionService sessionService, LabsStateTracker labsStateTracker) {
        this.fListenerExec = sessionService.getListenerExecutor();
        this.fLabsStateTracker = labsStateTracker;
        this.fErrorHandler = sessionService.getErrorHandler();
        this.fSequenceNumber = -1L;
        this.fCmdObserver = null;
    }

    @Override
    public synchronized void handleOutput(final CmdWinOutput cmdWinOutput, final ProcessInstance processInstance) {
        assert (cmdWinOutput != null) : "Command window output object must not be null.";
        final LabsCompletionObserver labsCompletionObserver = this.getObserver(cmdWinOutput.getOriginalSequenceNumber());
        try {
            this.fListenerExec.execute(new Runnable(){

                @Override
                public void run() {
                    PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Command " + cmdWinOutput.getOriginalSequenceNumber() + " on lab " + processInstance + " returned the output:\n" + cmdWinOutput.toString());
                    if (labsCompletionObserver != null && cmdWinOutput.fWinOutput != null) {
                        for (int i = 0; i < cmdWinOutput.fWinOutput.length; ++i) {
                            try {
                                labsCompletionObserver.handleOutput(cmdWinOutput.fWinOutput[i], processInstance);
                                continue;
                            }
                            catch (Throwable throwable) {
                                PackageInfo.LOGGER.log(DistcompLevel.ONE, "LabsCompletionObserver threw a Throwable.", throwable);
                            }
                        }
                    }
                    RemoteResultsHandlerImpl.this.fLabsStateTracker.outputArrived(cmdWinOutput.getOriginalSequenceNumber(), processInstance);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.fErrorHandler.executorError(rejectedExecutionException);
        }
    }

    @Override
    public synchronized void handleExecStatus(CmdExecResults cmdExecResults, final ProcessInstance processInstance) {
        assert (cmdExecResults != null) : "Command exec results object must not be null.";
        final long l = cmdExecResults.getOriginalSequenceNumber();
        final LabsCompletionObserver labsCompletionObserver = this.getObserver(l);
        final int n = cmdExecResults.getRawStatus();
        try {
            this.fListenerExec.execute(new Runnable(){

                @Override
                public void run() {
                    PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Command " + l + " on lab " + processInstance + " finished with status:\n" + n);
                    if (labsCompletionObserver != null) {
                        try {
                            labsCompletionObserver.handleExecStatus(n, processInstance);
                        }
                        catch (Throwable throwable) {
                            PackageInfo.LOGGER.log(DistcompLevel.ONE, "LabsCompletionObserver threw a Throwable.", throwable);
                        }
                    }
                    RemoteResultsHandlerImpl.this.fLabsStateTracker.statusArrived(n, l, processInstance);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.fErrorHandler.executorError(rejectedExecutionException);
        }
    }

    @Override
    public void handleLabAborted(long l, ProcessInstance processInstance) {
        LabsCompletionObserver labsCompletionObserver = this.getObserver(l);
        if (labsCompletionObserver != null) {
            labsCompletionObserver.handleLabAborted(processInstance);
        }
    }

    @Override
    public void handleExpectReturns(long l, List<ProcessInstance> list) {
        LabsCompletionObserver labsCompletionObserver = this.getObserver(l);
        if (labsCompletionObserver != null) {
            labsCompletionObserver.handleLabList(list);
        }
    }

    @Override
    public synchronized void setCurrentCommand(long l, LabsCompletionObserver labsCompletionObserver) {
        this.fSequenceNumber = l;
        this.fCmdObserver = labsCompletionObserver;
    }

    private synchronized LabsCompletionObserver getObserver(long l) {
        if (this.fSequenceNumber == l) {
            return this.fCmdObserver;
        }
        return null;
    }
}

