/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.MFevalLargeDataCommand;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.SingleRemoteEvaluationObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleOutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.io.Serializable;
import java.nio.LongBuffer;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public final class RemoteCompositeAssistant {
    private final ConcurrentMap<ProcessInstance, ConcurrentLinkedQueue<Long>> fProc2Keys = new ConcurrentHashMap<ProcessInstance, ConcurrentLinkedQueue<Long>>();
    private final SessionService fSession;
    private final RoleOutputGroup fComms;

    RemoteCompositeAssistant(SessionService sessionService) {
        this.fSession = sessionService;
        this.fComms = sessionService.getRoleCommGroup();
    }

    public SingleRemoteEvaluationObserver retrieveCompositeValue(ProcessInstance processInstance, Object object) {
        assert (this.fSession.isSessionRunning()) : "No session to retrieve value";
        MFevalLargeDataCommand mFevalLargeDataCommand = new MFevalLargeDataCommand("spmdlang.remoteRetrieval", new Object[]{object, this.returnRemoteClearKeys(processInstance)}, 2);
        SingleRemoteEvaluationObserver singleRemoteEvaluationObserver = new SingleRemoteEvaluationObserver();
        this.fComms.sendTo(processInstance, (ObservableMessage)mFevalLargeDataCommand, (RoleMessageObserver)singleRemoteEvaluationObserver);
        return singleRemoteEvaluationObserver;
    }

    public SingleRemoteEvaluationObserver sendCompositeValue(ProcessInstance processInstance, ByteBufferHandle[] byteBufferHandleArray) {
        assert (this.fSession.isSessionRunning()) : "No session to retrieve value";
        MFevalLargeDataCommand mFevalLargeDataCommand = new MFevalLargeDataCommand("spmdlang.remoteStore", new Object[]{byteBufferHandleArray, this.returnRemoteClearKeys(processInstance)}, 2);
        SingleRemoteEvaluationObserver singleRemoteEvaluationObserver = new SingleRemoteEvaluationObserver();
        this.fComms.sendTo(processInstance, (ObservableMessage)mFevalLargeDataCommand, (RoleMessageObserver)singleRemoteEvaluationObserver);
        for (ByteBufferHandle byteBufferHandle : byteBufferHandleArray) {
            byteBufferHandle.free();
        }
        return singleRemoteEvaluationObserver;
    }

    public void notifyRemoteClear(ProcessInstance processInstance, long l) {
        if (!this.fProc2Keys.containsKey(processInstance)) {
            ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
            this.fProc2Keys.putIfAbsent(processInstance, concurrentLinkedQueue);
        }
        ((ConcurrentLinkedQueue)this.fProc2Keys.get(processInstance)).add(l);
    }

    public Object returnRemoteClearKeys(ProcessInstance processInstance) {
        ConcurrentLinkedQueue<Long> concurrentLinkedQueue = this.fProc2Keys.replace(processInstance, new ConcurrentLinkedQueue());
        if (concurrentLinkedQueue == null || concurrentLinkedQueue.isEmpty()) {
            return null;
        }
        return LongArrayHolder.build(concurrentLinkedQueue);
    }

    private static final class LongArrayHolder
    implements Serializable {
        private long[] fArray;

        private LongArrayHolder(long[] lArray) {
            this.fArray = lArray;
        }

        static LongArrayHolder build(Queue<Long> queue) {
            LongBuffer longBuffer = LongBuffer.allocate(queue.size());
            Iterator iterator = queue.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                longBuffer.put(l);
            }
            return new LongArrayHolder(longBuffer.array());
        }

        public long[] array() {
            return this.fArray;
        }
    }
}

