/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJTable;
import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SimulatedLabs
implements Labs {
    private int fLabCount;
    private boolean[] fIsCommandIncomplete;
    private boolean[] fBreakNext;
    private int[] fDelay;
    private Random fRandom = new Random();
    private LabsCompletionObserver fLastObserver;
    private volatile boolean fGenerateOutput;
    private int fLinesToSend;
    private int[] fLinesSent;
    private JFrame fUIFrame;
    private Thread[] fResponseThread;
    private BlockingQueue<ActionListener>[] fResponseQueue;
    private boolean fQuitThreads;
    private static final String[] sMagic = new String[]{"", "ans =\n     8     1     6\n     3     5     7\n     4     9     2\n", "ans =\n    16     2     3    13\n     5    11    10     8\n     9     7     6    12\n     4    14    15     1\n", "ans =\n    17    24     1     8    15\n    23     5     7    14    16\n     4     6    13    20    22\n    10    12    19    21     3\n    11    18    25     2     9\n", "ans =\n    35     1     6    26    19    24\n     3    32     7    21    23    25\n    31     9     2    22    27    20\n     8    28    33    17    10    15\n    30     5    34    12    14    16\n     4    36    29    13    18    11\n"};
    private static final String[][] sEigs = new String[][]{{""}, {"Iteration 1: a few Ritz values of the 20-by-20 matrix:\n     0\n     0\n     0\n     0\n     0\n     0\n     0\n", "Iteration 2: a few Ritz values of the 20-by-20 matrix:\n  -0.7519 + 0.9820i\n  -1.2905          \n   1.0604 - 0.8267i\n   1.0604 + 0.8267i\n  -1.1263 - 0.8053i\n  -1.1263 + 0.8053i\n  11.9631          \n", "Iteration 3: a few Ritz values of the 20-by-20 matrix:\n  -0.7515 - 0.9834i\n  -1.2902          \n   1.0606 - 0.8269i\n   1.0606 + 0.8269i\n  -1.1262 + 0.8049i\n  -1.1262 - 0.8049i\n  11.9631          \n", "Iteration 4: a few Ritz values of the 20-by-20 matrix:\n  -0.7515 - 0.9834i\n  -1.2902          \n   1.0606 - 0.8269i\n   1.0606 + 0.8269i\n  -1.1262 - 0.8049i\n  -1.1262 + 0.8049i\n  11.9631          \n", "Iteration 5: a few Ritz values of the 20-by-20 matrix:\n  -0.7515 + 0.9834i\n  -1.2902          \n   1.0606 - 0.8269i\n   1.0606 + 0.8269i\n  -1.1262 + 0.8049i\n  -1.1262 - 0.8049i\n  11.9631          \n", "Iteration 6: a few Ritz values of the 20-by-20 matrix:\n  -0.7515 + 0.9834i\n  -1.2902          \n   1.0606 - 0.8269i\n   1.0606 + 0.8269i\n  -1.1262 - 0.8049i\n  -1.1262 + 0.8049i\n  11.9631          \n", "Iteration 7: a few Ritz values of the 20-by-20 matrix:\n  -0.7515 + 0.9834i\n  -1.2902          \n   1.0606 - 0.8269i\n   1.0606 + 0.8269i\n  -1.1262 + 0.8049i\n  -1.1262 - 0.8049i\n  11.9631          \n", "\nans =\n\n  11.9631          \n  -1.1262 - 0.8049i\n  -1.1262 + 0.8049i\n   1.0606 - 0.8269i\n   1.0606 + 0.8269i\n  -1.2902          \n"}, {"Iteration 1: a few Ritz values of the 20-by-20 matrix:\n     0\n     0\n     0\n     0\n     0\n     0\n     0\n", "Iteration 2: a few Ritz values of the 20-by-20 matrix:\n  -1.2315 - 0.3464i\n  -1.2315 + 0.3464i\n   0.3733 - 1.2347i\n   0.3733 + 1.2347i\n   1.2809 - 0.4274i\n   1.2809 + 0.4274i\n  12.1940          \n", "Iteration 3: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 - 0.3460i\n  -1.2312 + 0.3460i\n   0.3731 - 1.2353i\n   0.3731 + 1.2353i\n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n  12.1940          \n", "Iteration 4: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 - 0.3460i\n  -1.2312 + 0.3460i\n   0.3731 - 1.2353i\n   0.3731 + 1.2353i\n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n  12.1940          \n", "Iteration 5: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 - 0.3460i\n  -1.2312 + 0.3460i\n   0.3731 - 1.2353i\n   0.3731 + 1.2353i\n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n  12.1940          \n", "Iteration 6: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 + 0.3460i\n  -1.2312 - 0.3460i\n   0.3731 + 1.2353i\n   0.3731 - 1.2353i\n   1.2809 + 0.4275i\n   1.2809 - 0.4275i\n  12.1940          \n", "Iteration 7: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 - 0.3460i\n  -1.2312 + 0.3460i\n   0.3731 - 1.2353i\n   0.3731 + 1.2353i\n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n  12.1940          \n", "\nans =\n\n  12.1940          \n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n   0.3731 + 1.2353i\n   0.3731 - 1.2353i\n  -1.2312 + 0.3460i\n"}, {"Iteration 1: a few Ritz values of the 20-by-20 matrix:\n     0\n     0\n     0\n     0\n     0\n     0\n     0\n", "Iteration 2: a few Ritz values of the 20-by-20 matrix:\n  -1.2315 - 0.3464i\n  -1.2315 + 0.3464i\n   0.3733 - 1.2347i\n   0.3733 + 1.2347i\n   1.2809 - 0.4274i\n   1.2809 + 0.4274i\n  12.1940          \n", "Iteration 3: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 - 0.3460i\n  -1.2312 + 0.3460i\n   0.3731 - 1.2353i\n   0.3731 + 1.2353i\n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n  12.1940          \n", "Iteration 4: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 - 0.3460i\n  -1.2312 + 0.3460i\n   0.3731 - 1.2353i\n   0.3731 + 1.2353i\n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n  12.1940          \n", "Iteration 5: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 - 0.3460i\n  -1.2312 + 0.3460i\n   0.3731 - 1.2353i\n   0.3731 + 1.2353i\n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n  12.1940          \n", "Iteration 6: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 + 0.3460i\n  -1.2312 - 0.3460i\n   0.3731 + 1.2353i\n   0.3731 - 1.2353i\n   1.2809 + 0.4275i\n   1.2809 - 0.4275i\n  12.1940          \n", "Iteration 7: a few Ritz values of the 20-by-20 matrix:\n  -1.2312 - 0.3460i\n  -1.2312 + 0.3460i\n   0.3731 - 1.2353i\n   0.3731 + 1.2353i\n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n  12.1940          \n", "\nans =\n\n  12.1940          \n   1.2809 - 0.4275i\n   1.2809 + 0.4275i\n   0.3731 + 1.2353i\n   0.3731 - 1.2353i\n  -1.2312 + 0.3460i\n"}, {"Iteration 1: a few Ritz values of the 20-by-20 matrix:\n     0\n     0\n     0\n     0\n     0\n     0\n     0\n", "Iteration 2: a few Ritz values of the 20-by-20 matrix:\n   0.6075 - 1.0659i\n   1.2206 + 0.3327i\n   1.2206 - 0.3327i\n  -1.4174          \n  -1.2059 + 1.0237i\n  -1.2059 - 1.0237i\n  11.7877          \n", "Iteration 3: a few Ritz values of the 20-by-20 matrix:\n   0.6069 + 1.0650i\n   1.2209 - 0.3324i\n   1.2209 + 0.3324i\n  -1.4175          \n  -1.2059 - 1.0237i\n  -1.2059 + 1.0237i\n  11.7877          \n", "Iteration 4: a few Ritz values of the 20-by-20 matrix:\n   0.6069 + 1.0650i\n   1.2209 + 0.3324i\n   1.2209 - 0.3324i\n  -1.4175          \n  -1.2059 + 1.0237i\n  -1.2059 - 1.0237i\n  11.7877          \n", "Iteration 5: a few Ritz values of the 20-by-20 matrix:\n   0.6069 + 1.0650i\n   1.2209 - 0.3324i\n   1.2209 + 0.3324i\n  -1.4175          \n  -1.2059 - 1.0237i\n  -1.2059 + 1.0237i\n  11.7877          \n", "Iteration 6: a few Ritz values of the 20-by-20 matrix:\n   0.6069 - 1.0650i\n   1.2209 - 0.3324i\n   1.2209 + 0.3324i\n  -1.4175          \n  -1.2059 - 1.0237i\n  -1.2059 + 1.0237i\n  11.7877          \n", "\nans =\n\n  11.7877          \n  -1.2059 + 1.0237i\n  -1.2059 - 1.0237i\n  -1.4175          \n   1.2209 + 0.3324i\n   1.2209 - 0.3324i\n"}};
    private static final int LAB_COLUMN = 0;
    private static final int BREAK_NEXT_COLUMN = 1;
    private static final int DELAY_COLUMN = 2;
    private static final int COLUMN_COUNT = 3;
    private static int[] COLUMN_WIDTH = new int[]{40, 70, 50};
    private static String[] COLUMN_NAME = new String[]{"Lab", "Break Next", "Delay"};
    private static Class[] COLUMN_CLASS = new Class[]{Integer.class, Boolean.class, Integer.class};

    SimulatedLabs(int n) {
        this.fLabCount = n;
        this.fIsCommandIncomplete = new boolean[n + 1];
        this.fBreakNext = new boolean[n + 1];
        this.fDelay = new int[n + 1];
        this.fLinesSent = new int[n + 1];
        this.fResponseThread = new Thread[n + 1];
        this.fResponseQueue = new BlockingQueue[n + 1];
        for (int i = 1; i <= n; ++i) {
            this.fResponseQueue[i] = new LinkedBlockingQueue<ActionListener>();
            this.fResponseThread[i] = new Thread(new Responder(i));
            this.fResponseThread[i].setDaemon(true);
            this.fResponseThread[i].start();
        }
    }

    void cleanup() {
        this.fQuitThreads = true;
        this.fGenerateOutput = false;
        for (int i = 1; i <= this.fLabCount; ++i) {
            ResponseAction responseAction = new ResponseAction("", i, 0, null);
            this.fResponseQueue[i].offer(responseAction);
            try {
                this.fResponseThread[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getNumLabs() {
        return this.fLabCount;
    }

    @Override
    public List<ProcessInstance> getLabInstances() {
        return Arrays.asList(ProcessInstance.getAllLabs(this.fLabCount));
    }

    @Override
    public void interrupt() {
        this.fGenerateOutput = false;
        IntSet intSet = new IntSet(1, this.fLabCount);
        if (this.fLastObserver != null) {
            for (Integer n : intSet) {
                this.fLastObserver.handleExecStatus(0, ProcessInstance.getLabInstance(n));
            }
        }
    }

    @Override
    public void interrupt(LabsCompletionObserver labsCompletionObserver) {
        this.interrupt();
    }

    @Override
    public void interruptAndRemovePendingCommands() {
        this.interrupt();
    }

    @Override
    public void interruptAndRemovePendingCommands(LabsCompletionObserver labsCompletionObserver) {
        this.interrupt();
    }

    @Override
    public void eval(String string, LabsCompletionObserver labsCompletionObserver) {
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                this.evalLine(string2, labsCompletionObserver);
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void evalLine(String string, LabsCompletionObserver labsCompletionObserver) {
        int n;
        IntSet intSet = new IntSet(1, this.fLabCount);
        this.fLastObserver = labsCompletionObserver;
        if ("clc".equals(string)) {
            for (Integer n2 : intSet) {
                ParallelUI.clearOutput(n2);
            }
            return;
        }
        if ("exit".equals(string) || "quit".equals(string) || "pmode exit".equals(string) || string != null && string.startsWith("quit ")) {
            ParallelUI.stop();
            return;
        }
        assert (string != null) : "null command";
        if (string.startsWith("pound")) {
            int n3;
            n = -1;
            for (n3 = 5; n3 < string.length() && !Character.isDigit(string.charAt(n3)); ++n3) {
            }
            if (n3 < string.length()) {
                int n4;
                for (n4 = n3; n4 < string.length() && Character.isDigit(string.charAt(n4)); ++n4) {
                }
                n = Integer.parseInt(string.substring(n3, n4));
            }
            this.fGenerateOutput = true;
            for (Integer n5 : intSet) {
                int n6 = n5;
                if (n != -1 && n != n6) continue;
                ResponseAction responseAction = new ResponseAction("pound", n6, 0, labsCompletionObserver);
                this.fResponseQueue[n6].offer(responseAction);
            }
        } else if (string.startsWith("lines")) {
            for (n = 5; n < string.length() && !Character.isDigit(string.charAt(n)); ++n) {
            }
            if (n < string.length()) {
                int n7;
                for (n7 = n; n7 < string.length() && Character.isDigit(string.charAt(n7)); ++n7) {
                }
                this.fLinesToSend = Integer.parseInt(string.substring(n, n7));
            }
            for (Object object : intSet) {
                int n8 = (Integer)object;
                this.fLinesSent[n8] = 0;
                ResponseAction responseAction = new ResponseAction("lines", n8, 0, labsCompletionObserver);
                this.fResponseQueue[n8].offer(responseAction);
            }
        }
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        while (intSetIterator.hasNext()) {
            Object object;
            int n9 = intSetIterator.nextInt();
            if (n9 < 0 || n9 > this.fLabCount) {
                throw new IllegalArgumentException("Lab index " + n9 + " out of range [0, " + this.fLabCount + "]");
            }
            object = this.getResponse(string, n9);
            int n10 = (object instanceof String && ((String)object).startsWith("???") ? 2 : 0) << 16;
            if (this.fIsCommandIncomplete[n9]) {
                n10 |= 1;
            }
            ResponseAction responseAction = new ResponseAction(object, n9, n10, labsCompletionObserver);
            this.fResponseQueue[n9].offer(responseAction);
        }
    }

    private Object getResponse(String string, int n) {
        if (string.startsWith("end")) {
            this.fIsCommandIncomplete[n] = false;
            return null;
        }
        if (this.fIsCommandIncomplete[n]) {
            return null;
        }
        if (string == null || string.length() > 0 && string.charAt(string.length() - 1) == ';') {
            return null;
        }
        if (string.length() == 0) {
            return "\n";
        }
        if ("numLabs".equalsIgnoreCase(string)) {
            Formatter formatter = new Formatter();
            formatter.format("%6d", this.fLabCount);
            return "ans =\n" + formatter.toString() + "\n";
        }
        if ("labIndex".equalsIgnoreCase(string)) {
            Formatter formatter = new Formatter();
            formatter.format("%6d", n);
            return "ans =\n" + formatter.toString() + "\n";
        }
        if (string.startsWith("if") || string.startsWith("for")) {
            this.fIsCommandIncomplete[n] = true;
            return null;
        }
        if (string.startsWith("magic")) {
            if (n >= sMagic.length) {
                n = sMagic.length - 1;
            }
            return sMagic[n];
        }
        if (string.startsWith("eigs")) {
            if (n >= sEigs.length) {
                n = sEigs.length - 1;
            }
            return sEigs[n];
        }
        if (string.startsWith("rand(")) {
            int n2;
            for (n2 = 5; n2 < string.length() && Character.isDigit(string.charAt(n2)); ++n2) {
            }
            int n3 = Integer.parseInt(string.substring(5, n2));
            return this.randomMatrix(n3);
        }
        if (string.startsWith("link ")) {
            String string2 = string.substring(5, string.length());
            return "<a href=\"" + string2 + "\">target</a>";
        }
        if (string.startsWith("lines")) {
            return null;
        }
        if (string.equals("stop")) {
            this.fGenerateOutput = false;
            return null;
        }
        if (string.startsWith("disp")) {
            return string.substring(5, string.length());
        }
        if (string.startsWith("backspace")) {
            int n4;
            for (n4 = 9; n4 < string.length() && !Character.isDigit(string.charAt(n4)); ++n4) {
            }
            if (n4 < string.length()) {
                int n5;
                for (n5 = n4; n5 < string.length() && Character.isDigit(string.charAt(n5)); ++n5) {
                }
                int n6 = Integer.parseInt(string.substring(n4, n5));
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n6; ++i) {
                    stringBuilder.append('\b');
                }
                if (n5 < string.length()) {
                    stringBuilder.append(string.substring(n5 + 1, string.length()));
                }
                return stringBuilder.toString();
            }
            return "\n";
        }
        if (string.toLowerCase().startsWith("bad")) {
            return "??? Undefined function or variable 'bad'.\n";
        }
        return "response to " + string + " from lab " + n + "\n";
    }

    private String randomMatrix(int n) {
        StringBuilder stringBuilder = new StringBuilder(n * (n + 1) + 10);
        Formatter formatter = new Formatter(stringBuilder);
        stringBuilder.append("\nans =\n");
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                formatter.format("%10.4f", Float.valueOf(this.fRandom.nextFloat()));
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    void showUI() {
        MJTable mJTable = new MJTable(new SettingsTableModel()){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JLabel) {
                    ((JLabel)component).setHorizontalAlignment(0);
                }
                return component;
            }

            public Dimension getPreferredScrollableViewportSize() {
                int n = this.getRowCount();
                if (n > 10) {
                    n = 10;
                }
                int n2 = 0;
                for (int i = 0; i < 3; ++i) {
                    n2 += COLUMN_WIDTH[i];
                }
                return new Dimension(n2, this.getRowHeight() * n);
            }
        };
        mJTable.setBackground(UIManager.getColor("control"));
        mJTable.setRowSelectionAllowed(false);
        mJTable.setColumnSelectionAllowed(false);
        TableColumnModel tableColumnModel = mJTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(COLUMN_WIDTH[0]);
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setPreferredWidth(COLUMN_WIDTH[1]);
        TableColumn tableColumn3 = tableColumnModel.getColumn(2);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 0, 60, 1);
        tableColumn3.setCellEditor(new SpinnerEditor(spinnerNumberModel));
        tableColumn3.setPreferredWidth(COLUMN_WIDTH[2]);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)mJTable);
        this.fUIFrame = new MJFrame("Simulated Labs");
        this.fUIFrame.setDefaultCloseOperation(2);
        this.fUIFrame.getContentPane().add((Component)mJScrollPane, "Center");
        this.fUIFrame.pack();
        this.fUIFrame.setVisible(true);
    }

    void hideUI() {
        this.fUIFrame.dispose();
    }

    class SpinnerEditor
    extends DefaultCellEditor {
        public SpinnerEditor(final SpinnerModel spinnerModel) {
            super(new JCheckBox());
            MJSpinner mJSpinner = new MJSpinner(spinnerModel);
            this.editorComponent = mJSpinner;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object object) {
                    spinnerModel.setValue(object);
                }

                @Override
                public Object getCellEditorValue() {
                    return spinnerModel.getValue();
                }
            };
            JComponent jComponent = mJSpinner.getEditor();
            if (jComponent instanceof JTextField) {
                ((JTextField)jComponent).addActionListener(this.delegate);
            }
        }
    }

    class SettingsTableModel
    extends AbstractTableModel {
        SettingsTableModel() {
        }

        @Override
        public int getRowCount() {
            return SimulatedLabs.this.fLabCount;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            return COLUMN_NAME[n];
        }

        public Class getColumnClass(int n) {
            return COLUMN_CLASS[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = n + 1;
            switch (n2) {
                case 0: {
                    return new Integer(n3);
                }
                case 1: {
                    return SimulatedLabs.this.fBreakNext[n3] ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2: {
                    return new Integer(SimulatedLabs.this.fDelay[n3]);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            int n3 = n + 1;
            switch (n2) {
                case 1: {
                    ((SimulatedLabs)SimulatedLabs.this).fBreakNext[n3] = (Boolean)object;
                    break;
                }
                case 2: {
                    ((SimulatedLabs)SimulatedLabs.this).fDelay[n3] = (Integer)object;
                    break;
                }
            }
            this.fireTableDataChanged();
        }
    }

    class Responder
    implements Runnable {
        private int iLab;

        Responder(int n) {
            this.iLab = n;
        }

        @Override
        public void run() {
            while (!SimulatedLabs.this.fQuitThreads) {
                try {
                    ResponseAction responseAction = (ResponseAction)SimulatedLabs.this.fResponseQueue[this.iLab].take();
                    if (SimulatedLabs.this.fQuitThreads) break;
                    if (SimulatedLabs.this.fDelay[this.iLab] > 0) {
                        Thread.sleep(SimulatedLabs.this.fDelay[this.iLab]);
                    }
                    if ("pound".equals(responseAction.iResponse)) {
                        while (SimulatedLabs.this.fGenerateOutput) {
                            int n = 1 + SimulatedLabs.this.fRandom.nextInt(20);
                            String string = SimulatedLabs.this.randomMatrix(n);
                            responseAction.iObserver.handleOutput(string, ProcessInstance.getLabInstance(this.iLab));
                            long l = (long)(Math.abs(SimulatedLabs.this.fRandom.nextGaussian()) * 50.0);
                            Thread.sleep(l);
                        }
                        continue;
                    }
                    if ("lines".equals(responseAction.iResponse)) {
                        while (SimulatedLabs.this.fLinesSent[this.iLab] < SimulatedLabs.this.fLinesToSend) {
                            StringBuilder stringBuilder = new StringBuilder(8192);
                            while (SimulatedLabs.this.fLinesSent[this.iLab] < SimulatedLabs.this.fLinesToSend && stringBuilder.length() < 8185) {
                                int[] nArray = SimulatedLabs.this.fLinesSent;
                                int n = this.iLab;
                                int n2 = nArray[n] + 1;
                                nArray[n] = n2;
                                stringBuilder.append(Integer.toString(n2));
                                stringBuilder.append('\n');
                            }
                            responseAction.iObserver.handleOutput(stringBuilder.toString(), ProcessInstance.getLabInstance(this.iLab));
                        }
                        continue;
                    }
                    responseAction.actionPerformed(null);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ResponseAction
    implements ActionListener {
        String iResponse;
        String[] iResponses;
        int iResponseIndex;
        int iLab;
        int iStatus;
        LabsCompletionObserver iObserver;
        Timer iResponseTimer;

        ResponseAction(Object object, int n, int n2, LabsCompletionObserver labsCompletionObserver) {
            this.iLab = n;
            this.iStatus = n2;
            this.iObserver = labsCompletionObserver;
            if (object instanceof String) {
                this.iResponse = (String)object;
            } else if (object instanceof String[]) {
                this.iResponses = (String[])object;
            }
        }

        boolean isDone() {
            return this.iResponses == null || this.iResponseIndex >= this.iResponses.length;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.iResponse;
            if (this.iResponses != null) {
                if (this.iResponseIndex == 0 && this.iResponses.length > 1) {
                    this.iResponseTimer = new Timer(100, this);
                    this.iResponseTimer.start();
                }
                string = this.iResponses[this.iResponseIndex++];
            }
            if (string != null) {
                this.iObserver.handleOutput(string, ProcessInstance.getLabInstance(this.iLab));
            }
            if (this.isDone()) {
                if (this.iResponseTimer != null) {
                    this.iResponseTimer.stop();
                    this.iResponseTimer = null;
                }
                this.iObserver.handleExecStatus(this.iStatus, ProcessInstance.getLabInstance(this.iLab));
            }
        }
    }
}

