/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindClientRegistry;
import com.mathworks.widgets.find.FindParentListener;
import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;

public abstract class DesktopFindClient
extends DTClientAdapter
implements FindClientInterface {
    protected String fClientTitle;
    protected Component fClientComponent;
    protected Desktop fDesktop;
    protected FindParentListener fParentListener;
    protected boolean fIsRegistered;

    public DesktopFindClient(String string, Component component, Desktop desktop) {
        this.fClientTitle = string;
        this.fClientComponent = component;
        this.fDesktop = desktop;
        if (this.fDesktop != null) {
            this.fDesktop.addClientListener(component, (DTClientListener)this);
        }
        this.clientOpened(null);
    }

    public void addFindParentListener(FindParentListener findParentListener) {
        this.fParentListener = findParentListener;
    }

    public void removeFindParentListener(FindParentListener findParentListener) {
        if (this.fParentListener == findParentListener) {
            this.fParentListener = null;
        }
    }

    public Component getInvoker() {
        return this.fClientComponent;
    }

    public void bringForward() {
        if (this.fDesktop != null) {
            this.fDesktop.toFront(this.fClientComponent);
        } else {
            Window window = SwingUtilities.windowForComponent(this.fClientComponent);
            if (window != null) {
                window.toFront();
            }
        }
    }

    public void clientActivated(DTClientEvent dTClientEvent) {
        if (this.fParentListener != null) {
            this.fParentListener.focusGained((FindClientInterface)this);
        }
    }

    public void clientDocked(DTClientEvent dTClientEvent) {
        if (this.fParentListener != null) {
            this.fParentListener.undocked((FindClientInterface)this);
        }
    }

    public void clientUndocked(DTClientEvent dTClientEvent) {
        if (this.fParentListener != null) {
            this.fParentListener.docked((FindClientInterface)this);
        }
    }

    public void clientOpened(DTClientEvent dTClientEvent) {
        if (!this.fIsRegistered) {
            FindClientRegistry.register((FindClientInterface)this, (String[])new String[]{this.fClientTitle}, (boolean)false);
            this.fIsRegistered = true;
        }
    }

    public void clientClosing(DTClientEvent dTClientEvent) {
        if (this.fParentListener != null) {
            this.fParentListener.closing((FindClientInterface)this);
        }
    }

    public void clientClosed(DTClientEvent dTClientEvent) {
        if (this.fIsRegistered) {
            FindClientRegistry.unregister((FindClientInterface)this);
            this.fIsRegistered = false;
        }
    }
}

