/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.datastore;

import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.toolbox.distcomp.mjs.datastore.ByteBufferItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.CallerDataStoreExceededException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreProxy;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreRemote;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.util.MCRShutdownHandler;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DataStoreImpl
implements DataStore,
DataStoreRemote {
    private final Map<DataStoreItem, ByteBufferItem> fDataMap;
    private DataStoreProxy fProxy;
    private final Exporter fExporter;
    private final long fMinTransferSize;
    private final long fDataStoreSize;
    private long fCurrentNumBytes = 0L;

    public DataStoreImpl(long l, Exporter exporter, long l2) throws ExportException {
        this.fDataStoreSize = l;
        this.fExporter = exporter;
        this.fMinTransferSize = l2;
        this.exportDataStore(exporter);
        this.fDataMap = Collections.synchronizedMap(new HashMap());
    }

    public DataStoreProxy getProxy() {
        return this.fProxy;
    }

    public int getExportPort() {
        return this.fExporter.getExportPort();
    }

    @Override
    public long getMinTransferSize() {
        return this.fMinTransferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataStoreItem dataStoreItem, byte[] byArray) throws RemoteException, CallerDataStoreExceededException {
        assert (dataStoreItem != null && byArray != null) : "item and data must both be non-null";
        Object object = this.fDataMap;
        synchronized (object) {
            if (!this.fDataMap.containsKey(dataStoreItem)) {
                int n = dataStoreItem.getNumBytes();
                this.checkStoreLimit(n);
                ByteBufferItem byteBufferItem = this.createByteBufferItem(n);
                this.fDataMap.put(dataStoreItem, byteBufferItem);
                this.fCurrentNumBytes += (long)n;
            }
        }
        object = this.fDataMap.get(dataStoreItem);
        ((ByteBufferItem)object).putData(byArray);
    }

    @Override
    public byte[] read(DataStoreItem dataStoreItem, int n) throws RemoteException {
        assert (dataStoreItem != null) : "item must be non-null";
        ByteBufferItem byteBufferItem = this.fDataMap.get(dataStoreItem);
        if (byteBufferItem == null) {
            return null;
        }
        return byteBufferItem.getData(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(DataStoreItem[] dataStoreItemArray) throws RemoteException {
        assert (dataStoreItemArray != null) : "item array must be non-null";
        Map<DataStoreItem, ByteBufferItem> map = this.fDataMap;
        synchronized (map) {
            for (DataStoreItem dataStoreItem : dataStoreItemArray) {
                assert (dataStoreItem != null) : "item must be non-null";
                ByteBufferItem byteBufferItem = this.fDataMap.remove(dataStoreItem);
                if (byteBufferItem == null) continue;
                this.fCurrentNumBytes -= (long)dataStoreItem.getNumBytes();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStoreItem putByteBufferItem(ByteBufferItem byteBufferItem) throws CallerDataStoreExceededException {
        assert (byteBufferItem != null) : "buffer item must both be non-null";
        byteBufferItem.rewind();
        Map<DataStoreItem, ByteBufferItem> map = this.fDataMap;
        synchronized (map) {
            int n = byteBufferItem.getNumBytes();
            this.checkStoreLimit(n);
            DataStoreItem dataStoreItem = new DataStoreItem(n, this.fProxy);
            this.fDataMap.put(dataStoreItem, byteBufferItem);
            this.fCurrentNumBytes += (long)n;
            return dataStoreItem;
        }
    }

    @Override
    public ByteBufferItem getByteBufferItem(DataStoreItem dataStoreItem) {
        assert (dataStoreItem != null) : "item must be non-null";
        ByteBufferItem byteBufferItem = this.fDataMap.get(dataStoreItem);
        if (byteBufferItem == null) {
            return null;
        }
        byteBufferItem.rewind();
        return byteBufferItem;
    }

    @Override
    public long getDataStoreSize() {
        return this.fDataStoreSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData() {
        Map<DataStoreItem, ByteBufferItem> map = this.fDataMap;
        synchronized (map) {
            this.fDataMap.clear();
            this.fCurrentNumBytes = 0L;
        }
    }

    private void exportDataStore(final Exporter exporter) throws ExportException {
        DataStore dataStore = (DataStore)exporter.export(this);
        this.fProxy = new DataStoreProxy(dataStore, this.fDataStoreSize, this.fMinTransferSize);
        MCRShutdownHandler.addShutdownHook(MatlabMCRFactory.getForCurrentMCR(), new Thread(){

            @Override
            public void run() {
                exporter.unexport(true);
            }
        });
    }

    public void unexport() {
        this.fExporter.unexport(true);
    }

    private ByteBufferItem createByteBufferItem(int n) throws OutOfMemoryError {
        return new ByteBufferItem(n);
    }

    private void checkStoreLimit(long l) throws CallerDataStoreExceededException {
        long l2 = this.fCurrentNumBytes + l;
        if (l2 > this.fDataStoreSize) {
            throw new CallerDataStoreExceededException(l2 + " cannot fit in store of size " + this.fDataStoreSize);
        }
    }
}

