/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.client;

import com.mathworks.toolbox.distcomp.auth.AuthorisationContext;
import com.mathworks.toolbox.distcomp.auth.SignatureModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.distcompobjects.ListenerInfo;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerAuthorisationContext;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerRegistration;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.ClientJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ClientSimultaneousTasksJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ClientTaskAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ClientWorkUnitAccess;
import com.mathworks.toolbox.distcomp.mjs.client.JobManagerClient;
import com.mathworks.toolbox.distcomp.mjs.client.Log;
import com.mathworks.toolbox.distcomp.mjs.client.ProxiedClientJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ProxiedClientSimultaneousTasksJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ProxiedClientTaskAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientSimultaneousTasksJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientTaskAccess;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.service.DistcompServiceInfo;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.uddadaptor.MatlabEventAdaptor;
import com.mathworks.toolbox.distcomp.util.concurrent.CancellingExecutor;
import com.mathworks.toolbox.distcomp.util.concurrent.FileOutputStreamUsingTask;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jini.id.Uuid;

public final class ProxiedJobManagerClient
implements JobManagerClient {
    private final JobManagerLocal fJobManager;
    private final JobManagerAuthorisationContext fAuthorisationContext;

    public ProxiedJobManagerClient(JobManagerLocal jobManagerLocal) {
        this.fJobManager = jobManagerLocal;
        CredentialConsumerFactory credentialConsumerFactory = CredentialConsumerFactory.getDefault();
        this.fAuthorisationContext = new JobManagerAuthorisationContext(jobManagerLocal, credentialConsumerFactory);
    }

    public ProxiedJobManagerClient(JobManagerLocal jobManagerLocal, CredentialConsumerFactory credentialConsumerFactory, CredentialStore<AuthenticationToken> credentialStore) {
        this.fJobManager = jobManagerLocal;
        this.fAuthorisationContext = new JobManagerAuthorisationContext(jobManagerLocal, credentialConsumerFactory, credentialStore);
    }

    private ProxiedJobManagerClient(JobManagerLocal jobManagerLocal, JobManagerAuthorisationContext jobManagerAuthorisationContext) {
        this.fJobManager = jobManagerLocal;
        this.fAuthorisationContext = jobManagerAuthorisationContext;
    }

    public JobManagerClient createNewClient(JobManagerLocal jobManagerLocal) {
        JobManagerAuthorisationContext jobManagerAuthorisationContext = this.fAuthorisationContext.createNew(jobManagerLocal);
        return new ProxiedJobManagerClient(jobManagerLocal, jobManagerAuthorisationContext);
    }

    @Override
    public JobManagerLocal getJobManager() {
        return this.fJobManager;
    }

    @Override
    public Future<?> getClusterLogs(String string) throws IOException, MJSException {
        NamedThreadFactory namedThreadFactory = NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " getClusterLogs-"), (java.util.logging.Logger)Log.LOG);
        CancellingExecutor cancellingExecutor = new CancellingExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)namedThreadFactory);
        File file = new File(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        Future<Object> future = cancellingExecutor.submit(new FileOutputStreamUsingTask<Object>((OutputStream)bufferedOutputStream, file){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException, MJSException {
                boolean bl = false;
                try {
                    ProxiedJobManagerClient.this.fJobManager.getClusterLogs(ProxiedJobManagerClient.this.fAuthorisationContext, this.getOutputStream());
                    bl = true;
                }
                catch (NoCredentialsEnteredException noCredentialsEnteredException) {
                }
                finally {
                    this.getOutputStream().close();
                    if (!bl) {
                        this.getFile().delete();
                    }
                }
                return null;
            }
        });
        cancellingExecutor.shutdown();
        return future;
    }

    @Override
    public void setClusterLogLevel(int n) throws RemoteException, MJSException {
        if (n >= 0) {
            this.fJobManager.setClusterLogLevel(this.fAuthorisationContext, n);
        }
    }

    @Override
    public int getClusterLogLevel() throws RemoteException, MJSException {
        return this.fJobManager.getClusterLogLevel();
    }

    @Override
    public Uuid getID() {
        return this.fJobManager.getID();
    }

    @Override
    public Uuid createJob(JobInfo jobInfo) throws RemoteException, MJSException {
        return this.fJobManager.createJob(this.fAuthorisationContext, jobInfo);
    }

    @Override
    public Uuid createParallelJob(JobInfo jobInfo) throws RemoteException, MJSException {
        return this.fJobManager.createParallelJob(this.fAuthorisationContext, jobInfo);
    }

    @Override
    public Uuid createMatlabPoolJob(JobInfo jobInfo, byte[] byArray, byte[] byArray2) throws RemoteException, MJSException {
        return this.fJobManager.createMatlabPoolJob(this.fAuthorisationContext, jobInfo, byArray, byArray2);
    }

    @Override
    public Uuid createConcurrentJob(JobInfo jobInfo) throws RemoteException, MJSException {
        return this.fJobManager.createConcurrentJob(this.fAuthorisationContext, jobInfo);
    }

    @Override
    public JobIDAndMLType[] getJobs() throws RemoteException, StorageException {
        return this.fJobManager.getJobs();
    }

    @Override
    public JobIDAndMLType[][] getJobs(int[] nArray) throws RemoteException, StorageException {
        return this.fJobManager.getJobs(nArray);
    }

    @Override
    public void pauseQueue() throws RemoteException, MJSException {
        Logger.LOGGER.fine("Pausing the queue from JobManager Client (pauseQueue)");
        this.fJobManager.pauseQueue();
    }

    @Override
    public void resumeQueue() throws RemoteException, MJSException {
        Logger.LOGGER.fine("Resuming the queue from JobManager Client(resumeQueue)");
        this.fJobManager.resumeQueue();
    }

    @Override
    public ClientJobAccess getJobAccess() throws RemoteException, MJSException {
        return new ProxiedClientJobAccess(this.fJobManager.getJobAccess(), (AuthorisationContext)this.fAuthorisationContext);
    }

    @Override
    public ClientSimultaneousTasksJobAccess getSimultaneousTasksJobAccess() throws RemoteException, MJSException {
        return new ProxiedClientSimultaneousTasksJobAccess(this.fJobManager.getSimultaneousTasksJobAccess(), (AuthorisationContext)this.fAuthorisationContext);
    }

    @Override
    public ClientTaskAccess getTaskAccess() throws RemoteException, MJSException {
        return new ProxiedClientTaskAccess(this.fJobManager.getTaskAccess(), (AuthorisationContext)this.fAuthorisationContext);
    }

    @Override
    public ReadOnlyClientJobAccess getReadOnlyJobAccess() throws RemoteException, MJSException {
        return this.getJobAccess();
    }

    @Override
    public ReadOnlyClientTaskAccess getReadOnlyTaskAccess() throws RemoteException, MJSException {
        return this.getTaskAccess();
    }

    @Override
    public ReadOnlyClientSimultaneousTasksJobAccess getReadOnlySimultaneousTasksJobAccess() throws RemoteException, MJSException {
        return this.getSimultaneousTasksJobAccess();
    }

    @Override
    public int getNumIdleWorkers() throws RemoteException {
        return this.fJobManager.getNumIdleWorkers();
    }

    @Override
    public int getNumBusyWorkers() throws RemoteException {
        return this.fJobManager.getNumBusyWorkers();
    }

    @Override
    public Worker[] getIdleWorkers() throws RemoteException {
        return this.fJobManager.getIdleWorkers();
    }

    @Override
    public Worker[] getBusyWorkers() throws RemoteException {
        return this.fJobManager.getBusyWorkers();
    }

    @Override
    public WorkerProperties[] getIdleWorkerProperties() throws RemoteException {
        return this.fJobManager.getIdleWorkerProperties();
    }

    @Override
    public WorkerProperties[] getBusyWorkerProperties() throws RemoteException {
        return this.fJobManager.getBusyWorkerProperties();
    }

    @Override
    public WorkerRegistration getWorkerRegistration() throws RemoteException {
        return this.fJobManager.getWorkerRegistration();
    }

    @Override
    public String getLookupURL() throws RemoteException {
        return this.fJobManager.getLookupURL();
    }

    @Override
    public int getSecurityLevel() throws RemoteException {
        return this.fJobManager.getSecurityLevel();
    }

    @Override
    public void promote(Uuid uuid) throws RemoteException, MJSException {
        this.fJobManager.promote(uuid);
    }

    @Override
    public void demote(Uuid uuid) throws RemoteException, MJSException {
        this.fJobManager.demote(uuid);
    }

    @Override
    public void removeWorker(Uuid uuid) throws RemoteException, MJSException {
        this.fJobManager.removeWorker(uuid);
    }

    @Override
    public boolean allowClientPasswordCache() throws RemoteException {
        return this.fJobManager.allowClientPasswordCache();
    }

    @Override
    public String[] getAllHostAddresses() throws RemoteException {
        return this.fJobManager.getAllHostAddresses();
    }

    @Override
    public String getHostName() throws RemoteException {
        return this.fJobManager.getHostName();
    }

    @Override
    public String getName() throws RemoteException {
        return this.fJobManager.getName();
    }

    @Override
    public String getComputerMLType() throws RemoteException {
        return this.fJobManager.getComputerMLType();
    }

    @Override
    public String getClusterMatlabRoot() throws RemoteException {
        return this.fJobManager.getMatlabRoot();
    }

    @Override
    public int getState() throws RemoteException {
        return this.fJobManager.getState();
    }

    @Override
    public DistcompServiceInfo getServiceInfo() throws RemoteException, StorageException {
        return this.fJobManager.getServiceInfo();
    }

    @Override
    public NodeInfo getNodeInfo() throws RemoteException {
        return this.fJobManager.getNodeInfo();
    }

    @Override
    public void prepareForShutdown() throws RemoteException {
        this.fJobManager.prepareForShutdown();
    }

    @Override
    public boolean isUsingSecureCommunication() throws RemoteException {
        return this.fJobManager.isUsingSecureCommunication();
    }

    @Override
    public boolean workerProxiesPoolConnections() throws RemoteException {
        return this.fJobManager.workerProxiesPoolConnections();
    }

    @Override
    public void attachToListenableObject(ClientWorkUnitAccess clientWorkUnitAccess, Uuid[] uuidArray) throws RemoteException, MJSException {
        this.fJobManager.attachToListenableObject(clientWorkUnitAccess.getAccessLocal(), uuidArray);
    }

    @Override
    public ListenerInfo[] createListenerInfoArrayForAllEvents() throws IOException, MJSException {
        return this.fJobManager.createListenerInfoArrayForAllEvents();
    }

    @Override
    public void detachFromListenableObject(ClientWorkUnitAccess clientWorkUnitAccess, Uuid[] uuidArray) throws RemoteException, MJSException {
        this.fJobManager.detachFromListenableObject(clientWorkUnitAccess.getAccessLocal(), uuidArray);
    }

    @Override
    public void addEventAdaptor(MatlabEventAdaptor matlabEventAdaptor) throws MJSException {
        this.fJobManager.addEventAdaptor(matlabEventAdaptor);
    }

    @Override
    public void removeEventAdaptor(MatlabEventAdaptor matlabEventAdaptor) {
        this.fJobManager.removeEventAdaptor(matlabEventAdaptor);
    }

    @Override
    public ServerSocketConnectInfo getBrokerServerSocketConnectInfo() {
        return this.fJobManager.getBrokerServerSocketConnectInfo();
    }

    @Override
    public ServerSocketAcceptInfo getWorkerAcceptInfoTemplate() {
        return this.fJobManager.getWorkerAcceptInfoTemplate();
    }

    @Override
    public void changeCredentialsOfExistingUser(UserIdentity userIdentity) throws MJSException, RemoteException {
        this.fJobManager.changeCredentialsOfExistingUser(this.fAuthorisationContext, userIdentity);
    }

    @Override
    public void addAdminUser(SignatureModule.Signer signer) throws MJSException, RemoteException {
        this.fJobManager.addAdminUser(this.fAuthorisationContext, signer);
    }

    @Override
    public boolean requireWebLicensing() throws RemoteException {
        return this.fJobManager.requireWebLicensing();
    }

    @Override
    public void dispose() {
        this.fJobManager.dispose();
    }

    @Override
    public UserIdentity promptForIdentity(String string) throws MJSException, RemoteException {
        return this.fAuthorisationContext.promptForIdentity(string);
    }

    @Override
    public void setCurrentUser(UserIdentity userIdentity) throws MJSException, RemoteException {
        this.fAuthorisationContext.setCurrentUser(userIdentity);
    }

    @Override
    public UserIdentity getCurrentUser() {
        return this.fAuthorisationContext.getCurrentUser();
    }

    @Override
    public void revokeAuthentication(UserIdentity userIdentity) {
        this.fAuthorisationContext.revokeAuthentication(userIdentity);
    }

    @Override
    public void updateStorageCredentials(UserCredentials userCredentials) throws MJSException, RemoteException {
        this.fJobManager.updateStorageCredentials(userCredentials);
    }

    @Override
    public CredentialStore<AuthenticationToken> getCredentialStore() {
        return this.fAuthorisationContext.getCredentialStore();
    }

    @Override
    public void setCredentialConsumerFactory(CredentialConsumerFactory credentialConsumerFactory) {
        this.fAuthorisationContext.setCredentialConsumerFactory(credentialConsumerFactory);
    }

    @Override
    public CredentialConsumerFactory getCredentialConsumerFactory() {
        return this.fAuthorisationContext.getCredentialConsumerFactory();
    }

    @Override
    public Object createMemento() {
        return this.fAuthorisationContext.createMemento();
    }

    @Override
    public void restoreFromMemento(Object object) {
        this.fAuthorisationContext.restoreFromMemento(object);
    }

    @Override
    public String toString() {
        return "ProxiedJobManagerClient{fJobManager=" + this.fJobManager + ", fAuthorisationContext=" + this.fAuthorisationContext + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProxiedJobManagerClient proxiedJobManagerClient = (ProxiedJobManagerClient)object;
        return this.fJobManager.equals(proxiedJobManagerClient.fJobManager);
    }

    public int hashCode() {
        return this.fJobManager.hashCode();
    }
}

