/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.LocalScheduler;
import com.mathworks.toolbox.distcomp.local.PackageInfo;
import com.mathworks.toolbox.distcomp.local.TokenManager;
import com.mathworks.toolbox.distcomp.remote.util.StreamRedirector;
import com.mathworks.toolbox.parallel.pctutil.concurrent.WaitForTurnQueue;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractLocalCommand
implements Callable<Object> {
    private Future<Object> fFuture;
    private final LocalScheduler fScheduler = LocalScheduler.getInstance();
    private final StreamRedirector fRedirector = StreamRedirector.getInstance();
    private boolean fSubmitted = false;
    private boolean fDispatched = false;
    private boolean fStartedRunning = false;
    private boolean fCancelled = false;
    private boolean fDestroyed = false;
    private final int fMinRequired;
    private final int fMaxRequired;
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(0);
    private final int fSerial;
    protected final UUID fUUID = UUID.randomUUID();

    protected AbstractLocalCommand(int n, int n2) {
        if (n < 1 || n2 > this.fScheduler.getMaximumNumberOfWorkers() || n > n2) {
            throw new IllegalStateException("More workers requested that available in the local scheduler. This job would never run.");
        }
        this.fMinRequired = n;
        this.fMaxRequired = n2;
        this.fSerial = INSTANCE_COUNTER.incrementAndGet();
    }

    protected static AbstractLocalCommand addCommandToScheduler(AbstractLocalCommand abstractLocalCommand) {
        abstractLocalCommand.fScheduler.addCommand(abstractLocalCommand.getUUID(), abstractLocalCommand);
        return abstractLocalCommand;
    }

    public UUID getUUID() {
        return this.fUUID;
    }

    public synchronized boolean isCancelled() {
        return this.fCancelled;
    }

    public synchronized boolean hasStartedRunning() {
        return this.fStartedRunning;
    }

    public synchronized boolean isRunning() {
        return this.fStartedRunning && !this.fFuture.isDone();
    }

    public synchronized boolean isDone() {
        return this.fSubmitted && this.fFuture.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long l) {
        Future<Object> future = null;
        AbstractLocalCommand abstractLocalCommand = this;
        synchronized (abstractLocalCommand) {
            if (this.fSubmitted) {
                future = this.fFuture;
            }
        }
        if (future == null) {
            return false;
        }
        try {
            future.get(l, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (Exception exception) {
            return future.isDone();
        }
    }

    public synchronized boolean isDestroyed() {
        return this.fDestroyed;
    }

    public LocalScheduler getScheduler() {
        return this.fScheduler;
    }

    public StreamRedirector getStreamRedirector() {
        return this.fRedirector;
    }

    public final synchronized void submit() {
        if (!(this.fDestroyed || this.fCancelled || this.fSubmitted)) {
            this.fFuture = this.fScheduler.submit(this);
            this.fSubmitted = true;
        }
    }

    public final synchronized boolean cancel() {
        if (!this.isDone()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, this.toString() + ".cancel().");
        }
        this.fCancelled = true;
        this.fScheduler.cancel(this);
        return !this.fSubmitted || this.fFuture.cancel(true);
    }

    public synchronized void destroy() {
        if (this.fSubmitted) {
            this.cancel();
        }
        this.fScheduler.removeCommand(this.fUUID);
        this.fDestroyed = true;
    }

    private synchronized void setRunning() {
        this.fStartedRunning = true;
    }

    private synchronized void setDispatched() {
        assert (!this.fDispatched) : "Trying to run an AbstractLocalCommand twice";
        this.fDispatched = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Object call() throws Exception {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Entering " + this.toString() + ".call()");
        try (TokenManager.SemaphoreToken semaphoreToken = this.getScheduler().acquire(this, this.fMinRequired, this.fMaxRequired);){
            this.setDispatched();
            this.setRunning();
            Object object = this.onRun(semaphoreToken.getNumberAcquired());
            return object;
        }
        catch (WaitForTurnQueue.TurnAbandonedException turnAbandonedException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, this.toString() + ".call() cancelled.");
            return null;
        }
        catch (InterruptedException interruptedException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, this.toString() + ".call() interrupted.");
            throw interruptedException;
        }
        catch (Error | Exception throwable6) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Exception or Error during " + this + ".onRun().", throwable6);
            throw throwable6;
        }
    }

    public abstract Object onRun(int var1) throws Exception;

    public final String getState() {
        return this.getStateEnum().getName();
    }

    protected synchronized State getStateEnum() {
        if (!this.hasStartedRunning()) {
            return State.QUEUED_STATE;
        }
        if (this.isRunning()) {
            return State.RUNNING_STATE;
        }
        if (this.isCancelled()) {
            return State.CANCELLED_STATE;
        }
        if (this.isDestroyed()) {
            return State.DESTROYED_STATE;
        }
        if (this.isDone()) {
            return State.FINISHED_STATE;
        }
        return State.UNKNOWN_STATE;
    }

    public String toString() {
        return "AbstractLocalCommand[fSerial=" + this.fSerial + "]";
    }

    protected static enum State {
        QUEUED_STATE("queued"),
        RUNNING_STATE("running"),
        FINISHED_STATE("finished"),
        FAILED_STATE("failed"),
        CANCELLED_STATE("finished"),
        DESTROYED_STATE("deleted"),
        UNKNOWN_STATE("unknown");

        private final String fStateName;

        private State(String string2) {
            this.fStateName = string2;
        }

        String getName() {
            return this.fStateName;
        }
    }
}

