/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager.statenotification;

import com.mathworks.toolbox.distcomp.distcompobjects.PackageInfo;
import com.mathworks.toolbox.distcomp.jobmanager.JobCounter;
import com.mathworks.toolbox.distcomp.jobmanager.statenotification.ActivityNotifier;
import com.mathworks.toolbox.distcomp.jobmanager.statenotification.NotificationFailedException;
import com.mathworks.toolbox.distcomp.jobmanager.statenotification.NotificationSender;
import com.mathworks.toolbox.distcomp.util.SystemTimeProvider;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class MJSActivityNotifier
implements ActivityNotifier {
    private final JobCounter fJobCounter;
    private final NotificationSender fNotificationSender;
    private final TimeProvider fTimeProvider;
    private final long fMinimumUpdateInterval;
    private final AtomicBoolean fNotifiedBusy = new AtomicBoolean(false);
    private final Lock fLock = new ReentrantLock();
    private long fLastUpdateTime;
    private boolean fWasLastUpdateIdle = true;

    public MJSActivityNotifier(JobCounter jobCounter, NotificationSender notificationSender, long l) {
        this(jobCounter, notificationSender, l, new SystemTimeProvider());
    }

    public MJSActivityNotifier(JobCounter jobCounter, NotificationSender notificationSender, long l, TimeProvider timeProvider) {
        this.fJobCounter = jobCounter;
        this.fNotificationSender = notificationSender;
        this.fTimeProvider = timeProvider;
        this.fLastUpdateTime = this.fTimeProvider.currentTimeMillis();
        this.fMinimumUpdateInterval = l;
    }

    @Override
    public void run() {
        try {
            boolean bl = this.fNotifiedBusy.getAndSet(false);
            boolean bl2 = this.fJobCounter.queuedOrRunningJobsPresent();
            if (bl2) {
                PackageInfo.LOGGER.log(Level.FINER, "Sending busy notification. Reason: queued or running jobs found.");
                this.sendBusy();
            } else if (bl) {
                PackageInfo.LOGGER.log(Level.FINER, "Sending busy notification. Reason: directly informed of busy status.");
                this.sendBusy();
            } else {
                PackageInfo.LOGGER.log(Level.FINER, "Sending idle notification.");
                this.sendIdle();
            }
        }
        catch (InterruptedException interruptedException) {
            PackageInfo.LOGGER.log(Level.INFO, "MJSActivityNotifier interrupted.", interruptedException);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void notifyBusy() {
        this.fNotifiedBusy.set(true);
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBusy() throws InterruptedException {
        boolean bl = false;
        this.fLock.lock();
        try {
            long l = this.fTimeProvider.currentTimeMillis();
            if (l > this.fLastUpdateTime + this.fMinimumUpdateInterval || this.fWasLastUpdateIdle) {
                bl = true;
                this.fLastUpdateTime = this.fTimeProvider.currentTimeMillis();
                this.fWasLastUpdateIdle = false;
            } else {
                PackageInfo.LOGGER.log(Level.FINER, "Not sending busy update, already sent one within the last interval");
            }
        }
        finally {
            this.fLock.unlock();
        }
        if (bl) {
            try {
                this.fNotificationSender.sendBusyNotification();
            }
            catch (NotificationFailedException notificationFailedException) {
                this.fLock.lock();
                try {
                    this.fWasLastUpdateIdle = true;
                }
                finally {
                    this.fLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendIdle() throws InterruptedException {
        boolean bl = false;
        this.fLock.lock();
        try {
            long l = this.fTimeProvider.currentTimeMillis();
            if (l > this.fLastUpdateTime + this.fMinimumUpdateInterval) {
                bl = true;
                this.fLastUpdateTime = this.fTimeProvider.currentTimeMillis();
                this.fWasLastUpdateIdle = true;
            }
        }
        finally {
            this.fLock.unlock();
        }
        if (bl) {
            try {
                this.fNotificationSender.sendIdleNotification();
            }
            catch (NotificationFailedException notificationFailedException) {
                // empty catch block
            }
        }
    }
}

