/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client;

import java.util.regex.Pattern;

public enum WindowsServiceState {
    UNKNOWN,
    NOT_INSTALLED,
    STOPPED,
    START_PENDING,
    STOP_PENDING,
    RUNNING;

    private static final Pattern STOPPED_REGEX;
    private static final Pattern START_PENDING_REGEX;
    private static final Pattern STOP_PENDING_REGEX;
    private static final Pattern RUNNING_REGEX;
    private static final Pattern FAILED_DOES_NOT_EXIST_REGEX;

    boolean isStoppingOrStopped() {
        return this == STOP_PENDING || this == STOPPED;
    }

    boolean isStartingOrRunning() {
        return this == START_PENDING || this == RUNNING;
    }

    static WindowsServiceState fromScQueryOutput(String string) {
        if (STOPPED_REGEX.matcher(string).matches()) {
            return STOPPED;
        }
        if (START_PENDING_REGEX.matcher(string).matches()) {
            return START_PENDING;
        }
        if (STOP_PENDING_REGEX.matcher(string).matches()) {
            return STOP_PENDING;
        }
        if (RUNNING_REGEX.matcher(string).matches()) {
            return RUNNING;
        }
        if (FAILED_DOES_NOT_EXIST_REGEX.matcher(string).matches()) {
            return NOT_INSTALLED;
        }
        return UNKNOWN;
    }

    static {
        STOPPED_REGEX = Pattern.compile(".*\\s+:\\s+1\\s+STOPPED.*", 32);
        START_PENDING_REGEX = Pattern.compile(".*\\s+:\\s+2\\s+START_PENDING.*", 32);
        STOP_PENDING_REGEX = Pattern.compile(".*\\s+:\\s+3\\s+STOP_PENDING.*", 32);
        RUNNING_REGEX = Pattern.compile(".*\\s+:\\s+4\\s+RUNNING.*", 32);
        FAILED_DOES_NOT_EXIST_REGEX = Pattern.compile(".*FAILED 1060.*", 32);
    }
}

