/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.control.ControlMessage;
import com.mathworks.toolbox.distcomp.control.DisplayableResults;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.StatusResultsFormatter;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NoValidMDCSHostnameException;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerNodeInfo;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.util.NodeInfoAnalyzer;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import com.mathworks.toolbox.distcomp.worker.WorkerNodeInfo;
import java.util.List;

public final class StatusResults
implements DisplayableResults {
    private static final long serialVersionUID = 4937604141305088999L;
    private static final int LEVEL_ONE = 1;
    private static final int LEVEL_TWO = 2;
    private final String fOutput;
    private final WarningAndNoteInfo fWarningsAndNotes;
    private final String fVerboseDesc;
    private final JobManagerNodeInfo[] fJInfo;
    private final WorkerNodeInfo[] fWInfo;
    private final boolean fHasLookup;

    @Override
    public String getOutputForDisplay() {
        return this.fOutput;
    }

    @Override
    public WarningAndNoteInfo getWarnings() {
        return this.fWarningsAndNotes;
    }

    @Override
    public String getPostRunDescription() {
        return this.fVerboseDesc;
    }

    public JobManagerNodeInfo[] getJobManagerNodeInfo() {
        return this.fJInfo;
    }

    public WorkerNodeInfo[] getWorkerNodeInfo() {
        return this.fWInfo;
    }

    public boolean isLookupRunning() {
        return this.fHasLookup;
    }

    public static MDCSCommandResults create(JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray, MDCSServiceInfo mDCSServiceInfo, List<ServiceInfo> list, int n) {
        boolean bl;
        boolean bl2 = mDCSServiceInfo.getHasLookup();
        String string = null;
        try {
            string = mDCSServiceInfo.getMDCSHostName();
        }
        catch (NoValidMDCSHostnameException noValidMDCSHostnameException) {
            // empty catch block
        }
        String string2 = StatusResults.getMDCEString(mDCSServiceInfo, n);
        boolean bl3 = bl = bl2 || jobManagerNodeInfoArray != null && jobManagerNodeInfoArray.length > 0;
        if (bl) {
            string2 = string2 + StatusResults.getLookupString(bl2);
        }
        if (jobManagerNodeInfoArray != null) {
            for (JobManagerNodeInfo jobManagerNodeInfo : jobManagerNodeInfoArray) {
                if (jobManagerNodeInfo == null) continue;
                string2 = string2 + StatusResults.getJobManagerString(jobManagerNodeInfo, n);
            }
        }
        if (workerNodeInfoArray != null) {
            for (WorkerNodeInfo workerNodeInfo : workerNodeInfoArray) {
                if (workerNodeInfo == null) continue;
                string2 = string2 + StatusResults.getWorkerString(workerNodeInfo, n);
            }
        }
        if (list.size() > 0) {
            string2 = string2 + StatusResults.getStoppedServicesString(list);
        }
        string2 = string2 + StatusResults.getMDCESummary(string, jobManagerNodeInfoArray, workerNodeInfoArray, bl2);
        WarningAndNoteInfo warningAndNoteInfo = new WarningAndNoteInfo();
        NodeInfoAnalyzer.addWarningsAndNotes(warningAndNoteInfo, string, jobManagerNodeInfoArray, workerNodeInfoArray, bl2, false);
        String string3 = new RetrievedMDCEStatusMessage(string).getLocalizedMessage();
        return new StatusResults(string2, warningAndNoteInfo, string3, bl2, jobManagerNodeInfoArray, workerNodeInfoArray);
    }

    private StatusResults(String string, WarningAndNoteInfo warningAndNoteInfo, String string2, boolean bl, JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray) {
        this.fOutput = string;
        this.fWarningsAndNotes = warningAndNoteInfo;
        this.fVerboseDesc = string2;
        this.fHasLookup = bl;
        if (jobManagerNodeInfoArray == null || jobManagerNodeInfoArray.length == 0) {
            this.fJInfo = null;
        } else {
            this.fJInfo = new JobManagerNodeInfo[jobManagerNodeInfoArray.length];
            System.arraycopy(jobManagerNodeInfoArray, 0, this.fJInfo, 0, jobManagerNodeInfoArray.length);
        }
        if (workerNodeInfoArray == null || workerNodeInfoArray.length == 0) {
            this.fWInfo = null;
        } else {
            this.fWInfo = new WorkerNodeInfo[workerNodeInfoArray.length];
            System.arraycopy(workerNodeInfoArray, 0, this.fWInfo, 0, workerNodeInfoArray.length);
        }
    }

    private static void getLevelOneOnly(StatusResultsFormatter statusResultsFormatter, NodeInfo nodeInfo) {
        statusResultsFormatter.add(new NameMessage().getLocalizedMessage(), nodeInfo.getName());
        statusResultsFormatter.add(new RunningOnHostMessage().getLocalizedMessage(), nodeInfo.getHostName());
    }

    private static void getLevelThreeOnly(StatusResultsFormatter statusResultsFormatter, NodeInfo nodeInfo) {
        statusResultsFormatter.add(new NetworkAddressesMessage().getLocalizedMessage(), nodeInfo.getAllHostAddresses());
    }

    private static void getLevelTwoOnly(StatusResultsFormatter statusResultsFormatter, NodeInfo nodeInfo) {
        if (nodeInfo.getStartTime() != null) {
            statusResultsFormatter.add(new StartTimeMessage().getLocalizedMessage(), nodeInfo.getStartTime().toString());
        } else {
            statusResultsFormatter.add(new StartTimeMessage().getLocalizedMessage(), "");
        }
        statusResultsFormatter.add(new PortMessage().getLocalizedMessage(), nodeInfo.getPort());
        String[] stringArray = nodeInfo.getLookupURLsInConfiguration();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{new UsingMulticastMessage().getLocalizedMessage()};
        }
        statusResultsFormatter.add(new LookupInConfigMessage().getLocalizedMessage(), stringArray);
        statusResultsFormatter.add(new RegisteredWithLookupMessage().getLocalizedMessage(), nodeInfo.getLookupURLs());
    }

    private static String getJobManagerString(JobManagerNodeInfo jobManagerNodeInfo, int n) {
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(new JobManagerMessage().getLocalizedMessage());
        StatusResults.getLevelOneOnly(statusResultsFormatter, jobManagerNodeInfo);
        String[] stringArray = jobManagerNodeInfo.getWorkerHostnames();
        String[] stringArray2 = jobManagerNodeInfo.getWorkerNames();
        int n2 = 0;
        if (stringArray != null) {
            n2 = stringArray.length;
        }
        statusResultsFormatter.add(new NumWorkersMessage().getLocalizedMessage(), n2);
        if (n > 1) {
            statusResultsFormatter.add(new WorkerNamesHostNamesMessage().getLocalizedMessage(), stringArray2, stringArray);
            StatusResults.getLevelTwoOnly(statusResultsFormatter, jobManagerNodeInfo);
        }
        if (n > 2) {
            statusResultsFormatter.add(new DatabaseSizeMessage().getLocalizedMessage(), jobManagerNodeInfo.getDatabaseSize());
            statusResultsFormatter.add(new VMHeapSizeMessage().getLocalizedMessage(), jobManagerNodeInfo.getVMHeapSize());
            statusResultsFormatter.add(new DatabaseCacheSizeMessage().getLocalizedMessage(), jobManagerNodeInfo.getDatabaseCacheSize());
            statusResultsFormatter.add(new WorkerLeaseTimeoutMessage().getLocalizedMessage(), jobManagerNodeInfo.getWorkerLeaseTimeout());
            StatusResults.getLevelThreeOnly(statusResultsFormatter, jobManagerNodeInfo);
        }
        return statusResultsFormatter.getBuffer();
    }

    private static String getWorkerString(WorkerNodeInfo workerNodeInfo, int n) {
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(new WorkerMessage().getLocalizedMessage());
        StatusResults.getLevelOneOnly(statusResultsFormatter, workerNodeInfo);
        String string = new IdleMessage().getLocalizedMessage();
        if (workerNodeInfo.isBusy()) {
            string = new BusyMessage().getLocalizedMessage();
        }
        statusResultsFormatter.add(new StatusMessage().getLocalizedMessage(), string);
        statusResultsFormatter.add(new JobManagerMessage().getLocalizedMessage(), workerNodeInfo.getJobManagerNameInConfiguration());
        String[] stringArray = StatusResults.getJobManagerConnectionStatus(workerNodeInfo);
        statusResultsFormatter.add(new WorkerJMConnectionStatusMessage().getLocalizedMessage(), stringArray[0]);
        if (n > 1) {
            statusResultsFormatter.add(new WorkerJMHostnameMessage().getLocalizedMessage(), stringArray[1]);
            StatusResults.getLevelTwoOnly(statusResultsFormatter, workerNodeInfo);
        }
        if (n > 2) {
            statusResultsFormatter.add(new FileDependDirMessage().getLocalizedMessage(), workerNodeInfo.getFileDependenciesDir());
            statusResultsFormatter.add(new WorkerStartupDirMessage().getLocalizedMessage(), workerNodeInfo.getWorkDir());
            StatusResults.getLevelThreeOnly(statusResultsFormatter, workerNodeInfo);
        }
        return statusResultsFormatter.getBuffer();
    }

    private static String getLookupString(boolean bl) {
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(new LookupProcessMessage().getLocalizedMessage());
        String string = bl ? new RunningMessage().getLocalizedMessage() : new NotRunningMessage().getLocalizedMessage();
        statusResultsFormatter.add(new StatusMessage().getLocalizedMessage(), string);
        return statusResultsFormatter.getBuffer();
    }

    private static String getMDCEString(MDCSServiceInfo mDCSServiceInfo, int n) {
        if (n > 1) {
            StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(new MDCEMessage().getLocalizedMessage());
            statusResultsFormatter.add(new MDCESecurityLevelMessage().getLocalizedMessage(), mDCSServiceInfo.getSecurityLevel().intValue());
            statusResultsFormatter.add(new MDCEVersionMessage().getLocalizedMessage(), mDCSServiceInfo.getVersion());
            statusResultsFormatter.add(new MDCEMatlabRootMessage().getLocalizedMessage(), mDCSServiceInfo.getMatlabRoot());
            statusResultsFormatter.add(new MDCEDefFileMessage().getLocalizedMessage(), mDCSServiceInfo.getMdceDefFile());
            statusResultsFormatter.add(new MDCEPlatformMessage().getLocalizedMessage(), mDCSServiceInfo.getSystemArchitecture().toString());
            return statusResultsFormatter.getBuffer();
        }
        return "";
    }

    private static String[] getJobManagerConnectionStatus(WorkerNodeInfo workerNodeInfo) {
        String string = workerNodeInfo.getJobManagerHostName();
        if (workerNodeInfo.isConnectedToJM()) {
            return new String[]{new ConnectionOkMessage().getLocalizedMessage(), string};
        }
        if (string == null || string.length() == 0) {
            return new String[]{new ConnectionFailedMessage().getLocalizedMessage(), new WorkerFailedToConnectMessage().getLocalizedMessage()};
        }
        return new String[]{new LostConnectionMessage().getLocalizedMessage(), new LostConnectionToMessage(string).getLocalizedMessage()};
    }

    private static String getMDCESummary(String string, JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (jobManagerNodeInfoArray != null) {
            n = jobManagerNodeInfoArray.length;
        }
        if (workerNodeInfoArray != null) {
            n2 = workerNodeInfoArray.length;
        }
        if (bl) {
            n3 = 1;
        }
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(new MDCESummaryMessage(string).getLocalizedMessage());
        statusResultsFormatter.add(new LookupProcessesMessage().getLocalizedMessage(), n3);
        statusResultsFormatter.add(new JobManagersMessage().getLocalizedMessage(), n);
        statusResultsFormatter.add(new WorkersMessage().getLocalizedMessage(), n2);
        return statusResultsFormatter.getBuffer();
    }

    private static String getStoppedServicesString(List<ServiceInfo> list) {
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(new StoppedMessage().getLocalizedMessage());
        for (ServiceInfo serviceInfo : list) {
            if (serviceInfo instanceof WorkerServiceInfo) {
                statusResultsFormatter.add(new WorkerMessage().getLocalizedMessage(), serviceInfo.getServiceName());
                continue;
            }
            if (serviceInfo instanceof JobManagerServiceInfo) {
                statusResultsFormatter.add(new JobManagerMessage().getLocalizedMessage(), serviceInfo.getServiceName());
                continue;
            }
            statusResultsFormatter.add(new UnknownMessage().getLocalizedMessage(), serviceInfo.getServiceName());
        }
        return statusResultsFormatter.getBuffer();
    }

    private static final class MDCESummaryMessage
    extends StatusResultsMessage {
        MDCESummaryMessage(String string) {
            super((BaseMsgID)new mjs.MDCESummary(string));
        }
    }

    private static final class RetrievedMDCEStatusMessage
    extends StatusResultsMessage {
        RetrievedMDCEStatusMessage(String string) {
            super((BaseMsgID)new mjs.RetrievedMDCEStatus(string));
        }
    }

    private static final class LostConnectionToMessage
    extends StatusResultsMessage {
        LostConnectionToMessage(String string) {
            super((BaseMsgID)new mjs.LostConnectionTo(string));
        }
    }

    private static final class LostConnectionMessage
    extends StatusResultsMessage {
        LostConnectionMessage() {
            super((BaseMsgID)new mjs.LostConnection());
        }
    }

    private static final class WorkerFailedToConnectMessage
    extends StatusResultsMessage {
        WorkerFailedToConnectMessage() {
            super((BaseMsgID)new mjs.WorkerFailedToConnect());
        }
    }

    private static final class ConnectionFailedMessage
    extends StatusResultsMessage {
        ConnectionFailedMessage() {
            super((BaseMsgID)new mjs.ConnectionFailed());
        }
    }

    private static final class ConnectionOkMessage
    extends StatusResultsMessage {
        ConnectionOkMessage() {
            super((BaseMsgID)new mjs.ConnectionOk());
        }
    }

    private static final class NotRunningMessage
    extends StatusResultsMessage {
        NotRunningMessage() {
            super((BaseMsgID)new mjs.NotRunning());
        }
    }

    private static final class RunningMessage
    extends StatusResultsMessage {
        RunningMessage() {
            super((BaseMsgID)new mjs.Running());
        }
    }

    private static final class MDCEDefFileMessage
    extends StatusResultsMessage {
        MDCEDefFileMessage() {
            super((BaseMsgID)new mjs.MDCEDefFile());
        }
    }

    private static final class MDCEPlatformMessage
    extends StatusResultsMessage {
        MDCEPlatformMessage() {
            super((BaseMsgID)new mjs.MDCEPlatform());
        }
    }

    private static final class MDCEMatlabRootMessage
    extends StatusResultsMessage {
        MDCEMatlabRootMessage() {
            super((BaseMsgID)new mjs.MDCEMatlabRoot());
        }
    }

    private static final class MDCEVersionMessage
    extends StatusResultsMessage {
        MDCEVersionMessage() {
            super((BaseMsgID)new mjs.MDCEVersion());
        }
    }

    private static final class MDCESecurityLevelMessage
    extends StatusResultsMessage {
        MDCESecurityLevelMessage() {
            super((BaseMsgID)new mjs.MDCESecurityLevel());
        }
    }

    private static final class MDCEMessage
    extends StatusResultsMessage {
        MDCEMessage() {
            super((BaseMsgID)new mjs.MDCE());
        }
    }

    private static final class LookupProcessesMessage
    extends StatusResultsMessage {
        LookupProcessesMessage() {
            super((BaseMsgID)new mjs.LookupProcesses());
        }
    }

    private static final class LookupProcessMessage
    extends StatusResultsMessage {
        LookupProcessMessage() {
            super((BaseMsgID)new mjs.LookupProcess());
        }
    }

    private static final class WorkerStartupDirMessage
    extends StatusResultsMessage {
        WorkerStartupDirMessage() {
            super((BaseMsgID)new mjs.WorkerStartupDir());
        }
    }

    private static final class FileDependDirMessage
    extends StatusResultsMessage {
        FileDependDirMessage() {
            super((BaseMsgID)new mjs.FileDependDir());
        }
    }

    private static final class WorkerJMHostnameMessage
    extends StatusResultsMessage {
        WorkerJMHostnameMessage() {
            super((BaseMsgID)new mjs.WorkerJMHostname());
        }
    }

    private static final class WorkerJMConnectionStatusMessage
    extends StatusResultsMessage {
        WorkerJMConnectionStatusMessage() {
            super((BaseMsgID)new mjs.WorkerJMConnectionStatus());
        }
    }

    private static final class StatusMessage
    extends StatusResultsMessage {
        StatusMessage() {
            super((BaseMsgID)new mjs.Status());
        }
    }

    private static final class BusyMessage
    extends StatusResultsMessage {
        BusyMessage() {
            super((BaseMsgID)new mjs.Busy());
        }
    }

    private static final class IdleMessage
    extends StatusResultsMessage {
        IdleMessage() {
            super((BaseMsgID)new mjs.Idle());
        }
    }

    private static final class WorkersMessage
    extends StatusResultsMessage {
        WorkersMessage() {
            super((BaseMsgID)new mjs.Workers());
        }
    }

    private static final class WorkerMessage
    extends StatusResultsMessage {
        WorkerMessage() {
            super((BaseMsgID)new mjs.Worker());
        }
    }

    private static final class WorkerLeaseTimeoutMessage
    extends StatusResultsMessage {
        WorkerLeaseTimeoutMessage() {
            super((BaseMsgID)new mjs.WorkerLeaseTimeout());
        }
    }

    private static final class DatabaseCacheSizeMessage
    extends StatusResultsMessage {
        DatabaseCacheSizeMessage() {
            super((BaseMsgID)new mjs.DatabaseCacheSize());
        }
    }

    private static final class VMHeapSizeMessage
    extends StatusResultsMessage {
        VMHeapSizeMessage() {
            super((BaseMsgID)new mjs.VMHeapSize());
        }
    }

    private static final class DatabaseSizeMessage
    extends StatusResultsMessage {
        DatabaseSizeMessage() {
            super((BaseMsgID)new mjs.DatabaseSize());
        }
    }

    private static final class WorkerNamesHostNamesMessage
    extends StatusResultsMessage {
        WorkerNamesHostNamesMessage() {
            super((BaseMsgID)new mjs.WorkerNamesHostNames());
        }
    }

    private static final class NumWorkersMessage
    extends StatusResultsMessage {
        NumWorkersMessage() {
            super((BaseMsgID)new mjs.NumWorkers());
        }
    }

    private static final class JobManagersMessage
    extends StatusResultsMessage {
        JobManagersMessage() {
            super((BaseMsgID)new mjs.JobManagers());
        }
    }

    private static final class JobManagerMessage
    extends StatusResultsMessage {
        JobManagerMessage() {
            super((BaseMsgID)new mjs.JobManager());
        }
    }

    private static final class UsingMulticastMessage
    extends StatusResultsMessage {
        UsingMulticastMessage() {
            super((BaseMsgID)new mjs.UsingMulticast());
        }
    }

    private static final class RegisteredWithLookupMessage
    extends StatusResultsMessage {
        RegisteredWithLookupMessage() {
            super((BaseMsgID)new mjs.RegisteredWithLookup());
        }
    }

    private static final class LookupInConfigMessage
    extends StatusResultsMessage {
        LookupInConfigMessage() {
            super((BaseMsgID)new mjs.LookupInConfig());
        }
    }

    private static final class PortMessage
    extends StatusResultsMessage {
        PortMessage() {
            super((BaseMsgID)new mjs.Port());
        }
    }

    private static final class StartTimeMessage
    extends StatusResultsMessage {
        StartTimeMessage() {
            super((BaseMsgID)new mjs.StartTime());
        }
    }

    private static final class NetworkAddressesMessage
    extends StatusResultsMessage {
        NetworkAddressesMessage() {
            super((BaseMsgID)new mjs.NetworkAddresses());
        }
    }

    private static final class RunningOnHostMessage
    extends StatusResultsMessage {
        RunningOnHostMessage() {
            super((BaseMsgID)new mjs.RunningOnHost());
        }
    }

    private static final class NameMessage
    extends StatusResultsMessage {
        NameMessage() {
            super((BaseMsgID)new mjs.Name());
        }
    }

    private static final class UnknownMessage
    extends StatusResultsMessage {
        UnknownMessage() {
            super((BaseMsgID)new mjs.Unknown());
        }
    }

    private static final class StoppedMessage
    extends StatusResultsMessage {
        StoppedMessage() {
            super((BaseMsgID)new mjs.Stopped());
        }
    }

    private static abstract class StatusResultsMessage
    extends ControlMessage {
        private final BaseMsgID fBaseMsgID;

        StatusResultsMessage(BaseMsgID baseMsgID) {
            this.fBaseMsgID = baseMsgID;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

