/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.control.ClusterLogsConfigParser;
import com.mathworks.toolbox.distcomp.control.ControlConfigurationMessageException;
import com.mathworks.toolbox.distcomp.control.ControlMessageException;
import com.mathworks.toolbox.distcomp.control.ControlStartStopConfigParser;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandArray;
import com.mathworks.toolbox.distcomp.control.StatusConfigParser;
import com.mathworks.toolbox.distcomp.util.ConfigFileWrapper;
import com.mathworks.toolbox.distcomp.util.RemoteConfigurationFileOverride;
import com.mathworks.toolbox.distcomp.util.SystemPropertyNames;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import net.jini.config.ConfigurationException;

public class CommandConfigParser {
    public static final String REMOTE_COMMAND_TYPE = "remoteCommandType";
    public static final String REMOTE_HOSTNAME = "remoteHostname";
    public static final String REMOTE_COMMAND_PORT = "remoteCommandPort";
    public static final String VERBOSITY = "verbosity";
    public static final String JOBMANAGER_REMOTE_COMMAND_TYPE = "jobmanager";
    public static final String LOOKUP_REMOTE_COMMAND_TYPE = "lookup";
    public static final String WORKER_REMOTE_COMMAND_TYPE = "worker";
    public static final String NODE_STATUS = "nodestatus";
    public static final String CLUSTER_LOGS = "clusterlogs";
    public static final String NUM_COMMANDS = "numCommands";
    public static final String SERVICE_NAME = "serviceName";

    private CommandConfigParser() {
    }

    private static boolean serviceTypeIsStartStopProcess(String string) {
        return string.equals(JOBMANAGER_REMOTE_COMMAND_TYPE) || string.equals(LOOKUP_REMOTE_COMMAND_TYPE) || string.equals(WORKER_REMOTE_COMMAND_TYPE);
    }

    public static MDCSCommand createMDCSCommand(ConfigFileWrapper configFileWrapper) throws ConfigurationException, ControlMessageException {
        String string = configFileWrapper.getNonEmptyStringEntry(REMOTE_COMMAND_TYPE);
        int n = configFileWrapper.getIntEntry(NUM_COMMANDS);
        if (n > 1) {
            assert (CommandConfigParser.serviceTypeIsStartStopProcess(string)) : "Multiple commands only supported for Starting and Stopping processes";
            return CommandConfigParser.createMultipleMDCSCommands(n, configFileWrapper);
        }
        if (CommandConfigParser.serviceTypeIsStartStopProcess(string)) {
            return ControlStartStopConfigParser.createStartStopCommand(configFileWrapper);
        }
        if (string.equals(NODE_STATUS)) {
            return StatusConfigParser.createStatusCommand(configFileWrapper);
        }
        if (string.equals(CLUSTER_LOGS)) {
            return ClusterLogsConfigParser.createClusterLogsCommand(configFileWrapper);
        }
        throw new ControlConfigurationException(string);
    }

    private static MDCSCommand createMultipleMDCSCommands(int n, ConfigFileWrapper configFileWrapper) throws ConfigurationException, ControlMessageException {
        MDCSCommand[] mDCSCommandArray = new MDCSCommand[n];
        String string = configFileWrapper.getStringEntry(SERVICE_NAME);
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(configFileWrapper.getConfigurationStringArray()));
        RemoteConfigurationFileOverride remoteConfigurationFileOverride = new RemoteConfigurationFileOverride(SystemPropertyNames.SERVICE_NAME, string);
        RemoteConfigurationFileOverride remoteConfigurationFileOverride2 = new RemoteConfigurationFileOverride(SystemPropertyNames.NUM_COMMANDS, "1", RemoteConfigurationFileOverride.ConfigType.Integer);
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!string2.startsWith(SystemPropertyNames.SERVICE_NAME.getConfigName() + "=") && !string2.startsWith(SystemPropertyNames.NUM_COMMANDS.getConfigName() + "=")) continue;
            listIterator.remove();
        }
        linkedList.add(remoteConfigurationFileOverride2.getConfigEntryOverride());
        for (int i = 0; i < n; ++i) {
            remoteConfigurationFileOverride.setValue(string + "_" + i);
            LinkedList<String> linkedList2 = new LinkedList<String>(linkedList);
            linkedList2.add(remoteConfigurationFileOverride.getConfigEntryOverride());
            String[] stringArray = linkedList2.toArray(new String[linkedList.size()]);
            mDCSCommandArray[i] = CommandConfigParser.createMDCSCommand(new ConfigFileWrapper(stringArray));
        }
        return new MDCSCommandArray(mDCSCommandArray);
    }

    public static String getRemoteHostname(ConfigFileWrapper configFileWrapper) throws ConfigurationException {
        return configFileWrapper.getNonEmptyStringEntry(REMOTE_HOSTNAME);
    }

    public static int getRemotePort(ConfigFileWrapper configFileWrapper) throws ConfigurationException {
        int n = configFileWrapper.getIntEntry(REMOTE_COMMAND_PORT);
        return n;
    }

    public static boolean isVerbose(ConfigFileWrapper configFileWrapper) throws ConfigurationException {
        boolean bl = false;
        return configFileWrapper.getBooleanEntry(VERBOSITY, bl);
    }

    private static final class ControlConfigurationException
    extends ControlConfigurationMessageException {
        private final BaseMsgID fBaseMsgID;

        ControlConfigurationException(String string) {
            this.fBaseMsgID = new mjs.ControlConfigurationProblem(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

