/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.SignatureModule;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleHelper;
import com.mathworks.toolbox.distcomp.auth.modules.ModuleCreationException;
import com.mathworks.toolbox.distcomp.util.ObjectSerializer;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;

public class SignatureModuleKeyPairImpl
implements SignatureModule {
    private KeyPair fKeyPair;

    public SignatureModuleKeyPairImpl() throws ModuleCreationException {
        try {
            this.fKeyPair = CryptoModuleHelper.INSTANCE.generateKeyPair();
        }
        catch (CryptoException cryptoException) {
            throw new UnknownModuleCreationErrorException(cryptoException);
        }
    }

    public PublicKey getPublicKey() {
        return this.fKeyPair.getPublic();
    }

    @Override
    public SignatureModule.Signer getSigner() {
        return new SignatureModule.Signer(){

            @Override
            public byte[] sign(Erasable erasable) throws CryptoException {
                return CryptoModuleHelper.INSTANCE.sign(erasable.get(), SignatureModuleKeyPairImpl.this.fKeyPair.getPrivate());
            }
        };
    }

    @Override
    public SignatureModule.Verifier getVerifier() {
        return new SignatureVerifier();
    }

    public static void writePublicKeyToProperties(PublicKey publicKey) {
        try {
            String string = ObjectSerializer.serializeToString(publicKey);
            System.setProperty("com.mathworks.toolbox.distcomp.jobmanager.serializedPublicKey", string);
        }
        catch (IOException iOException) {
            throw new UnableToSerializePublicKeyToStringException(iOException);
        }
    }

    public static PublicKey readPublicKeyFromProperties() throws ClassNotFoundException, IOException {
        String string = System.getProperty("com.mathworks.toolbox.distcomp.jobmanager.serializedPublicKey");
        return (PublicKey)ObjectSerializer.deserializeFromString(string);
    }

    private static class UnableToSerializePublicKeyToStringException
    extends ModuleCreationException {
        UnableToSerializePublicKeyToStringException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.UnableToSerializePublicKeyToString(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.UnableToSerializePublicKeyToString(this.getCause().getLocalizedMessage());
        }
    }

    private static class UnknownModuleCreationErrorException
    extends ModuleCreationException {
        UnknownModuleCreationErrorException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.UnknownModuleCreationError(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.UnknownModuleCreationError(this.getCause().getLocalizedMessage());
        }
    }

    private static final class SignatureVerifier
    implements SignatureModule.Verifier {
        private SignatureVerifier() {
        }

        @Override
        public void verify(Erasable erasable, byte[] byArray, PublicKey publicKey) throws CryptoException {
            if (!CryptoModuleHelper.INSTANCE.verify(erasable.get(), byArray, publicKey)) {
                throw new SignatureModule.SignatureVerificationException();
            }
        }
    }
}

