<!-- C Coder project version history:

                Declared plugin version         Declared project version
     ==========================================================================================
     11a        none (default is 1.0)           none (default is 1.0)
     11b        none (default is 1.0)           none (default is 1.0)
     12a        R2012a                          1.0 (+ extra data ignored by 11a/b)
     12b        R2012a                          1.0 (+ extra data ignored by 11a/b)
     13a prerel R2012a                          R2012a
     13a        R2013a                          R2013a
     14a        R2014a                          R2014a_nu
     14b        R2014b                          R2014a_nu

     This file converts "R2013a"-stamped C projects and all HDL Coder projects to "R2014b"-stamped
     unified projects. For older C projects, the translation happens by following a path to
     "R2013a" using other translation files that reside alongside this one. The rules for the use
     of these files are governed by the UnifiedTargetFactory class.

     For R2014b, the objective will be defaulted to Fixed-Point as only the Fixed-Point Converter App
     will use the new specification.

     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     !!! CHANGES TO XSL FILES LIKE THIS ONE ARE ONLY PICKED UP IF YOU BUILD THE ACTUAL JAR FILE !!!
     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

     gmake COMPONENTS_TO_BUILD="coder_java" prebuild

-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="deployment-project">
        <deployment-project plugin="plugin.coder" plugin-version="R2014b">
            <configuration target="target.coder" target-name="MATLAB Coder">
                <xsl:attribute name="file"><xsl:value-of select="configuration/@file" /></xsl:attribute>
                <xsl:attribute name="location"><xsl:value-of select="configuration/@location" /></xsl:attribute>
                <xsl:attribute name="name"><xsl:value-of select="configuration/@name" /></xsl:attribute>

                <!-- Here we drive the general copying of configuration content. For HDL projects,
                     we have to wrap the params in the HDL profile. For non-HDL projects, the
                     original structure is copied verbatim (it has the profile-specific params
                     already in profiles). -->

                <param.objective>option.objective.fixedpoint</param.objective>
                <xsl:apply-templates select="configuration/node()[starts-with(name(), 'param.')]" />
                <xsl:apply-templates select="configuration/node()[name() = 'unset']" />

                <xsl:choose>
                    <xsl:when test="@plugin = 'plugin.matlabhdlcoder'">
                        <!--<param.objective>option.objective.hdl</param.objective>-->
                        <profile key="profile.hdl">
                            <xsl:apply-templates select="configuration/node()[starts-with(name(), 'param.')]" />
                            <xsl:apply-templates select="configuration/node()[name() = 'unset']" />
                        </profile>
                    </xsl:when>
                    <xsl:otherwise>
                        <!--<param.objective>option.objective.c</param.objective>-->
                        <xsl:apply-templates select="configuration/node()[starts-with(name(), 'param.')]" />
                        <xsl:apply-templates select="configuration/node()[name() = 'unset']" />
                    </xsl:otherwise>
                </xsl:choose>

                <xsl:apply-templates select="configuration/node()[name() != 'unset' and not(starts-with(name(), 'param.'))]" />

                <!-- There used to be a file-set for test files; now there is a string-list of
                     test snippets, which is quite a different animal. Due to file aliasing mechanisms,
                     XSLT can't fully do this conversion, so here we generate marked string-list items in
                     a format agreed upon by the CoderAppModel class, which then finishes converting
                     them on load. -->

                <param.TestSnippets>
                    <xsl:for-each select="configuration/fileset.testbench/file">
                        <item>__fileset.testbench::<xsl:value-of select="." /></item>
                    </xsl:for-each>

                    <xsl:for-each select="configuration/fileset.scriptfile/file">
                        <item>__fileset.testbench::<xsl:value-of select="." /></item>
                    </xsl:for-each>
                </param.TestSnippets>

                <!-- There is a semi-artificial param to enable the global variable display in the new UI.
                     We need to turn it on if the old project had globals defined. -->

                <xsl:choose>
                    <xsl:when test="count(configuration/param.globals) != 0">
                        <param.UseGlobals>true</param.UseGlobals>
                    </xsl:when>
                    <xsl:otherwise>
                        <param.UseGlobals>false</param.UseGlobals>
                    </xsl:otherwise>
                </xsl:choose>

                <var.LegacyTarget>
                    <xsl:value-of select="configuration/@target" />
                </var.LegacyTarget>

                <xsl:if test="configuration/@target = 'target.matlab.hdlcoder'">
                    <var.MirrorOnOpen>true</var.MirrorOnOpen>
                </xsl:if>
            </configuration>
        </deployment-project>
    </xsl:template>

    <!-- Rename HDL params that are not HDL-specific and have simpler-named counterparts in C Coder -->

    <xsl:template match="param.fixptconv.InstrumentedMexFile">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.InstrumentedBuildChecksum">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.ShowCoverage">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.FixedPointValidationChecksum">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.FixedPointSourceCodeChecksum">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.FixedPointStaticAnalysisChecksum">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.DefaultTestFile">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.ExcludedFixedPointVerificationTestFiles">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.ExcludedFixedPointSimulationFiles">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.ContainerTypes">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.DefaultTestFile">
        <param.hdl.LegacyDefaultTestFile>
            <xsl:apply-templates />
        </param.hdl.LegacyDefaultTestFile>
    </xsl:template>

    <xsl:template match="param.fixptconv.FixptProposalKind">
        <param.FixedPointTypeProposalMode>
           <xsl:choose>
               <xsl:when test="text() = 'option.fixptconv.ProposeFracLenBasedOnWordLen'">
                   option.FixedPointTypeProposalMode.ProposeFractionLengths
               </xsl:when>
               <xsl:when test="text() = 'option.fixptconv.ProposeWordLenBasedOnFracLen'">
                   option.FixedPointTypeProposalMode.ProposeWordLengths
               </xsl:when>
               <xsl:otherwise>
                   <xsl:apply-templates />
               </xsl:otherwise>
           </xsl:choose>
        </param.FixedPointTypeProposalMode>
    </xsl:template>

    <xsl:template match="param.fixptconv.DefaultFixptWordLength">
        <param.DefaultWordLength>
            <xsl:apply-templates />
        </param.DefaultWordLength>
    </xsl:template>

    <xsl:template match="param.fixptconv.DefaultFixptFractionLength">
        <param.DefaultFractionLength>
            <xsl:apply-templates />
        </param.DefaultFractionLength>
    </xsl:template>

    <xsl:template match="param.fixptconv.SafetyMargin">
        <param.FixedPointSafetyMargin>
            <xsl:apply-templates />
        </param.FixedPointSafetyMargin>
    </xsl:template>

    <xsl:template match="param.fixptconv.ProposeUsingDesignMinMaxAnd">
        <param.FixedPointTypeSource>
            <xsl:apply-templates />
        </param.FixedPointTypeSource>
    </xsl:template>

    <xsl:template match="param.fixptconv.FiMathString">
        <param.FixedPointFimath>
            <xsl:apply-templates />
        </param.FixedPointFimath>
    </xsl:template>

    <xsl:template match="param.fixptconv.PlotFunction">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.transformedVariables">
        <param.UserFixedPointData>
            <xsl:apply-templates />
        </param.UserFixedPointData>
    </xsl:template>

    <xsl:template match="param.computedVariables">
        <param.ComputedFixedPointData>
            <xsl:apply-templates />
        </param.ComputedFixedPointData>
    </xsl:template>

    <xsl:template match="param.fixptconv.DefaultRoundMode">
        <!-- Suppressed; this was folded into the fimath param in 13a -->
    </xsl:template>

    <xsl:template match="param.fixptconv.DefaultOverflowMode">
        <!-- Suppressed; this was folded into the fimath param in 13a -->
    </xsl:template>

    <xsl:template match="param.fixptconv.LogAllIOValues">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.DetectOverflows">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.LogHistogram">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.FixPtFileNameSuffix">
        <param.GeneratedFixedPointFileSuffix>
            <xsl:apply-templates />
        </param.GeneratedFixedPointFileSuffix>
    </xsl:template>

    <xsl:template match="param.fixptconv.AutoScaleLoopIndexVariables">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.generatefixptcode.function_replacements">
        <param.FixedPointFunctionReplacements>
            <xsl:apply-templates />
        </param.FixedPointFunctionReplacements>
    </xsl:template>

    <xsl:template match="param.fixptconv.OptimizeWholeNumbers">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.DefaultFixedPointSignedness">
        <param.DefaultFixedPointSignedness>
            <xsl:choose>
                <xsl:when test="starts-with(text(), 'option.fixptconv.')">
                    <xsl:value-of select="concat('option.', substring-after(text(), 'option.fixptconv.'))"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
        </param.DefaultFixedPointSignedness>
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.StaticAnalysisTimeout">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.fixptconv.StaticAnalysisGlobalRangesOnly">
        <xsl:call-template name="stripFixptConv" />
    </xsl:template>

    <xsl:template match="param.hdl.GenerateComments">
        <xsl:call-template name="stripHdl" />
    </xsl:template>

    <xsl:template match="param.hdl.MATLABSourceComments">
        <xsl:call-template name="stripHdl" />
    </xsl:template>

    <xsl:template match="param.hdl.GenerateReport">
        <xsl:call-template name="stripHdl" />
    </xsl:template>

    <xsl:template match="param.hdl.SearchPath">
        <param.SearchPaths>
            <xsl:apply-templates />
        </param.SearchPaths>
    </xsl:template>

    <xsl:template match="param.hdl.WorkingDirectory">
        <param.WorkingFolder>
            <xsl:choose>
                <xsl:when test="text() = 'option.hdl.ProjectDirectory'">option.WorkingFolder.Project</xsl:when>
                <xsl:when test="text() = 'option.hdl.CurrentDirectory'">option.WorkingFolder.Current</xsl:when>
                <xsl:when test="text() = 'option.hdl.WorkingSpecifiedDirectory'">option.WorkingFolder.Specified</xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates />
                </xsl:otherwise>
            </xsl:choose>
        </param.WorkingFolder>
    </xsl:template>

    <xsl:template match="param.hdl.WorkingSpecifiedDirectory">
        <param.SpecifiedWorkingFolder>
            <xsl:apply-templates />
        </param.SpecifiedWorkingFolder>
    </xsl:template>

    <xsl:template match="param.hdl.BuildDirectory">
        <param.BuildFolder>
            <xsl:choose>
                <xsl:when test="text() = 'option.hdl.ProjectDirectory'">option.BuildFolder.Project</xsl:when>
                <xsl:when test="text() = 'option.hdl.CurrentDirectory'">option.BuildFolder.Current</xsl:when>
                <xsl:when test="text() = 'option.hdl.BuildSpecifiedDirectory'">option.BuildFolder.Specified</xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates />
                </xsl:otherwise>
            </xsl:choose>
        </param.BuildFolder>
    </xsl:template>

    <xsl:template match="param.hdl.BuildSpecifiedDirectory">
        <param.SpecifiedBuildFolder>
            <xsl:apply-templates />
        </param.SpecifiedBuildFolder>
    </xsl:template>

    <!-- Utility templates -->

    <xsl:template name="stripFixptConv">
        <xsl:element name="{concat('param.', substring-after(name(), 'param.fixptconv.'))}">
            <xsl:apply-templates />
        </xsl:element>
    </xsl:template>

    <xsl:template name="stripHdl">
        <xsl:element name="{concat('param.', substring-after(name(), 'param.hdl.'))}">
            <xsl:apply-templates />
        </xsl:element>
    </xsl:template>

    <!-- This is the entry point (copy everything recursively but with specialized templates where
         applicable). -->

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>