#ifndef	_LCC_D3DTYPES_H_ 
#define	_LCC_D3DTYPES_H_ 
#include	<windows.h> 
#include	<ddraw.h> 
#pragma	pack(push,4) 
#define	D3DVALP(val, prec) ((float)(val)) 
#define	D3DVAL(val) ((float)(val)) 
typedef	float D3DVALUE, *LPD3DVALUE; 
#define	D3DDivide(a, b) (float)((double) (a) / (double) (b)) 
#define	D3DMultiply(a, b) ((a) * (b)) 
typedef	LONG D3DFIXED; 
#ifndef	RGB_MAKE 
#define	CI_GETALPHA(ci) ((ci) >> 24) 
#define	CI_GETINDEX(ci) (((ci) >> 8) & 0xffff) 
#define	CI_GETFRACTION(ci) ((ci) & 0xff) 
#define	CI_ROUNDINDEX(ci) CI_GETINDEX((ci) + 0x80) 
#define	CI_MASKALPHA(ci) ((ci) & 0xffffff) 
#define	CI_MAKE(a, i, f) (((a) << 24) | ((i) << 8) | (f)) 
#define	RGBA_GETALPHA(rgb) ((rgb) >> 24) 
#define	RGBA_GETRED(rgb) (((rgb) >> 16) & 0xff) 
#define	RGBA_GETGREEN(rgb) (((rgb) >> 8) & 0xff) 
#define	RGBA_GETBLUE(rgb) ((rgb) & 0xff) 
#define	RGBA_MAKE(r, g, b, a) ((D3DCOLOR) (((a) << 24) | ((r) << 16) | ((g) << 8) | (b))) 
#define	D3DRGB(r, g, b) (0xff000000L | ( ((long)((r) * 255)) << 16) | (((long)((g) * 255)) << 8) | (long)((b) * 255)) 
#define	D3DRGBA(r, g, b, a) ( (((long)((a) * 255)) << 24) | (((long)((r) * 255)) << 16) | (((long)((g) * 255)) << 8) | (long)((b) * 255)) 
#define	RGB_GETRED(rgb) (((rgb) >> 16) & 0xff) 
#define	RGB_GETGREEN(rgb) (((rgb) >> 8) & 0xff) 
#define	RGB_GETBLUE(rgb) ((rgb) & 0xff) 
#define	RGBA_SETALPHA(rgba, x) (((x) << 24) | ((rgba) & 0x00ffffff)) 
#define	RGB_MAKE(r, g, b) ((D3DCOLOR) (((r) << 16) | ((g) << 8) | (b))) 
#define	RGBA_TORGB(rgba) ((D3DCOLOR) ((rgba) & 0xffffff)) 
#define	RGB_TORGBA(rgb) ((D3DCOLOR) ((rgb) | 0xff000000)) 
#endif	
#define	D3DENUMRET_CANCEL DDENUMRET_CANCEL 
#define	D3DENUMRET_OK DDENUMRET_OK 
typedef	HRESULT (WINAPI* LPD3DVALIDATECALLBACK)(LPVOID lpUserArg, DWORD dwOffset); 
typedef	HRESULT (WINAPI* LPD3DENUMTEXTUREFORMATSCALLBACK)(LPDDSURFACEDESC lpDdsd, LPVOID lpContext); 
typedef	DWORD D3DCOLOR, D3DCOLOR, *LPD3DCOLOR; 
typedef	DWORD D3DMATERIALHANDLE, *LPD3DMATERIALHANDLE; 
typedef	DWORD D3DTEXTUREHANDLE, *LPD3DTEXTUREHANDLE; 
typedef	DWORD D3DMATRIXHANDLE, *LPD3DMATRIXHANDLE; 
typedef	struct _D3DCOLORVALUE { 
	union { D3DVALUE r; D3DVALUE dvR; }; 
	union { D3DVALUE g; D3DVALUE dvG; }; 
	union { D3DVALUE b; D3DVALUE dvB; }; 
	union { D3DVALUE a; D3DVALUE dvA; }; 
}	D3DCOLORVALUE; 
typedef	struct _D3DRECT { 
	union { LONG x1; LONG lX1; }; 
	union { LONG y1; LONG lY1; }; 
	union { LONG x2; LONG lX2; }; 
	union { LONG y2; LONG lY2; }; 
}	D3DRECT, *LPD3DRECT; 
typedef	struct _D3DVECTOR { 
	union { D3DVALUE x; D3DVALUE dvX; }; 
	union { D3DVALUE y; D3DVALUE dvY; }; 
	union { D3DVALUE z; D3DVALUE dvZ; }; 
}	D3DVECTOR, *LPD3DVECTOR; 
typedef	struct _D3DHVERTEX { 
	DWORD dwFlags; 
	union { D3DVALUE hx; D3DVALUE dvHX; }; 
	union { D3DVALUE hy; D3DVALUE dvHY; }; 
	union { D3DVALUE hz; D3DVALUE dvHZ; }; 
}	D3DHVERTEX, *LPD3DHVERTEX; 
typedef	struct _D3DTLVERTEX { 
	union { D3DVALUE sx; D3DVALUE dvSX; }; 
	union { D3DVALUE sy; D3DVALUE dvSY; }; 
	union { D3DVALUE sz; D3DVALUE dvSZ; }; 
	union { D3DVALUE rhw; D3DVALUE dvRHW; }; 
	union { D3DCOLOR color; D3DCOLOR dcColor; }; 
	union { D3DCOLOR specular; D3DCOLOR dcSpecular; }; 
	union { D3DVALUE tu; D3DVALUE dvTU; }; 
	union { D3DVALUE tv; D3DVALUE dvTV; }; 
}	D3DTLVERTEX, *LPD3DTLVERTEX; 
typedef	struct _D3DLVERTEX { 
	union { D3DVALUE x; D3DVALUE dvX; }; 
	union { D3DVALUE y; D3DVALUE dvY; }; 
	union { D3DVALUE z; D3DVALUE dvZ; }; 
	DWORD dwReserved; 
	union { D3DCOLOR color; D3DCOLOR dcColor; }; 
	union { D3DCOLOR specular; D3DCOLOR dcSpecular; }; 
	union { D3DVALUE tu; D3DVALUE dvTU; }; 
	union { D3DVALUE tv; D3DVALUE dvTV; }; 
}	D3DLVERTEX, *LPD3DLVERTEX; 
typedef	struct _D3DVERTEX { 
	union { D3DVALUE x; D3DVALUE dvX; }; 
	union { D3DVALUE y; D3DVALUE dvY; }; 
	union { D3DVALUE z; D3DVALUE dvZ; }; 
	union { D3DVALUE nx; D3DVALUE dvNX; }; 
	union { D3DVALUE ny; D3DVALUE dvNY; }; 
	union { D3DVALUE nz; D3DVALUE dvNZ; }; 
	union { D3DVALUE tu; D3DVALUE dvTU; }; 
	union { D3DVALUE tv; D3DVALUE dvTV; }; 
}	D3DVERTEX, *LPD3DVERTEX; 
typedef	struct _D3DMATRIX { D3DVALUE _11, _12, _13, _14; 
	D3DVALUE _21, _22, _23, _24; 
	D3DVALUE _31, _32, _33, _34; 
	D3DVALUE _41, _42, _43, _44; 
}	D3DMATRIX, *LPD3DMATRIX; 
typedef	struct _D3DVIEWPORT { 
	DWORD dwSize; 
	DWORD dwX; 
	DWORD dwY; 
	DWORD dwWidth; 
	DWORD dwHeight; 
	D3DVALUE dvScaleX; 
	D3DVALUE dvScaleY; 
	D3DVALUE dvMaxX; 
	D3DVALUE dvMaxY; 
	D3DVALUE dvMinZ; 
	D3DVALUE dvMaxZ; 
}	D3DVIEWPORT, *LPD3DVIEWPORT; 
#define	D3DCLIP_LEFT 1 
#define	D3DCLIP_RIGHT 2 
#define	D3DCLIP_TOP 4 
#define	D3DCLIP_BOTTOM 8 
#define	D3DCLIP_FRONT 16 
#define	D3DCLIP_BACK 0x20 
#define	D3DCLIP_GEN0 0x40 
#define	D3DCLIP_GEN1 0x80 
#define	D3DCLIP_GEN2 0x100 
#define	D3DCLIP_GEN3 0x200 
#define	D3DCLIP_GEN4 0x400 
#define	D3DCLIP_GEN5 0x800 
#define	D3DSTATUS_CLIPUNIONLEFT D3DCLIP_LEFT 
#define	D3DSTATUS_CLIPUNIONRIGHT D3DCLIP_RIGHT 
#define	D3DSTATUS_CLIPUNIONTOP D3DCLIP_TOP 
#define	D3DSTATUS_CLIPUNIONBOTTOM D3DCLIP_BOTTOM 
#define	D3DSTATUS_CLIPUNIONFRONT D3DCLIP_FRONT 
#define	D3DSTATUS_CLIPUNIONBACK D3DCLIP_BACK 
#define	D3DSTATUS_CLIPUNIONGEN0 D3DCLIP_GEN0 
#define	D3DSTATUS_CLIPUNIONGEN1 D3DCLIP_GEN1 
#define	D3DSTATUS_CLIPUNIONGEN2 D3DCLIP_GEN2 
#define	D3DSTATUS_CLIPUNIONGEN3 D3DCLIP_GEN3 
#define	D3DSTATUS_CLIPUNIONGEN4 D3DCLIP_GEN4 
#define	D3DSTATUS_CLIPUNIONGEN5 D3DCLIP_GEN5 
#define	D3DSTATUS_CLIPINTERSECTIONLEFT 0x00001000L 
#define	D3DSTATUS_CLIPINTERSECTIONRIGHT 0x00002000L 
#define	D3DSTATUS_CLIPINTERSECTIONTOP 0x00004000L 
#define	D3DSTATUS_CLIPINTERSECTIONBOTTOM 0x00008000L 
#define	D3DSTATUS_CLIPINTERSECTIONFRONT 0x00010000L 
#define	D3DSTATUS_CLIPINTERSECTIONBACK 0x00020000L 
#define	D3DSTATUS_CLIPINTERSECTIONGEN0 0x00040000L 
#define	D3DSTATUS_CLIPINTERSECTIONGEN1 0x00080000L 
#define	D3DSTATUS_CLIPINTERSECTIONGEN2 0x00100000L 
#define	D3DSTATUS_CLIPINTERSECTIONGEN3 0x00200000L 
#define	D3DSTATUS_CLIPINTERSECTIONGEN4 0x00400000L 
#define	D3DSTATUS_CLIPINTERSECTIONGEN5 0x00800000L 
#define	D3DSTATUS_ZNOTVISIBLE 0x01000000L 
#define	D3DSTATUS_CLIPUNIONALL (D3DSTATUS_CLIPUNIONLEFT|D3DSTATUS_CLIPUNIONRIGHT|\
	D3DSTATUS_CLIPUNIONTOP|D3DSTATUS_CLIPUNIONBOTTOM|D3DSTATUS_CLIPUNIONFRONT|\
	D3DSTATUS_CLIPUNIONBACK|D3DSTATUS_CLIPUNIONGEN0|D3DSTATUS_CLIPUNIONGEN1|\
	D3DSTATUS_CLIPUNIONGEN2|D3DSTATUS_CLIPUNIONGEN3|D3DSTATUS_CLIPUNIONGEN4|\
	D3DSTATUS_CLIPUNIONGEN5) 
#define	D3DSTATUS_CLIPINTERSECTIONALL (D3DSTATUS_CLIPINTERSECTIONLEFT|D3DSTATUS_CLIPINTERSECTIONRIGHT | \
	D3DSTATUS_CLIPINTERSECTIONTOP|D3DSTATUS_CLIPINTERSECTIONBOTTOM|D3DSTATUS_CLIPINTERSECTIONFRONT | \
	D3DSTATUS_CLIPINTERSECTIONBACK|D3DSTATUS_CLIPINTERSECTIONGEN0 | \
	D3DSTATUS_CLIPINTERSECTIONGEN1|D3DSTATUS_CLIPINTERSECTIONGEN2 | \
	D3DSTATUS_CLIPINTERSECTIONGEN3|D3DSTATUS_CLIPINTERSECTIONGEN4|D3DSTATUS_CLIPINTERSECTIONGEN5) 
#define	D3DSTATUS_DEFAULT (D3DSTATUS_CLIPINTERSECTIONALL|D3DSTATUS_ZNOTVISIBLE) 
#define	D3DTRANSFORM_CLIPPED 1 
#define	D3DTRANSFORM_UNCLIPPED 2 
typedef	struct _D3DTRANSFORMDATA { 
	DWORD dwSize; 
	LPVOID lpIn; 
	DWORD dwInSize; 
	LPVOID lpOut; 
	DWORD dwOutSize; 
	LPD3DHVERTEX lpHOut; 
	DWORD dwClip; 
	DWORD dwClipIntersection; 
	DWORD dwClipUnion; 
	D3DRECT drExtent; 
}	D3DTRANSFORMDATA, *LPD3DTRANSFORMDATA; 
typedef	struct _D3DLIGHTINGELEMENT { 
	D3DVECTOR dvPosition; 
	D3DVECTOR dvNormal; 
}	D3DLIGHTINGELEMENT, *LPD3DLIGHTINGELEMENT; 
	
typedef	struct _D3DMATERIAL { 
	DWORD dwSize; 
	union { 
	D3DCOLORVALUE diffuse; 
	D3DCOLORVALUE dcvDiffuse; 
	}; 
	union { 
	D3DCOLORVALUE ambient; 
	D3DCOLORVALUE dcvAmbient; 
	}; 
	union { 
	D3DCOLORVALUE specular; 
	D3DCOLORVALUE dcvSpecular; 
	}; 
	union { 
	D3DCOLORVALUE emissive; 
	D3DCOLORVALUE dcvEmissive; 
	}; 
	union { 
	D3DVALUE power; 
	D3DVALUE dvPower; 
	}; 
	D3DTEXTUREHANDLE hTexture; 
	DWORD dwRampSize; 
}	D3DMATERIAL, *LPD3DMATERIAL; 
	
typedef	enum _D3DLIGHTTYPE { 
	D3DLIGHT_POINT = 1, 
	D3DLIGHT_SPOT = 2, 
	D3DLIGHT_DIRECTIONAL = 3, 
	D3DLIGHT_PARALLELPOINT = 4, 
	D3DLIGHT_GLSPOT = 5, 
}	D3DLIGHTTYPE; 
typedef	struct _D3DLIGHT { 
	DWORD dwSize; 
	D3DLIGHTTYPE dltType; 
	D3DCOLORVALUE dcvColor; 
	D3DVECTOR dvPosition; 
	D3DVECTOR dvDirection; 
	D3DVALUE dvRange; 
	D3DVALUE dvFalloff; 
	D3DVALUE dvAttenuation0; 
	D3DVALUE dvAttenuation1; 
	D3DVALUE dvAttenuation2; 
	D3DVALUE dvTheta; 
	D3DVALUE dvPhi; 
}	D3DLIGHT, *LPD3DLIGHT; 
typedef	struct _D3DLIGHTDATA { 
	DWORD dwSize; 
	LPD3DLIGHTINGELEMENT lpIn; 
	DWORD dwInSize; 
	LPD3DTLVERTEX lpOut; 
	DWORD dwOutSize; 
}	D3DLIGHTDATA, *LPD3DLIGHTDATA; 
typedef	enum _D3DCOLORMODEL { 
	D3DCOLOR_MONO = 1, D3DCOLOR_RGB = 2 
}	D3DCOLORMODEL; 
#define	D3DCLEAR_TARGET 1 
#define	D3DCLEAR_ZBUFFER 2 
typedef	enum _D3DOPCODE { 
	D3DOP_POINT = 1, D3DOP_LINE = 2, D3DOP_TRIANGLE = 3, D3DOP_MATRIXLOAD = 4, 
	D3DOP_MATRIXMULTIPLY = 5, D3DOP_STATETRANSFORM = 6, D3DOP_STATELIGHT = 7, 
	D3DOP_STATERENDER = 8, D3DOP_PROCESSVERTICES = 9, D3DOP_TEXTURELOAD = 10, 
	D3DOP_EXIT = 11, D3DOP_BRANCHFORWARD = 12, D3DOP_SPAN = 13, D3DOP_SETSTATUS = 14, 
}	D3DOPCODE; 
typedef	struct _D3DINSTRUCTION { 
	BYTE bOpcode; 
	BYTE bSize; 
	WORD wCount; 
}	D3DINSTRUCTION, *LPD3DINSTRUCTION; 
typedef	struct _D3DTEXTURELOAD { 
	D3DTEXTUREHANDLE hDestTexture; 
	D3DTEXTUREHANDLE hSrcTexture; 
}	D3DTEXTURELOAD, *LPD3DTEXTURELOAD; 
typedef	struct _D3DPICKRECORD { 
	BYTE bOpcode; 
	BYTE bPad; 
	DWORD dwOffset; 
	D3DVALUE dvZ; 
}	D3DPICKRECORD, *LPD3DPICKRECORD; 
typedef	enum _D3DSHADEMODE { 
	D3DSHADE_FLAT = 1, D3DSHADE_GOURAUD = 2, D3DSHADE_PHONG = 3, 
}	D3DSHADEMODE; 
typedef	enum _D3DFILLMODE { 
	D3DFILL_POINT = 1, 
	D3DFILL_WIREFRAME = 2, 
	D3DFILL_SOLID = 3, 
}	D3DFILLMODE; 
typedef	struct _D3DLINEPATTERN { 
	WORD wRepeatFactor; 
	WORD wLinePattern; 
}	D3DLINEPATTERN; 
typedef	enum _D3DTEXTUREFILTER { 
	D3DFILTER_NEAREST = 1, D3DFILTER_LINEAR = 2, D3DFILTER_MIPNEAREST = 3, 
	D3DFILTER_MIPLINEAR = 4, D3DFILTER_LINEARMIPNEAREST = 5, D3DFILTER_LINEARMIPLINEAR = 6, 
}	D3DTEXTUREFILTER; 
typedef	enum _D3DBLEND { 
	D3DBLEND_ZERO = 1, D3DBLEND_ONE = 2, D3DBLEND_SRCCOLOR = 3, 
	D3DBLEND_INVSRCCOLOR = 4, D3DBLEND_SRCALPHA = 5, D3DBLEND_INVSRCALPHA = 6, 
	D3DBLEND_DESTALPHA = 7, D3DBLEND_INVDESTALPHA = 8, D3DBLEND_DESTCOLOR = 9, 
	D3DBLEND_INVDESTCOLOR = 10, D3DBLEND_SRCALPHASAT = 11, D3DBLEND_BOTHSRCALPHA = 12, 
	D3DBLEND_BOTHINVSRCALPHA = 13, 
}	D3DBLEND; 
typedef	enum _D3DTEXTUREBLEND { 
	D3DTBLEND_DECAL = 1, D3DTBLEND_MODULATE = 2, D3DTBLEND_DECALALPHA = 3, 
	D3DTBLEND_MODULATEALPHA = 4, D3DTBLEND_DECALMASK = 5, D3DTBLEND_MODULATEMASK = 6, 
	D3DTBLEND_COPY = 7, 
}	D3DTEXTUREBLEND; 
typedef	enum _D3DTEXTUREADDRESS { 
	D3DTADDRESS_WRAP = 1, D3DTADDRESS_MIRROR = 2, D3DTADDRESS_CLAMP = 3, 
}	D3DTEXTUREADDRESS; 
typedef	enum _D3DCULL { 
	D3DCULL_NONE = 1, D3DCULL_CW = 2, D3DCULL_CCW = 3, 
}	D3DCULL; 
typedef	enum _D3DCMPFUNC { 
	D3DCMP_NEVER = 1, D3DCMP_LESS = 2, D3DCMP_EQUAL = 3, D3DCMP_LESSEQUAL = 4, 
	D3DCMP_GREATER = 5, D3DCMP_NOTEQUAL = 6, D3DCMP_GREATEREQUAL = 7, D3DCMP_ALWAYS = 8, 
}	D3DCMPFUNC; 
typedef	enum _D3DFOGMODE { 
	D3DFOG_NONE = 0, D3DFOG_EXP = 1, D3DFOG_EXP2 = 2, D3DFOG_LINEAR = 3 
}	D3DFOGMODE; 
#define	D3DSTATE_OVERRIDE_BIAS 256 
#define	D3DSTATE_OVERRIDE(type) ((DWORD) (type) + D3DSTATE_OVERRIDE_BIAS) 
typedef	enum _D3DTRANSFORMSTATETYPE { 
	D3DTRANSFORMSTATE_WORLD = 1, D3DTRANSFORMSTATE_VIEW = 2, D3DTRANSFORMSTATE_PROJECTION = 3, 
}	D3DTRANSFORMSTATETYPE; 
typedef	enum _D3DLIGHTSTATETYPE { 
	D3DLIGHTSTATE_MATERIAL = 1, D3DLIGHTSTATE_AMBIENT = 2, D3DLIGHTSTATE_COLORMODEL = 3, 
	D3DLIGHTSTATE_FOGMODE = 4, D3DLIGHTSTATE_FOGSTART = 5, D3DLIGHTSTATE_FOGEND = 6, 
	D3DLIGHTSTATE_FOGDENSITY = 7, 
}	D3DLIGHTSTATETYPE; 
typedef	enum _D3DRENDERSTATETYPE { 
	D3DRENDERSTATE_TEXTUREHANDLE = 1, D3DRENDERSTATE_ANTIALIAS = 2, 
	D3DRENDERSTATE_TEXTUREADDRESS = 3, D3DRENDERSTATE_TEXTUREPERSPECTIVE = 4, 
	D3DRENDERSTATE_WRAPU = 5, D3DRENDERSTATE_WRAPV = 6, D3DRENDERSTATE_ZENABLE = 7, 
	D3DRENDERSTATE_FILLMODE = 8, D3DRENDERSTATE_SHADEMODE = 9, D3DRENDERSTATE_LINEPATTERN = 10, 
	D3DRENDERSTATE_MONOENABLE = 11, D3DRENDERSTATE_ROP2 = 12, D3DRENDERSTATE_PLANEMASK = 13, 
	D3DRENDERSTATE_ZWRITEENABLE = 14, D3DRENDERSTATE_ALPHATESTENABLE = 15, 
	D3DRENDERSTATE_LASTPIXEL = 16, D3DRENDERSTATE_TEXTUREMAG = 17, 
	D3DRENDERSTATE_TEXTUREMIN = 18, D3DRENDERSTATE_SRCBLEND = 19, 
	D3DRENDERSTATE_DESTBLEND = 20, D3DRENDERSTATE_TEXTUREMAPBLEND = 21, 
	D3DRENDERSTATE_CULLMODE = 22, D3DRENDERSTATE_ZFUNC = 23, 
	D3DRENDERSTATE_ALPHAREF = 24, D3DRENDERSTATE_ALPHAFUNC = 25, 
	D3DRENDERSTATE_DITHERENABLE = 26, D3DRENDERSTATE_BLENDENABLE = 27, 
	D3DRENDERSTATE_FOGENABLE = 28, D3DRENDERSTATE_SPECULARENABLE = 29, 
	D3DRENDERSTATE_ZVISIBLE = 30, D3DRENDERSTATE_SUBPIXEL = 31, 
	D3DRENDERSTATE_SUBPIXELX = 32, D3DRENDERSTATE_STIPPLEDALPHA = 33, 
	D3DRENDERSTATE_FOGCOLOR = 34, D3DRENDERSTATE_FOGTABLEMODE = 35, 
	D3DRENDERSTATE_FOGTABLESTART = 36, D3DRENDERSTATE_FOGTABLEEND = 37, 
	D3DRENDERSTATE_FOGTABLEDENSITY = 38, D3DRENDERSTATE_STIPPLEENABLE = 39, 
	D3DRENDERSTATE_STIPPLEPATTERN00 = 64, D3DRENDERSTATE_STIPPLEPATTERN01 = 65, 
	D3DRENDERSTATE_STIPPLEPATTERN02 = 66, D3DRENDERSTATE_STIPPLEPATTERN03 = 67, 
	D3DRENDERSTATE_STIPPLEPATTERN04 = 68, D3DRENDERSTATE_STIPPLEPATTERN05 = 69, 
	D3DRENDERSTATE_STIPPLEPATTERN06 = 70, D3DRENDERSTATE_STIPPLEPATTERN07 = 71, 
	D3DRENDERSTATE_STIPPLEPATTERN08 = 72, D3DRENDERSTATE_STIPPLEPATTERN09 = 73, 
	D3DRENDERSTATE_STIPPLEPATTERN10 = 74, D3DRENDERSTATE_STIPPLEPATTERN11 = 75, 
	D3DRENDERSTATE_STIPPLEPATTERN12 = 76, D3DRENDERSTATE_STIPPLEPATTERN13 = 77, 
	D3DRENDERSTATE_STIPPLEPATTERN14 = 78, D3DRENDERSTATE_STIPPLEPATTERN15 = 79, 
	D3DRENDERSTATE_STIPPLEPATTERN16 = 80, D3DRENDERSTATE_STIPPLEPATTERN17 = 81, 
	D3DRENDERSTATE_STIPPLEPATTERN18 = 82, D3DRENDERSTATE_STIPPLEPATTERN19 = 83, 
	D3DRENDERSTATE_STIPPLEPATTERN20 = 84, D3DRENDERSTATE_STIPPLEPATTERN21 = 85, 
	D3DRENDERSTATE_STIPPLEPATTERN22 = 86, D3DRENDERSTATE_STIPPLEPATTERN23 = 87, 
	D3DRENDERSTATE_STIPPLEPATTERN24 = 88, D3DRENDERSTATE_STIPPLEPATTERN25 = 89, 
	D3DRENDERSTATE_STIPPLEPATTERN26 = 90, D3DRENDERSTATE_STIPPLEPATTERN27 = 91, 
	D3DRENDERSTATE_STIPPLEPATTERN28 = 92, D3DRENDERSTATE_STIPPLEPATTERN29 = 93, 
	D3DRENDERSTATE_STIPPLEPATTERN30 = 94, D3DRENDERSTATE_STIPPLEPATTERN31 = 95, 
}	D3DRENDERSTATETYPE; 
#define	D3DRENDERSTATE_STIPPLEPATTERN(y) (D3DRENDERSTATE_STIPPLEPATTERN00 + (y)) 
typedef	struct _D3DSTATE { 
	union { 
	D3DTRANSFORMSTATETYPE dtstTransformStateType; 
	D3DLIGHTSTATETYPE dlstLightStateType; 
	D3DRENDERSTATETYPE drstRenderStateType; 
	}; 
	union { 
	DWORD dwArg[1]; 
	D3DVALUE dvArg[1]; 
	}; 
}	D3DSTATE, *LPD3DSTATE; 
typedef	struct _D3DMATRIXLOAD { 
	D3DMATRIXHANDLE hDestMatrix; 
	D3DMATRIXHANDLE hSrcMatrix; 
}	D3DMATRIXLOAD, *LPD3DMATRIXLOAD; 
typedef	struct _D3DMATRIXMULTIPLY { 
	D3DMATRIXHANDLE hDestMatrix; 
	D3DMATRIXHANDLE hSrcMatrix1; 
	D3DMATRIXHANDLE hSrcMatrix2; 
}	D3DMATRIXMULTIPLY, *LPD3DMATRIXMULTIPLY; 
typedef	struct _D3DPROCESSVERTICES { 
	DWORD dwFlags; 
	WORD wStart; 
	WORD wDest; 
	DWORD dwCount; 
	DWORD dwReserved; 
}	D3DPROCESSVERTICES, *LPD3DPROCESSVERTICES; 
#define	D3DPROCESSVERTICES_TRANSFORMLIGHT 0 
#define	D3DPROCESSVERTICES_TRANSFORM 1 
#define	D3DPROCESSVERTICES_COPY 2 
#define	D3DPROCESSVERTICES_OPMASK 7 
#define	D3DPROCESSVERTICES_UPDATEEXTENTS 8 
#define	D3DPROCESSVERTICES_NOCOLOR 0x10 
#define	D3DTRIFLAG_START 0 
#define	D3DTRIFLAG_STARTFLAT(len) (len) 
#define	D3DTRIFLAG_ODD 0x0000001eL 
#define	D3DTRIFLAG_EVEN 0x0000001fL 
#define	D3DTRIFLAG_EDGEENABLE1 0x100L 
#define	D3DTRIFLAG_EDGEENABLE2 0x200L 
#define	D3DTRIFLAG_EDGEENABLE3 0x400L 
#define	D3DTRIFLAG_EDGEENABLETRIANGLE (D3DTRIFLAG_EDGEENABLE1|D3DTRIFLAG_EDGEENABLE2|D3DTRIFLAG_EDGEENABLE3) 
typedef	struct _D3DTRIANGLE { 
	union { 
	WORD v1; 
	WORD wV1; 
	}; 
	union { 
	WORD v2; 
	WORD wV2; 
	}; 
	union { 
	WORD v3; 
	WORD wV3; 
	}; 
	WORD wFlags; 
}	D3DTRIANGLE, *LPD3DTRIANGLE; 
typedef	struct _D3DLINE { 
	union { 
	WORD v1; 
	WORD wV1; 
	}; 
	union { 
	WORD v2; 
	WORD wV2; 
	}; 
}	D3DLINE, *LPD3DLINE; 
	
typedef	struct _D3DSPAN { 
	WORD wCount; 
	WORD wFirst; 
}	D3DSPAN, *LPD3DSPAN; 
typedef	struct _D3DPOINT { 
	WORD wCount; 
	WORD wFirst; 
}	D3DPOINT, *LPD3DPOINT; 
typedef	struct _D3DBRANCH { 
	DWORD dwMask; 
	DWORD dwValue; 
	BOOL bNegate; 
	DWORD dwOffset; 
}	D3DBRANCH, *LPD3DBRANCH; 
typedef	struct _D3DSTATUS { 
	DWORD dwFlags; 
	DWORD dwStatus; 
	D3DRECT drExtent; 
}	D3DSTATUS, *LPD3DSTATUS; 
#define	D3DSETSTATUS_STATUS 0x00000001L 
#define	D3DSETSTATUS_EXTENTS 0x00000002L 
#define	D3DSETSTATUS_ALL (D3DSETSTATUS_STATUS | D3DSETSTATUS_EXTENTS) 
typedef	struct _D3DSTATS { 
	DWORD dwSize; 
	DWORD dwTrianglesDrawn; 
	DWORD dwLinesDrawn; 
	DWORD dwPointsDrawn; 
	DWORD dwSpansDrawn; 
	DWORD dwVerticesProcessed; 
}	D3DSTATS, *LPD3DSTATS; 
#define	D3DEXECUTE_CLIPPED 0x00000001l 
#define	D3DEXECUTE_UNCLIPPED 0x00000002l 
typedef	struct _D3DEXECUTEDATA { 
	DWORD dwSize; 
	DWORD dwVertexOffset; 
	DWORD dwVertexCount; 
	DWORD dwInstructionOffset; 
	DWORD dwInstructionLength; 
	DWORD dwHVertexOffset; 
	D3DSTATUS dsStatus; 
}	D3DEXECUTEDATA, *LPD3DEXECUTEDATA; 
#define	D3DPAL_FREE 0x00 
#define	D3DPAL_READONLY 0x40 
#define	D3DPAL_RESERVED 0x80 
#pragma	pack(pop) 
#endif
