define([
    "dojo/_base/declare",
    "dojo/on",
    "dojo/dom-style",
    "dojo/_base/lang",
    "dojo/dom-construct",
    "gbtx/widgetview/customdijit/Button",
    "gbt/widgetview/AbstractStandardComponent"
],

    function (declare, on, domStyle, lang, domConstruct, Button, AbstractStandardComponent) {
        return declare([AbstractStandardComponent], {

            constructor: function () {
                console.log("HMIB-constructor");

                var pushButton = new Button({
                    onClick: lang.hitch(this, function () {
                        //No event data needs to passed back when button is clicked
                        var eventData = {};
                        this.WidgetData.dispatchEventToServer("ButtonPushed", eventData);
                    })
                });

                this._setDijitHandle(pushButton);
            },

            /**
             * Set up the initial property values on the component
             * this will be called by AbstractDijitView after it creates the Dijit
             */
            _initializeDijitHandle: function () {
                this.inherited(arguments);

                this.setProperties(["Text", "IconURL", "IconRelationToText", "HorizontalAlignment", "VerticalAlignment"]);

            },

            /**
             * Tells the WidgetView that properties have changed
             *
             * The WidgetView should update its DOM at this time by looking at which properties changed
             *
             * @param properties is an object with fields equal to property names, and field values equal to property values.
             */

            setProperties: function (properties) {
                console.log("HMI-setprops-pre");
                this.inherited(arguments);
                console.log("HMI-setprops-post");

                properties.forEach(lang.hitch(this, function (propertyName) {
                    switch (propertyName) {
                        case "Text" :
                            this._DijitHandle.set("labelMultiLine", this.WidgetData.getProperty("Text"));
                            break;
                        case "IconURL":
                            // when the icon has changed, update the width , height as well
                            //
                            // Note that the button is not able to synchronously calculate its preferred width / height
                            // because it loads the IconURL asynchronously.
                            //
                            // To ensure that the Button always accurately reports its preferred icon size, the width /
                            // height are synchronously set here.
                            //Its important to set the IconSize before the icon, so that any observers of icon get the correct icon size
                            this._DijitHandle.set("preferredIconSize", {
                                    width: this.WidgetData.getProperty("IconWidth"),
                                    height: this.WidgetData.getProperty("IconHeight")
                                }
                            );

                            this._DijitHandle.set("icon", this.WidgetData.getProperty("IconURL"));
                            break;
                        case "IconRelationToText":
                            this._DijitHandle.set("IconRelationToText", this.WidgetData.getProperty("IconRelationToText"));
                            break;
                        case "HorizontalAlignment" :
                            this._DijitHandle.set("horizontalAlignment", this.WidgetData.getProperty("HorizontalAlignment"));
                            break;
                        case "VerticalAlignment" :
                            this._DijitHandle.set("verticalAlignment", this.WidgetData.getProperty("VerticalAlignment"));
                            break;

                        default :
                        // do nothing
                    }
                }));
            }

        });
    });


