define([
	"dojo/_base/declare",	       
	"MW/remote/MessageService",
	"MW/remote/Remote",
	"dijit/form/FilteringSelect",
	"dijit/form/NumberSpinner",
	"dijit/form/Button", 
	"dijit/form/RadioButton", 
	"dojo/dom",
	"dojo/store/Memory",
	"dojo/domReady!"
	], function (declare, MessageService, Remote, FilteringSelect, NumberSpinner, Button, RadioButton, dom, Memory) {

		return declare([], {
			constructor: function () {

				Remote.setEndpoint("/");

				Remote.setWorkerEndpoint(location.origin);
				Remote.setComputeToken({computeSessionId: "/gbt/dialogs/uisetfont"});
				MessageService.start();


				var updatePreview = function () {    
					console.log(selectedFont);
					var preview = dom.byId("preview");
					preview.style.fontFamily = selectedFont.FontName;
					preview.style.fontSize = (selectedFont.FontSize * screenDPI / 96) + "pt";	// 96 DPI is used by all browsers. 
					preview.style.fontWeight = 	selectedFont.FontWeight;
					preview.style.fontStyle = selectedFont.FontAngle;
				}

				var selectedFont = {FontName: "Arial", FontWeight: "normal", FontAngle:"normal", FontSize: 10};
				var screenDPI = 96;

				var onOK = function () {
					MessageService.publish("/gbt/dialogs/uisetfont/return", selectedFont);
				}

				var onCancel = function () {
					MessageService.publish("/gbt/dialogs/uisetfont/return", "cancel");
				}

				var init = function (initData) {
					console.log(initData.data);

					var fontData = new Array();
					var fontList = initData.data.FontList;
					for (var i = 0; i < fontList.length; i++) {
						font = {};
						font.id = i;
						font.name = fontList[i];                              
						fontData[i] = font;
					} 
					var nameStore = new Memory({data: fontData}); 
					var fname = dijit.byId('FontName');
					fname.store = nameStore;
					fname.set('displayedValue', initData.data.InitialFont.FontName);
					dijit.byId('FontSize').set('value', initData.data.InitialFont.FontSize);

					dijit.byId("FontWeight_" + initData.data.InitialFont.FontWeight).set('checked', true);
					dijit.byId("FontAngle_" + initData.data.InitialFont.FontAngle).set('checked', true);

					screenDPI = initData.data.ScreenResolution;

					updatePreview();
				}

				var radioOnChange = function (isSelected) {
					if (isSelected) {
						selectedFont[this.name] = this.value;
						updatePreview();
					}
				}

				var fontSizeOnChange = function (e) {
					selectedFont.FontSize = this.value;
					updatePreview();					
				}

				var fontNameOnChange = function (e) {
					selectedFont.FontName = this.get('displayedValue');
					updatePreview();					
				}

				var nameSelect = new FilteringSelect({
					id: "FontName",
					name: "FontName",	            	            	
					onChange: fontNameOnChange,
					searchAttr: "name",
					labelAttr: "name",
					style: "width:200px"
				}, dom.byId("FontName")); 
				

				var sizeSelect = new NumberSpinner({
					value: 10,
					smallDelta: 2,
					constraints: { min:1, max:1000, places:0 },
					onChange: fontSizeOnChange,
					intermediateChanges: true,
					style: "width:200px"
				}, dom.byId("FontSize")); 

				var fontWeightNormal = new RadioButton({
					checked: true,
					value: "normal",
					onChange: radioOnChange,
					name: "FontWeight"
				}, dom.byId("FontWeight_normal"));
				var fontWeightBold = new RadioButton({
					checked: false,
					value: "bold",
					onChange: radioOnChange,
					name: "FontWeight"
				}, dom.byId("FontWeight_bold"));

				var fontAngleNormal = new RadioButton({
					checked: true,
					value: "normal",
					onChange: radioOnChange,
					name: "FontAngle"
				}, dom.byId("FontAngle_normal"));
				var fontAngleItalic = new RadioButton({
					checked: false,
					value: "italic",
					onChange: radioOnChange,
					name: "FontAngle"
				}, dom.byId("FontAngle_italic"));
				var fontAngleOblique = new RadioButton({
					checked: false,
					value: "oblique",
					onChange: radioOnChange,
					name: "FontAngle"
				}, dom.byId("FontAngle_oblique"));

				MessageService.subscribe("/gbt/dialogs/uisetfont/initialize", init);

				var bok = new Button({label: "Ok", onClick: onOK}, dom.byId("OKButton"));
				var bcancel = new Button({label: "Cancel", onClick: onCancel}, dom.byId("CancelButton")); 


				MessageService.publish("/gbt/dialogs/uisetfont/ready", []);
			}
		});
});