/**
 * Created with IntelliJ IDEA.
 * User: kkaminen
 * Date: 3/6/14
 * Time: 11:03 AM
 * To change this template use File | Settings | File Templates.
 */

define([
    "dojo/_base/declare",
    "dojo/on",
    "dojo/_base/lang",
    "dojo/dom-construct",
    "dojo/dom-style",
    "gbt/widgetview/Container",
    "dojo/ready"
], function (declare, on, lang, domConstruct, domStyle, Container) {

    return declare([Container], {

        constructor: function () {

            // create the div which host the nested container amd place the parent div
            this._createNestedContainerDOMNode();

        },

        //set the initial properties of the Component
        _initializeDijitHandle: function () {
            this.inherited(arguments);
            this.setProperties(["Title", "BorderVisibility"]);
        },

        _setDijitHandle: function (dijitInstance) {

            // handle to the Dijit instance, such as a dijit/layout/Button
            //
            // This field should be considered protected and read-only by subclasses.
            this._DijitHandle = dijitInstance;

            // place Dijit in DOM
            domConstruct.place(this._DijitHandle.domNode, this._VCWidgetDOMNode);

            // start programmatically created Dijit
            this._DijitHandle.startup();

            this._initializeDijitHandle();

        },

        /**
         * Creates the outermost nestedContainer DOM node
         * @private
         */
        _createNestedContainerDOMNode: function () {

            // This is the wrapper Dom node (a Div tag) around the component
            this._VCWidgetDOMNode = domConstruct.create(
                // type
                "div",
                // attributes
                {
                    //id: qeId,
                    class: "vc-widget"
                },
                // parent to the target
                this.targetDomNode);

            // size the DOM node accordingly
            this._updateWidgetDOMPosition();
        },

        /*
         * Sizes the Widget DOM node based on the WidgetData's OuterSize, OuterLocation
         */
        _updateWidgetDOMPosition: function () {

            var outerLocation = this.WidgetData.getProperty("OuterLocation");
            var outerSize = this.WidgetData.getProperty("OuterSize");

            // horizontal distance in pixels from the element parent's lower left corner
            var left = outerLocation[0] + "px";

            // vertical distance in pixels from the element parent's lower left corner
            var bottom = outerLocation[1] + "px";

            // pixel width of the element
            var width = outerSize[0] + "px";

            // pixel height of the element
            var height = outerSize[1] + "px";

            var bounds = {
                left: left,
                bottom: bottom,
                width: width,
                height: height
            };

            domStyle.set(this.getVCWidgetDOMNode(), bounds);
        },

        /**
         * to update the outer-size accounting for the height of the title-text
         * @private
         */
        _handlePreferredSizeChanged: function () {
            var newOuterSize = [],
                newPositions = {},
                preferredSizeObj = this._DijitHandle.get("preferredSize");

            // At run-time, the outer-width will not be updated because we do not update the
            // inner-width (inner art) and it does not make sense for these two to be different
            newOuterSize[0] = this.WidgetData.getProperty("OuterSize")[0];
            newOuterSize[1] = preferredSizeObj.outerHeight;

            newPositions = {
                "OuterSize": newOuterSize
            };
            this.WidgetData.setProperties(newPositions);
        },

        /**
         *
         * Returns the handle on the outermost wrapping DOM of the component.
         *
         * The specific component internal DOM elements are the returned DOM elements children.
         */
        getVCWidgetDOMNode: function () {
            return this._VCWidgetDOMNode;
        },


        /**
         * Tells the WidgetView that properties have changed
         *
         * The WidgetView should update its DOM at this time by looking at which properties changed
         *
         * @param properties is an object with fields equal to property names, and field values equal to property values.
         */
        setProperties: function (properties) {
            this.inherited(arguments);

            // handles re-sizing
            if (this._arePropertyNamesPresent(properties, ["OuterLocation", "OuterSize", "Size", "Location"])) {
                this._updateWidgetDOMPosition();
            }

            properties.forEach(lang.hitch(this, function (propertyName) {
                switch (propertyName) {
                    // Sizes the Dijit's domNode : not absolutely necessary here because the WidgetView super class is doing this on the vc-widget node\
                    // But doing this is inline with the API of the custom dijit
                    case "OuterSize":
                        this._DijitHandle.set("outerWidth", this.WidgetData.getProperty("OuterSize")[0]);
                        this._DijitHandle.set("outerHeight", this.WidgetData.getProperty("OuterSize")[1]);
                        break;

                    case "Title":
                        this._DijitHandle.set("title", this.WidgetData.getProperty("Title"));
                        break;

                    case "BorderVisibility":
                        this._DijitHandle.set("isBorderVisible", this.WidgetData.getProperty("BorderVisibility"));
                        break;

                    default:
                        break;
                }
            }));
        }

    });

});

