/**
 * FigureContainer is the entry point for creating the web figure
 *
 * Figure Container inherits from UIContainer and responsible for providing access to the
 * Peer Model Manager. Responsible for creating the managers for the WidgetData and WidgetView
 * upon receiving the "RootSet" event through the Peer Model Manager
 *
 * Copyright 2014 MathWorks, Inc.
 */
define([
    'dojo/_base/declare',
    "dojo/_base/lang",
    "dojo/Deferred",
    "MW/layout/UIContainer",
    "gbt/model/WidgetDataManager",
    "gbt/widgetview/WidgetViewManager"//,
    //'xstyle/css!/toolbox/matlab/hmicomponents/web/css-appdescomp/main.css'
], function (declare, lang, Deferred, UIContainer, WidgetDataManager, WidgetViewManager) {

    return declare([UIContainer], {

        constructor: function () {

            // Error Checks
            if (!this.peerModelManager) {
                throw (new Error("peerModelManager is undefined for FigureContainer constructor"));
            }

            if (!this.borderContainer) {
                throw (new Error("borderContainer is undefined for FigureContainer constructor"));
            }

            this.peerModelManager.addEventListener("rootSet", lang.hitch(this, "_handleRootSet"));
            window.pmm = this.peerModelManager;

        },

        _handleRootSet: function (event) {

            //the target of the event is figure Node
            this.figureNode = event.target;

            //Create the WidgetDataManager
            this.widgetDataManager = new WidgetDataManager(this.figureNode);

            //Get the widgetData
            this.figureWidgetData =  this.widgetDataManager.getFigureWindowWidgetData();

            //Create the figure widget view
            this.widgetViewManager =  new WidgetViewManager(this.figureWidgetData,  this.borderContainer);
        }
    });
});
