/**
 * Created with IntelliJ IDEA.
 * User: kkaminen
 * Date: 3/6/14
 * Time: 11:03 AM
 * To change this template use File | Settings | File Templates.
 */

define([
    "dojo/_base/declare",
    "dojo/on",
    "dojo/_base/lang",
    "dijit/Destroyable",
    "dojo/ready"
], function (declare, on, lang, Destroyable) {

    return declare([Destroyable], {

        /* Create the WidgetView */
        constructor: function (widgetData, targetDomNode, qeId) {
            // Error Checks
            if (!widgetData) {
                throw "WidgetData is undefined for Container constructor";
            }

            if (!targetDomNode) {
                throw "targetDomNode is undefined for Container constructor";
            }

            if (!qeId) {
                throw "qeId undefined for Container constructor";
            }

            // Handle to a gbt/model/WidgetData
            //
            // This field should be considered protected, and read only by subclasses.
            this.WidgetData = widgetData;

            // Handle to a gbt/widgetview/NestedContainer
            //
            // This field should be considered protected, and read only by subclasses.
            this.targetDomNode =  targetDomNode;

            //Create a handler that redraws the canvas
            this.redrawHandle = lang.hitch(this, function (eventData) {
                this._DijitHandle.renderGraphics(eventData);
            });

            this.WidgetData.dispatchEventToServer('CanvasReady', { eventType: 'CanvasReady' });

            //Listeners
            this.own(
                //Add listeners to the WidgetData
                on(this.WidgetData, "propertiesSet", lang.hitch(this, "setProperties"))
            );

        },



        _setDijitHandle: function (dijitInstance) {

            // handle to the Dijit instance, such as a dijit/layout/Button
            //
            // This field should be considered protected and read-only by subclasses.
            this._DijitHandle = dijitInstance;

            // start programmatically created Dijit
            this._DijitHandle.startup();

            this._initializeDijitHandle();

        },

        _initializeDijitHandle: function () {
            this.setProperties(["Enabled", "Size"]);
        },

        /**
         * Returns a DOM node where Children can be inserted.
         */
        getContentAreaDOMNode: function () {
            // return the web figure specific container node
            return this._DijitHandle.containerNode;
        },

        /**
         * Returns the Dijit handle of the WidgetView
         */
        getDijitHandle: function () {
            return this._DijitHandle;
        },

        /**
         * Cleans up the object
         */
        destroy: function () {
            // destroy the Dijit
            // delete the Dijit Handle
            this._DijitHandle.destroy();
            delete this._DijitHandle;

            // super
            this.inherited(arguments);
        },

        /**
         * Tells the WidgetView that properties have changed
         *
         * The WidgetView should update its DOM at this time by looking at which properties changed
         *
         * @param properties is an object with fields equal to property names, and field values equal to property values.
         */
        setProperties: function (properties) {

            properties.forEach(lang.hitch(this, function (propertyName) {
                switch (propertyName) {
                    case "Enabled":
                        var isEnabled = this.WidgetData.getProperty("Enabled");
                        this._DijitHandle.set("disabled", !isEnabled);
                        break;
                    case "Size":
                        var size = this.WidgetData.getProperty("Size");
                        this._DijitHandle.set("width", size[0]);
                        this._DijitHandle.set("height", size[1]);

                        //Create a handler that redraws the canvas
                        this._DijitHandle.renderGraphics();

                        break;
                    default :
                        break;
                }
            }));
        },

        /**
         * ------------------------------------------------------------------------------------------------------
         * Protected Helper Functions
         * ------------------------------------------------------------------------------------------------------
         */

        /**
         * Helper function that returns true if ANY strings in a list of property names match ANY strings in a
         * list of other property names.
         *
         * The string comparison is case insensitive.
         *
         * @param listA a list of property names
         * @param listB a list of property names
         */
        _arePropertyNamesPresent: function (listA, listB) {

            // create an all lower case version of the list by:
            // - inserting a special character '$' in between each element and create 1 massive string
            // - turning the massive string lowercase
            // - splitting on the '$' again to reform the original elements of the array
            var lowerCasePropertyNames = listA.join("$").toLowerCase().split("$");

            // loop through each word, looking for a match
            for (var idx = 0; idx < listB.length; idx++) {

                if (lowerCasePropertyNames.indexOf(listB[idx].toLowerCase()) >= 0) {
                    return true;
                }
            }

            return false;
        }

    });
});

