% Three dimensional graphs.
% 
% Elementary 3-D plots.
%   plot3      - Plot lines and points in 3-D space.
%   mesh       - 3-D mesh surface.
%   surf       - 3-D colored surface.
%   fill3      - Filled 3-D polygons.
%  
% Color control.
%   colormap   - Color look-up table.
%   caxis      - Pseudocolor axis scaling.
%   shading    - Color shading mode.
%   hidden     - Mesh hidden line removal mode.
%   brighten   - Brighten or darken color map.
%   colordef   - Set color defaults.
%   graymon    - Set graphics defaults for gray-scale monitors.
%   cmpermute  - Rearrange colors in colormap.
%   cmunique   - Eliminate unneeded colors in colormap of indexed image.
%   imapprox   - Approximate indexed image by one with fewer colors.
%
% Lighting.
%   surfl      - 3-D shaded surface with lighting.
%   lighting   - Lighting mode.
%   material   - Material reflectance mode.
%   specular   - Specular reflectance.
%   diffuse    - Diffuse reflectance.
%   surfnorm   - Surface normals.
%
% Color maps.
%   parula     - Blue-green-orange-yellow color map
%   hsv        - Hue-saturation-value color map.
%   hot        - Black-red-yellow-white color map.
%   gray       - Linear gray-scale color map.
%   bone       - Gray-scale with tinge of blue color map.
%   copper     - Linear copper-tone color map.
%   pink       - Pastel shades of pink color map.
%   white      - All white color map.
%   flag       - Alternating red, white, blue, and black color map.
%   lines      - Color map with the line colors.
%   colorcube  - Enhanced color-cube color map.
%   vga        - Windows colormap for 16 colors.
%   jet        - Variant of HSV.
%   prism      - Prism color map.
%   cool       - Shades of cyan and magenta color map.
%   autumn     - Shades of red and yellow color map.
%   spring     - Shades of magenta and yellow color map.
%   winter     - Shades of blue and green color map.
%   summer     - Shades of green and yellow color map.
%
% Transparency.
%   alpha      - Transparency (alpha) mode.
%   alphamap   - Transparency (alpha) look-up table.
%   alim       - Transparency (alpha) scaling
%
% Axis control.
%   axis       - Control axis scaling and appearance.
%   zoom       - Zoom in and out on a 2-D plot.
%   grid       - Grid lines.
%   box        - Axis box.
%   hold       - Hold current graph.
%   axes       - Create axes in arbitrary positions.
%   subplot    - Create axes in tiled positions.
%   daspect    - Data aspect ratio.
%   pbaspect   - Plot box aspect ratio.
%   xlim       - X limits.
%   ylim       - Y limits.
%   zlim       - Z limits.
%
% Viewpoint control.
%   view       - 3-D graph viewpoint specification.
%   viewmtx    - View transformation matrix.
%   rotate3d   - Interactively rotate view of 3-D plot.
%
% Camera control.
%   campos     - Camera position.
%   camtarget  - Camera target.
%   camva      - Camera view angle.
%   camup      - Camera up vector.
%   camproj    - Camera projection.
%
% High level camera control.
%   camorbit   - Orbit camera.
%   campan     - Pan camera.
%   camdolly   - Dolly camera.
%   camzoom    - Zoom camera.
%   camroll    - Roll camera.
%   camlookat  - Move camera and target to view specified objects.
%   cameratoolbar - Interactively manipulate camera.
%
% High level light control.
%   camlight   - Creates or sets position of a light.
%   lightangle - Spherical position of a light.
%
% Graph annotation.
%   title      - Graph title.
%   xlabel     - X-axis label.
%   ylabel     - Y-axis label.
%   zlabel     - Z-axis label.
%   text       - Text annotation.
%   gtext      - Mouse placement of text.
%   plotedit   - Experimental graph editing and annotation tools.
%
% Hardcopy and printing.
%   print      - Print graph or Simulink system; or save graph to MATLAB file.
%   printopt   - Printer defaults.
%   orient     - Set paper orientation. 
%
% See also GRAPH2D, SPECGRAPH.

% Utilities
%   camrotate  - Camera rotation utility function.
%   objbounds  - 3D object limits.
%   whitebg    - Change axes backgroundcolor.

%   Copyright 1984-2014 The MathWorks, Inc.
