// Copyright 2014 MathWorks, Inc.

define(["require"],function () {

    function getDateSortResult(r, l) {
        if (!isFinite(r - l))
            return !isFinite(r) ? 1 : -1;
        else
            return l - r;
    }

    function getStringSortResult(r, l) {
        var a = String(r.toLowerCase());
        var b = String(l.toLowerCase());
        var result = a.localeCompare(b);

        if (a == "" || b == "") {
            result *= -1; //to ensure empty strings are at the bottom. Reverses the default sort.
        }
        return result;
    }

    return {
        sortByAddonName: function (a, b) {
            return getStringSortResult(a.name, b.name);
        },

        sortByAddonAuthor: function (a, b) {
            return getStringSortResult(a.authorName, b.authorName);
        },

        sortByAddonType: function (a, b) {
            return getStringSortResult(a.addOnType, b.addOnType);
        },

        sortByInstalledDate: function (a, b) {
            var r = new Date(a.installedDate).getTime();
            var l = new Date(b.installedDate).getTime();
            return getDateSortResult(r, l);
        },

        sortByIsSupportedByMathworks: function (a, b) {
            return a.isMathworksSupported < b.isMathworksSupported;
        }
    }
});