// Copyright 2014 MathWorks, Inc.
define([
    "dojo/_base/declare",
    "dojo/dom",
    "dojo/on",
    "dojo/_base/lang",
    "addons/AddonsManager/ManagerToMatlabMessages",
    "dojo/domReady!"
], function (declare, dom, on, lang, ManagerToMatlabMessages) {

    var msHelper;
    return declare([], {
        constructor: function (messageServiceHelper) {
            msHelper = messageServiceHelper;
        },
        initializeButtons: function() {
            var btnGetMore = dom.byId("getMore");
            var btnPackageToolbox = dom.byId("packageToolbox");
            var btnPackageApp = dom.byId("packageApp");
            on(btnGetMore, "click", lang.hitch(this, "_sendOpenGetAddonsMessage"));
            on(btnPackageToolbox, "click", lang.hitch(this, "_sendPackageToolboxMessage"));
            on(btnPackageApp, "click", lang.hitch(this, "_sendPackageAppMessage"));
        },
        _sendOpenGetAddonsMessage: function() {
            var getMoreMatlabMessage = {
                type: ManagerToMatlabMessages.OPEN_GET_ADDONS
            };
            msHelper.publish(getMoreMatlabMessage);
        },
        _sendPackageToolboxMessage: function() {
            var packageToolboxMessage = {
                type: ManagerToMatlabMessages.PACKAGE_TOOLBOX
            };
            msHelper.publish(packageToolboxMessage);
        },
        _sendPackageAppMessage: function() {
            var packageAppMessage = {
                type: ManagerToMatlabMessages.PACKAGE_APP
            };
            msHelper.publish(packageAppMessage);
        }
    });
});
