// Copyright 2014 MathWorks, Inc.
define([
    "dojo/_base/declare",
    "dojo/dom",
    "dojo/dom-style",
    "addons/util/MessageServiceHelper",
    "addons/AddonsManager/ManagerRenderAddons",
    "addons/AddonsManager/ManagerSort",
    "addons/AddonsManager/ManagerSortWidget",
    "addons/AddonsManager/ManagerDetailWidget",
    "dojo/i18n!l10n-addons/nls/addonsManager",
    "addons/AddonsManager/ManagerButtonEventHandler",
    "dojo/domReady!"
], function (declare, dom, domStyle, MSHelper, ManagerRenderAddons, ManagerSort, ManagerSortWidget, ManagerDetailWidget, addonsManagerResourceBundle, ManagerButtonEventHandler) {
    var msHelper;
    var installedAddonsData = [];
    var data;
    var that;
    var managerButtonEventHandler;
    return declare([], {
        constructor: function (args) {
            that = this;
            data = args || {};
            var msHelperArgs = {
                channelId: data.channelId,
                callback: this._matlabMessageHandler
            };
            msHelper = new MSHelper(msHelperArgs);
            managerButtonEventHandler = ManagerButtonEventHandler(msHelper);
            managerButtonEventHandler.initializeButtons();
        },

        _getInstalledAddonDataFor: function(guid, installedAddonsData){
            for(var x in installedAddonsData) {
                if(installedAddonsData[x].identifier === guid) {
                   return installedAddonsData[x];
                }
            }
        },

        _renderManagerIndexPage: function(installedAddonsData){

            ManagerRenderAddons.sortAndDisplay(installedAddonsData, ManagerSort.sortByInstalledDate);
            ManagerSortWidget.enableSorting(installedAddonsData);
        },

        _renderManagerDetailPage: function(guid, installedAddonsData){
            var headerButtonsNode =  dom.byId("headerButtons");
            var addonsManagerMenuNode = dom.byId("addonsManagerMenu");

            dom.byId("installedAddonsContainer").innerHTML = "";
            headerButtonsNode.innerHTML = "<div class='headerButton' id='home' role='button' onclick='window.location.href=\"" + this._goToManageAddonsPage(data.channelId) + "\"'><span data-dojo-attach-point='homeButtonLabel' class='homeButtonLabel'></span></div>";
            dom.byId("home").getElementsByClassName("homeButtonLabel")[0].innerHTML = addonsManagerResourceBundle.homeButtonLabel;
            addonsManagerMenuNode.innerHTML = "";

            var installedAddonDetailContainer = dom.byId("installedAddonDetailContainer");
            installedAddonDetailContainer.innerHTML = ""
            new ManagerDetailWidget(that._getInstalledAddonDataFor(guid, installedAddonsData)).placeAt(installedAddonDetailContainer);

            domStyle.set(headerButtonsNode, "display", "block");
            domStyle.set(addonsManagerMenuNode, "display", "block");
        },

        _matlabMessageHandler: function (message) {
            var headerButtonsNode =  dom.byId("headerButtons");
            var addonsManagerMenuNode = dom.byId("addonsManagerMenu");
            var noInstalledAddonsNode = dom.byId("noInstalledAddons")

            installedAddonsData = message.data.body;

            if (data.identifier) {
                if(that._getInstalledAddonDataFor(data.identifier, installedAddonsData)) {
                    that._renderManagerDetailPage(data.identifier, installedAddonsData);
                }
                else {
                    window.location.href = that._goToManageAddonsPage(data.channelId);
                }
            }
            else{
                that._renderManagerIndexPage(installedAddonsData);
            }

            if(installedAddonsData.length===0){
                domStyle.set(noInstalledAddonsNode, "display", "block");
                noInstalledAddonsNode.getElementsByClassName("noInstalledAddonsMessage")[0].innerHTML = addonsManagerResourceBundle.noInstalledAddonsMessage;
            }
        },

        getInstalledAddonsData: function () {
            return installedAddonsData;
        },

        publishMessage: function (message) {
            msHelper.publish(message);
        },

        _goToManageAddonsPage: function(channelId) {
            return window.location.protocol + "//" + window.location.host + window.location.pathname + "?channelId=" + channelId;
        }
    });

});