/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.hdfs.unittest;

import com.mathworks.storage.hdfs.HDFSProviderChannel;
import com.mathworks.storage.hdfs.HadoopProviderImpl;
import com.mathworks.storage.provider.FileAttributes;
import com.mathworks.storage.provider.FolderAttributes;
import com.mathworks.storage.provider.FolderListEntry;
import com.mathworks.storage.provider.Provider;
import com.mathworks.storage.provider.ProviderChannel;
import com.mathworks.storage.provider.StorageURI;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.LogManager;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class HDFSProviderStandaloneTest {
    private Path testHomeDirectory;
    private Provider hdfsProvider;

    @BeforeClass
    public static void turnOffConsoleHandler() throws Exception {
        ByteArrayInputStream testConfig = new ByteArrayInputStream("java.util.logging.ConsoleHandler.level = OFF".getBytes());
        LogManager.getLogManager().readConfiguration(testConfig);
    }

    @AfterClass
    public static void resetLogConfiguration() throws Exception {
        LogManager.getLogManager().readConfiguration();
    }

    public static void deleteDirectory(File path) {
        if (path == null) {
            return;
        }
        if (path.exists()) {
            for (File f : path.listFiles()) {
                if (f.isDirectory()) {
                    HDFSProviderStandaloneTest.deleteDirectory(f);
                    f.delete();
                    continue;
                }
                f.delete();
            }
            path.delete();
        }
    }

    @Before
    public void init() {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Linux"));
        try {
            this.testHomeDirectory = Paths.get(HDFSProviderStandaloneTest.GetTestHomeDirectory(), new String[0]);
            System.out.println("Test Home Directory:" + this.testHomeDirectory.toString());
            if (!Files.exists(this.testHomeDirectory, new LinkOption[0])) {
                Files.createDirectory(this.testHomeDirectory, new FileAttribute[0]);
            } else {
                HDFSProviderStandaloneTest.deleteDirectory(new File(this.testHomeDirectory.toString()));
                Files.createDirectory(this.testHomeDirectory, new FileAttribute[0]);
            }
            this.hdfsProvider = new FileProvider();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @After
    public void cleanup() {
        try {
            if (this.testHomeDirectory != null) {
                HDFSProviderStandaloneTest.deleteDirectory(new File(this.testHomeDirectory.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testFileExists() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test file exits");
        StorageURI uri = HDFSProviderStandaloneTest.aFileURI();
        boolean ret = this.hdfsProvider.fileExists(uri);
        System.out.println("File exists before create?" + ret);
        this.hdfsProvider.createFile(uri);
        System.out.println("File exists after create?" + this.hdfsProvider.fileExists(uri));
        System.out.println("**************************************");
    }

    @Test
    public void testCreateFolder() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test create folder");
        StorageURI afolder = HDFSProviderStandaloneTest.aFolderURI();
        System.out.println("Create folder:" + afolder.toString());
        System.out.println("Before Create folder, folder exists?" + this.hdfsProvider.folderExists(afolder));
        this.hdfsProvider.createFolder(afolder);
        System.out.println("After Create folder, folder exists?" + this.hdfsProvider.folderExists(afolder));
        System.out.println("**************************************");
    }

    @Test
    public void testCreateFile() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test create file");
        StorageURI afile = HDFSProviderStandaloneTest.aFileURI();
        System.out.println("Create file:" + afile.toString());
        System.out.println("Before Create file, file exists?" + this.hdfsProvider.fileExists(afile));
        this.hdfsProvider.createFile(afile);
        System.out.println("After Create file, file exists?" + this.hdfsProvider.fileExists(afile));
        System.out.println("**************************************");
    }

    @Test
    public void testRemoveFile() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test remove file");
        StorageURI afile = HDFSProviderStandaloneTest.aFileURI();
        System.out.println("Remove file:" + afile.toString());
        System.out.println("Before remove file, file exists?" + this.hdfsProvider.fileExists(afile));
        if (!this.hdfsProvider.fileExists(afile)) {
            this.hdfsProvider.createFile(afile);
            System.out.println("After create file, file exists?" + this.hdfsProvider.fileExists(afile));
        }
        this.hdfsProvider.removeFile(afile);
        System.out.println("After remove file, file exists?" + this.hdfsProvider.fileExists(afile));
        System.out.println("**************************************");
    }

    @Test
    public void testRemoveFolder() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test remove folder");
        StorageURI afolder = HDFSProviderStandaloneTest.aFolderURI();
        System.out.println("Remove folder:" + afolder.toString());
        System.out.println("Before remove folder, folder exists?" + this.hdfsProvider.folderExists(afolder));
        if (!this.hdfsProvider.folderExists(afolder)) {
            this.hdfsProvider.createFolder(afolder);
            System.out.println("After create folder, folder exists?" + this.hdfsProvider.folderExists(afolder));
        }
        this.hdfsProvider.removeFolder(afolder);
        System.out.println("After remove folder, folder exists?" + this.hdfsProvider.folderExists(afolder));
        System.out.println("**************************************");
    }

    @Test
    public void testMoveFile() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test move file");
        StorageURI srcfile = HDFSProviderStandaloneTest.aFileURI();
        if (!this.hdfsProvider.fileExists(srcfile)) {
            this.hdfsProvider.createFile(srcfile);
        }
        StorageURI destfile = HDFSProviderStandaloneTest.aDestFileURI();
        System.out.println("Before move, src exists?" + this.hdfsProvider.fileExists(srcfile) + ", dest exists?" + this.hdfsProvider.fileExists(destfile));
        this.hdfsProvider.moveFile(srcfile, destfile, false);
        System.out.println("After move, src exists?" + this.hdfsProvider.fileExists(srcfile) + ", dest exists?" + this.hdfsProvider.fileExists(destfile));
        System.out.println("**************************************");
    }

    @Test
    public void testMoveFolder() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test move folder");
        StorageURI srcfolder = HDFSProviderStandaloneTest.aFolderURI();
        if (!this.hdfsProvider.folderExists(srcfolder)) {
            this.hdfsProvider.createFolder(srcfolder);
        }
        StorageURI destfolder = HDFSProviderStandaloneTest.aDestFolderURI();
        System.out.println("Before move, src exists?" + this.hdfsProvider.folderExists(srcfolder) + ", dest exists?" + this.hdfsProvider.folderExists(destfolder));
        this.hdfsProvider.moveFolder(srcfolder, destfolder, false);
        System.out.println("Before move, src exists?" + this.hdfsProvider.folderExists(srcfolder) + ", dest exists?" + this.hdfsProvider.folderExists(destfolder));
        System.out.println("**************************************");
    }

    @Test
    public void testGetFileAttributes() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test get file attributes");
        StorageURI srcfile = HDFSProviderStandaloneTest.aFileURI();
        if (!this.hdfsProvider.fileExists(srcfile)) {
            this.hdfsProvider.createFile(srcfile);
        }
        FileAttributes attr = this.hdfsProvider.getFileAttributes(srcfile);
        System.out.println(attr.toString());
        System.out.println("**************************************");
    }

    @Test
    public void testGetFolderAttributes() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test get folder attributes");
        StorageURI srcfolder = HDFSProviderStandaloneTest.aFolderURI();
        if (!this.hdfsProvider.folderExists(srcfolder)) {
            this.hdfsProvider.createFolder(srcfolder);
        }
        FolderAttributes attr = this.hdfsProvider.getFolderAttributes(srcfolder);
        System.out.println(attr.toString());
        System.out.println("**************************************");
    }

    @Test
    public void testGetReadOnlyChannel() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test get read only channel");
        StorageURI srcfile = HDFSProviderStandaloneTest.aFileURI();
        if (!this.hdfsProvider.fileExists(srcfile)) {
            this.hdfsProvider.createFile(srcfile);
        }
        System.out.println("**************************************");
    }

    @Test
    public void testGetChannel() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test get channel");
        StorageURI srcfile = HDFSProviderStandaloneTest.aFileURI();
        ProviderChannel filechannel = this.hdfsProvider.getChannel(srcfile, true, true, false);
        ByteBuffer content = ByteBuffer.allocate(500);
        CharBuffer cbuf = content.asCharBuffer();
        for (int i = 0; i < 9; ++i) {
            cbuf.put("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        }
        cbuf.flip();
        filechannel.write(content);
        filechannel.close();
        FileAttributes attr = this.hdfsProvider.getFileAttributes(srcfile);
        System.out.println(attr.toString());
        System.out.println("File exists?" + this.hdfsProvider.fileExists(srcfile));
        ProviderChannel inputchannel = this.hdfsProvider.getReadOnlyChannel(srcfile);
        System.out.println("Current position:" + inputchannel.position() + ",size=" + inputchannel.size());
        ByteBuffer buf = ByteBuffer.allocate(100);
        int count = inputchannel.read(buf);
        while (count > 0) {
            System.out.println("Read count:" + count);
            System.out.println("Content: " + new String(buf.array(), "ASCII"));
            System.out.println("Current position:" + inputchannel.position());
            buf.clear();
            count = inputchannel.read(buf);
        }
        inputchannel.close();
        System.out.println("**************************************");
    }

    @Test
    public void testFolderListEntry() throws Exception {
        System.out.println("**************************************");
        System.out.println("Test list folder entries");
        StorageURI afile = HDFSProviderStandaloneTest.storageURIWithPath("/folderA/folderB/fileA.txt");
        StorageURI bfile = HDFSProviderStandaloneTest.storageURIWithPath("/folderA/folderB/fileB.txt");
        StorageURI cfile = HDFSProviderStandaloneTest.storageURIWithPath("/folderA/fileC.txt");
        this.hdfsProvider.createFile(afile);
        this.hdfsProvider.createFile(bfile);
        this.hdfsProvider.createFile(cfile);
        FolderListEntry[] entries = this.hdfsProvider.listFolder(HDFSProviderStandaloneTest.aFolderURI());
        for (int i = 0; i < entries.length; ++i) {
            System.out.println("<" + i + ">." + entries[i].toString());
        }
        FolderListEntry[] entries2 = this.hdfsProvider.listFolder(HDFSProviderStandaloneTest.storageURIWithPath("/folderA"));
        for (int i = 0; i < entries2.length; ++i) {
            System.out.println("<" + i + ">." + entries2[i].toString());
        }
        System.out.println("**************************************");
    }

    private static String GetTestHomeDirectory() {
        return "/tmp/temp_standalone_hdfsprovider_unittest";
    }

    private static StorageURI aFileURI() throws URISyntaxException {
        return HDFSProviderStandaloneTest.storageURIWithPath("/folderA/folderB/file.txt");
    }

    private static StorageURI aDestFileURI() throws URISyntaxException {
        return HDFSProviderStandaloneTest.storageURIWithPath("/folderA/dest_file.txt");
    }

    private static StorageURI aFolderURI() throws URISyntaxException {
        return HDFSProviderStandaloneTest.storageURIWithPath("/folderA/folderB");
    }

    private static StorageURI aDestFolderURI() throws URISyntaxException {
        return HDFSProviderStandaloneTest.storageURIWithPath("/folderC");
    }

    private static StorageURI theRootURI() throws URISyntaxException {
        return HDFSProviderStandaloneTest.storageURIWithPath("/");
    }

    private static StorageURI storageURIWithPath(String path) throws URISyntaxException {
        return new StorageURI("file://" + HDFSProviderStandaloneTest.GetTestHomeDirectory() + path);
    }

    private final class FileProvider
    extends HadoopProviderImpl {
        private static final String SCHEME = "file";

        public FileProvider() throws Exception {
            super(SCHEME);
        }

        @Override
        public ProviderChannel getReadOnlyChannel(FSDataInputStream strm, FileStatus stat, StorageURI uri) throws Exception {
            return HDFSProviderChannel.openReadOnly(strm, stat, uri);
        }

        @Override
        public ProviderChannel getWritableChannel(FSDataOutputStream strm, FileStatus stat, StorageURI uri) throws Exception {
            return HDFSProviderChannel.openForWrite(strm, stat, uri);
        }
    }
}

