/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.hdfs;

import com.mathworks.storage.provider.ProviderChannel;
import com.mathworks.storage.provider.ProviderErrorCode;
import com.mathworks.storage.provider.ProviderException;
import com.mathworks.storage.provider.StorageURI;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;

public final class HFTPProviderChannel
implements ProviderChannel {
    private FSDataInputStream inputstream_;
    private FileStatus metadata_;
    private StorageURI location_;

    public static HFTPProviderChannel openReadOnly(FSDataInputStream fis, FileStatus fileMetadata, StorageURI uri) throws ProviderException {
        return new HFTPProviderChannel(fis, fileMetadata, uri);
    }

    public static ProviderChannel openForWrite(FSDataOutputStream fos, FileStatus fileMetadata, StorageURI uri) throws ProviderException {
        throw new ProviderException(ProviderErrorCode.IOError, uri);
    }

    private HFTPProviderChannel(FSDataInputStream fis, FileStatus fileMetadata, StorageURI uri) {
        this.inputstream_ = fis;
        this.metadata_ = fileMetadata;
        this.location_ = uri;
    }

    public int read(ByteBuffer dst) throws ProviderException {
        try {
            boolean hasArray = dst.hasArray();
            int capacity = dst.capacity();
            byte[] buffer = hasArray ? dst.array() : new byte[capacity];
            int retval = this.inputstream_.read(buffer);
            if (!hasArray) {
                dst.put(buffer);
            }
            return retval;
        }
        catch (Exception e) {
            System.err.println("Error reading HFTP stream: " + e.getLocalizedMessage());
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, this.location_);
        }
    }

    public int write(ByteBuffer src) throws ProviderException {
        throw new ProviderException(ProviderErrorCode.IOError, this.location_);
    }

    public long position() throws ProviderException {
        throw new ProviderException(ProviderErrorCode.IOError, this.location_);
    }

    public void position(long newPosition) throws ProviderException {
        throw new ProviderException(ProviderErrorCode.IOError, this.location_);
    }

    public long size() throws ProviderException {
        return this.metadata_.getLen();
    }

    public void close() throws ProviderException {
        try {
            if (this.inputstream_ != null) {
                this.inputstream_.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error closing HFTP stream: " + e.getLocalizedMessage());
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, this.location_);
        }
    }
}

