/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices.webproxy;

import com.mathworks.mlwebservices.webproxy.CredentialsProviderAdapter;
import com.mathworks.webproxy.PropertiesProxyConfiguration;
import com.mathworks.webproxy.ProxyConfigurationVisitor;
import com.mathworks.webproxy.SystemProxyConfiguration;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import org.apache.axis2.client.Options;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.params.HttpClientParams;

final class AxisProxyConfigurationVisitor
implements ProxyConfigurationVisitor {
    private final Options options;
    private final URL url;

    AxisProxyConfigurationVisitor(Options options, URL uRL) {
        this.options = options;
        this.url = uRL;
    }

    public void visit(PropertiesProxyConfiguration propertiesProxyConfiguration) {
        Proxy proxy = propertiesProxyConfiguration.findProxyForURL(this.url);
        if (AxisProxyConfigurationVisitor.isProxy(proxy)) {
            HttpTransportProperties.ProxyProperties proxyProperties = AxisProxyConfigurationVisitor.createProxyProperties();
            AxisProxyConfigurationVisitor.configurePropertiesWithProxy(proxyProperties, proxy);
            AxisProxyConfigurationVisitor.configurePropertiesWithCredentials(proxyProperties, propertiesProxyConfiguration.getPasswordAuthentication());
            this.configureOptionsWithProxyProperties(proxyProperties);
            HttpClientParams httpClientParams = AxisProxyConfigurationVisitor.createHttpClientParams();
            this.configureOptionsWithHttpClient(httpClientParams);
        }
    }

    public void visit(SystemProxyConfiguration systemProxyConfiguration) {
        Proxy proxy = systemProxyConfiguration.findProxyForURL(this.url);
        if (AxisProxyConfigurationVisitor.isProxy(proxy)) {
            HttpTransportProperties.ProxyProperties proxyProperties = AxisProxyConfigurationVisitor.createProxyProperties();
            AxisProxyConfigurationVisitor.configurePropertiesWithProxy(proxyProperties, proxy);
            this.configureOptionsWithProxyProperties(proxyProperties);
            HttpClientParams httpClientParams = AxisProxyConfigurationVisitor.createHttpClientParams();
            this.configureHttpClientParamsWithCredentials(httpClientParams);
            this.configureOptionsWithHttpClient(httpClientParams);
        }
    }

    private void configureHttpClientParamsWithCredentials(HttpClientParams httpClientParams) {
        httpClientParams.setParameter("http.authentication.credential-provider", (Object)new CredentialsProviderAdapter(this.url));
    }

    private static HttpClientParams createHttpClientParams() {
        return new MyHttpClientParams();
    }

    private void configureOptionsWithHttpClient(HttpClientParams httpClientParams) {
        HttpClient httpClient = new HttpClient(httpClientParams);
        this.options.setProperty("REUSE_HTTP_CLIENT", (Object)Boolean.TRUE);
        this.options.setProperty("CACHED_HTTP_CLIENT", (Object)httpClient);
    }

    private static boolean isProxy(Proxy proxy) {
        return !proxy.equals(Proxy.NO_PROXY);
    }

    private static HttpTransportProperties.ProxyProperties createProxyProperties() {
        return new HttpTransportProperties.ProxyProperties();
    }

    private static void configurePropertiesWithProxy(HttpTransportProperties.ProxyProperties proxyProperties, Proxy proxy) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
        proxyProperties.setProxyName(inetSocketAddress.getHostName());
        proxyProperties.setProxyPort(inetSocketAddress.getPort());
    }

    private void configureOptionsWithProxyProperties(HttpTransportProperties.ProxyProperties proxyProperties) {
        this.options.setProperty("PROXY", (Object)proxyProperties);
    }

    private static void configurePropertiesWithCredentials(HttpTransportProperties.ProxyProperties proxyProperties, PasswordAuthentication passwordAuthentication) {
        String[] stringArray;
        String string = passwordAuthentication.getUserName();
        String string2 = String.valueOf(passwordAuthentication.getPassword());
        String string3 = null;
        if (string != null && (stringArray = string.split("\\\\")).length == 2) {
            string3 = stringArray[0];
            string = stringArray[1];
        }
        proxyProperties.setUserName(string);
        proxyProperties.setPassWord(string2);
        if (string3 != null) {
            proxyProperties.setDomain(string3);
        }
    }

    private static class MyHttpClientParams
    extends HttpClientParams {
        private MyHttpClientParams() {
        }

        public boolean isAuthenticationPreemptive() {
            return false;
        }
    }
}

