/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices;

import com.mathworks.mlwebservices.BaseOptionsConfigurator;
import com.mathworks.mlwebservices.Service;
import com.mathworks.mlwebservices.webproxy.ProxyOptionsConfigurator;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.SystemProxySettings;
import com.mathworks.webproxy.WebproxyFactory;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.Stub;

public abstract class DefaultService
implements Service {
    private String track;
    private String protocol;
    private String endpointURL;
    private int timeOut = 20000;
    private final ProxyConfiguration proxyConfiguration;

    public DefaultService() {
        this(WebproxyFactory.createDefaultProxyConfiguration((SystemProxySettings)WebproxyFactory.createSystemProxySettings()));
    }

    public DefaultService(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    public static void setAxisLoggingProperties() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.axis2.transport.http", "off");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "off");
    }

    protected long getBindTimeout() {
        return this.timeOut;
    }

    @Override
    public void setBindTimeout(int n) {
        if (n > 20000) {
            this.timeOut = n;
        }
    }

    @Override
    public void setTrack(String string) {
        this.track = string;
    }

    @Override
    public void setProtocol(String string) {
        this.protocol = string;
    }

    @Override
    public String getEndpointURL() {
        String string;
        if (this.endpointURL == null) {
            String string2 = this.getDefaultEndpointURL();
            string = this.setTrackAndProtocolOnURL(string2);
        } else {
            string = this.endpointURL;
        }
        return string;
    }

    public abstract String getDefaultEndpointURL();

    @Override
    public void setEndpointURL(String string) {
        this.endpointURL = string;
    }

    private String setTrackAndProtocolOnURL(String string) {
        String string2;
        String string3 = string;
        if (this.track != null) {
            string2 = "$1" + this.track + "$2";
            string3 = string3.replaceAll("^(\\w+://)[^.]+(.mathworks.com/.*)$", string2);
        }
        if (this.protocol != null) {
            string2 = this.protocol + "$1";
            string3 = string3.replaceAll("^\\w+(://[^.]+.mathworks.com/.*)$", string2);
        }
        return string3;
    }

    protected void configureOptions(Stub stub) {
        Options options = stub._getServiceClient().getOptions();
        String string = this.getEndpointURL();
        new BaseOptionsConfigurator(string, this.timeOut).configureOptions(options);
        new ProxyOptionsConfigurator(this.proxyConfiguration, string).configureOptions(options);
    }

    static {
        DefaultService.setAxisLoggingProperties();
    }
}

