/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.fixedpoint;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.fixedpoint.FiPanel;
import com.mathworks.toolbox.fixedpoint.FimathPanel;
import com.mathworks.toolbox.fixedpoint.FixedPointFunctionAbstractPanel;
import com.mathworks.toolbox.fixedpoint.FixedPointFunctionDialog;
import com.mathworks.toolbox.fixedpoint.FixedPointFunctionInterface;
import com.mathworks.toolbox.fixedpoint.FixedPointMenuContributor;
import com.mathworks.toolbox.fixedpoint.NumericTypePanel;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class FixedPointMenuAction
extends MJAbstractAction {
    private FixedPointFunctionDialog fDialog;
    private final Editor fEditor;
    static final ResourceBundle BUNDLE = ResourceBundle.getBundle(FixedPointMenuContributor.class.getPackage().getName() + ".resources.RES_fixedpoint");

    private FixedPointMenuAction(Editor editor, String string) {
        super(MessageFormat.format(BUNDLE.getString("insertConstructor"), string));
        this.fEditor = editor;
    }

    protected abstract FixedPointFunctionAbstractPanel createPanel();

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fDialog == null) {
            this.fDialog = new FixedPointFunctionDialog(this.createPanel(), this.fEditor.getComponent());
        }
        this.insertConstructor(this.fDialog);
    }

    void dispose() {
        if (this.fDialog != null) {
            this.fDialog.dispose();
            this.fDialog = null;
        }
    }

    private void insertConstructor(FixedPointFunctionDialog fixedPointFunctionDialog) {
        fixedPointFunctionDialog.initialize(new FixedPointFunctionInterface(){

            @Override
            public void onOK(String string) {
                FixedPointMenuAction.this.fEditor.insertAndFormatTextAtCaret(string);
            }

            @Override
            public void onUpdate() {
            }
        });
        fixedPointFunctionDialog.show();
    }

    public static FixedPointMenuAction createFiConstructorAction(Editor editor) {
        return new FixedPointMenuAction(editor, "&fi"){

            @Override
            protected FixedPointFunctionAbstractPanel createPanel() {
                return new FiPanel();
            }
        };
    }

    public static FixedPointMenuAction createFiMathConstructorAction(Editor editor) {
        return new FixedPointMenuAction(editor, "fi&math"){

            @Override
            protected FixedPointFunctionAbstractPanel createPanel() {
                return new FimathPanel();
            }
        };
    }

    public static FixedPointMenuAction createNumericTypeConstructorAction(Editor editor) {
        return new FixedPointMenuAction(editor, "&numerictype"){

            @Override
            protected FixedPointFunctionAbstractPanel createPanel() {
                return new NumericTypePanel(NumericTypePanel.ParamValueMode.CONDENSED, false);
            }
        };
    }
}

