/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.rmi;

import com.intel.bluetooth.rmi.RemoteService;
import com.intel.bluetooth.rmi.RemoteServiceImpl;
import com.intel.bluetooth.rmi.Server;
import com.intel.bluetooth.rmi.ServiceRequest;
import com.intel.bluetooth.rmi.ServiceResponse;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    private static final String rmiRegistryHostDefault = "localhost";
    private static final int rmiRegistryPortDefault = 8090;
    private static RemoteService remoteService;

    private static String getRemoteExceptionMessage(RemoteException e) {
        String message = e.getMessage();
        int idx = message.indexOf("; nested exception is:");
        if (idx != -1) {
            return message.substring(0, idx);
        }
        return message;
    }

    public static synchronized Object getService(Class<?> interfaceClass, boolean isMaster, String host, String port) throws RuntimeException {
        if (remoteService == null) {
            try {
                if (isMaster) {
                    if (host != null && !rmiRegistryHostDefault.equals(host)) {
                        throw new IllegalArgumentException("Can't start RMI registry while connecting to remote host " + host);
                    }
                    Server.start(port);
                }
                remoteService = Client.getRemoteService(host, port);
                remoteService.verify(interfaceClass.getCanonicalName());
            }
            catch (RemoteException e) {
                Throwable t = e.getCause() != null ? e.getCause() : e;
                throw new RuntimeException(Client.getRemoteExceptionMessage(e), t);
            }
            catch (NotBoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Class[] allInterfaces = new Class[interfaceClass.getInterfaces().length + 1];
        allInterfaces[0] = interfaceClass;
        System.arraycopy(interfaceClass.getInterfaces(), 0, allInterfaces, 1, interfaceClass.getInterfaces().length);
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), allInterfaces, (InvocationHandler)new ServiceProxy());
    }

    private static ServiceResponse execute(ServiceRequest request, Method method) throws RuntimeException {
        try {
            return remoteService.execute(request);
        }
        catch (RemoteException e) {
            Throwable t = e.getCause() != null ? e.getCause() : e;
            throw new RuntimeException(Client.getRemoteExceptionMessage(e), t);
        }
    }

    private static RemoteService getRemoteService(String host, String port) throws RemoteException, NotBoundException {
        String rmiHost = rmiRegistryHostDefault;
        if (host != null && host.length() > 0) {
            rmiHost = host;
        }
        int rmiPort = 8090;
        if (port != null && port.length() > 0) {
            rmiPort = Integer.parseInt(port);
        }
        if (rmiPort == 0) {
            return new RemoteServiceImpl();
        }
        Registry registry = LocateRegistry.getRegistry(rmiHost, rmiPort);
        return (RemoteService)registry.lookup("BlueCoveRMIService");
    }

    private static class ServiceProxy
    implements InvocationHandler {
        private AccessControlContext accessControlContext = AccessController.getContext();

        private ServiceProxy() {
        }

        public Object invoke(Object proxy, final Method m, Object[] args) throws Throwable {
            int i;
            ServiceResponse response;
            final ServiceRequest request = new ServiceRequest(m.getDeclaringClass().getCanonicalName(), m.getName(), m.getParameterTypes(), args);
            try {
                response = AccessController.doPrivileged(new PrivilegedExceptionAction<ServiceResponse>(){

                    @Override
                    public ServiceResponse run() throws RuntimeException {
                        return Client.execute(request, m);
                    }
                }, this.accessControlContext);
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    throw new RuntimeException(cause.getMessage(), cause);
                }
                throw e;
            }
            if (response.getException() == null) {
                return response.getReturnValue();
            }
            Throwable t = response.getException();
            StackTraceElement[] remote = t.getStackTrace();
            StackTraceElement[] curreent = Thread.currentThread().getStackTrace();
            Vector<StackTraceElement> combined = new Vector<StackTraceElement>();
            for (int i2 = 0; i2 < remote.length; ++i2) {
                combined.add(remote[i2]);
                if (remote[i2].getMethodName().equals(m.getName()) && remote[i2].getClassName().startsWith(m.getDeclaringClass().getCanonicalName())) break;
            }
            int startClient = curreent.length;
            for (i = 0; i < curreent.length; ++i) {
                if (!curreent[i].getClassName().equals(this.getClass().getName())) continue;
                startClient = i + 1;
                break;
            }
            for (i = startClient; i < curreent.length; ++i) {
                combined.add(curreent[i]);
            }
            t.setStackTrace(combined.toArray(new StackTraceElement[combined.size()]));
            throw t;
        }
    }
}

