/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.EmulatorLocalDevice;
import com.intel.bluetooth.EmulatorServiceConnection;
import com.intel.bluetooth.ServiceRecordImpl;
import java.io.IOException;

class EmulatorRFCOMMService
extends EmulatorServiceConnection {
    private int channel;

    EmulatorRFCOMMService(EmulatorLocalDevice localDevice, long handle, int channel) {
        super(localDevice, handle);
        this.channel = channel;
    }

    void open(BluetoothConnectionNotifierParams params) throws IOException {
        this.params = params;
        this.localDevice.getDeviceManagerService().rfOpenService(this.localDevice.getAddress(), this.channel);
    }

    long accept() throws IOException {
        return this.localDevice.getDeviceManagerService().rfAccept(this.localDevice.getAddress(), this.channel, this.params.authenticate, this.params.encrypt);
    }

    int getChannel() {
        return this.channel;
    }

    void close(ServiceRecordImpl serviceRecord) throws IOException {
        this.localDevice.getDeviceManagerService().removeServiceRecord(this.localDevice.getAddress(), serviceRecord.getHandle());
        this.localDevice.getDeviceManagerService().rfCloseService(this.localDevice.getAddress(), this.channel);
    }
}

