/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.EmulatorLinkedConnection;
import com.intel.bluetooth.EmulatorLocalDevice;
import java.io.IOException;

class EmulatorRFCOMMClient
extends EmulatorLinkedConnection {
    EmulatorRFCOMMClient(EmulatorLocalDevice localDevice, long handle) {
        super(localDevice, handle);
    }

    void connect(BluetoothConnectionParams params) throws IOException {
        this.connectVerify(params);
        this.connectionHandle = this.localDevice.getDeviceManagerService().rfConnect(this.localDevice.getAddress(), params.address, params.channel, params.authenticate, params.encrypt, params.timeout);
        this.remoteAddress = params.address;
    }

    int read() throws IOException {
        byte[] buf = new byte[1];
        int len = this.read(buf, 0, 1);
        if (len == -1) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    int read(byte[] b, int off, int len) throws IOException {
        byte[] buf = this.localDevice.getDeviceManagerService().rfRead(this.localDevice.getAddress(), this.connectionHandle, len);
        if (buf == null) {
            return -1;
        }
        System.arraycopy(buf, 0, b, off, buf.length);
        return buf.length;
    }

    int available() throws IOException {
        return this.localDevice.getDeviceManagerService().rfAvailable(this.localDevice.getAddress(), this.connectionHandle);
    }

    void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf, 0, 1);
    }

    void write(byte[] b, int off, int len) throws IOException {
        byte[] buf;
        if (b.length == len && off == 0) {
            buf = b;
        } else {
            buf = new byte[len];
            System.arraycopy(b, off, buf, 0, len);
        }
        this.localDevice.getDeviceManagerService().rfWrite(this.localDevice.getAddress(), this.connectionHandle, buf);
    }

    void flush() throws IOException {
        this.localDevice.getDeviceManagerService().rfFlush(this.localDevice.getAddress(), this.connectionHandle);
    }
}

