/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.truthtable;

import com.mathworks.mwswing.MJTable;
import com.mathworks.toolbox.dastudio.truthtable.PredicateTableEditor;
import com.mathworks.toolbox.dastudio.truthtable.PredicateTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;

class PredicateTablePopupMenu
extends JPopupMenu
implements ActionListener {
    private PredicateTableEditor editor;
    private PredicateTableModel tm;
    private JTableHeader th;
    private MJTable table;
    private Component src = null;
    private MouseAdapter popupListener;
    private JMenuItem mAddCol;
    private JMenuItem mAddRow;
    private JMenuItem mCopy;
    private JMenuItem mCut;
    private JMenuItem mPaste;
    private JMenuItem mDel;
    private int col;
    private int row;
    private int sCol;
    private int sRow;
    private Vector cpBuffer;
    private int cpMode;

    PredicateTablePopupMenu(PredicateTableEditor predicateTableEditor) {
        this.editor = predicateTableEditor;
        this.table = this.editor.getPredicateTable();
        this.tm = this.editor.getPredicateTableModel();
        this.th = this.table.getTableHeader();
        this.cpBuffer = new Vector();
        this.cpMode = -1;
        this.mAddCol = new JMenuItem("Add Column");
        this.mAddCol.addActionListener(this);
        this.add(this.mAddCol);
        this.mAddRow = new JMenuItem("Add Row");
        this.mAddRow.addActionListener(this);
        this.add(this.mAddRow);
        this.addSeparator();
        this.mCopy = new JMenuItem("Copy");
        this.mCopy.addActionListener(this);
        this.add(this.mCopy);
        this.mCut = new JMenuItem("Cut");
        this.mCut.addActionListener(this);
        this.add(this.mCut);
        this.mPaste = new JMenuItem("Paste");
        this.mPaste.addActionListener(this);
        this.mPaste.setEnabled(false);
        this.add(this.mPaste);
        this.addSeparator();
        this.mDel = new JMenuItem("Delete");
        this.mDel.addActionListener(this);
        this.add(this.mDel);
        this.popupListener = new PopupListener();
        this.table.addMouseListener((MouseListener)this.popupListener);
        this.th.addMouseListener(this.popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem == this.mAddCol) {
            this.doAddColumn();
        }
        if (jMenuItem == this.mAddRow) {
            this.doAddRow();
        }
        if (jMenuItem == this.mDel) {
            this.doDelete();
        }
        if (jMenuItem == this.mCopy) {
            this.doCopy();
        }
        if (jMenuItem == this.mPaste) {
            this.doPaste();
        }
        if (jMenuItem == this.mCut) {
            this.doCopy();
            this.doDelete();
        }
    }

    private void doDelete() {
        if (this.sRow < 0 && this.sCol < 0) {
            this.tm.setValueAt(null, this.row, this.col);
            this.tm.fireTableCellUpdated(this.row, this.col);
        } else {
            this.tm.deleteRow(this.sRow);
            this.tm.deleteColumn(this.sCol);
        }
        this.editor.clearSelection();
    }

    private void doCopy() {
        this.cpBuffer.removeAllElements();
        if (this.sRow >= 0) {
            this.cpMode = 0;
            this.cpBuffer = this.tm.getRowData(this.sRow);
        } else if (this.sCol >= 0) {
            this.cpMode = 2;
            this.cpBuffer = this.tm.getColumnData(this.sCol);
        } else {
            this.cpMode = 1;
            this.cpBuffer.addElement(this.tm.getValueAt(this.row, this.col));
        }
    }

    private void doPaste() {
        if (this.cpMode == 0) {
            if (this.row != this.sRow) {
                this.tm.addRow(this.row);
            }
            this.tm.setRow(this.cpBuffer, this.row);
            this.editor.clearSelection();
        } else if (this.cpMode == 2) {
            if (this.col != this.sCol) {
                this.tm.addColumn(this.col);
            }
            this.tm.setColumn(this.cpBuffer, this.col);
            this.editor.clearSelection();
        } else {
            this.tm.setValueAt(this.cpBuffer.elementAt(0), this.row, this.col);
            this.tm.fireTableCellUpdated(this.row, this.col);
        }
    }

    private void doAddColumn() {
        this.tm.addColumn(this.col);
        if (this.sCol >= this.col) {
            this.editor.columnSelected(this.sCol + 1);
        } else if (this.sCol > 3) {
            this.editor.columnSelected(this.sCol);
        } else {
            this.editor.rowSelected(this.sRow);
        }
    }

    private void doAddRow() {
        this.tm.addRow(this.row);
        if (this.sRow >= this.row) {
            this.editor.rowSelected(this.sRow + 1);
        } else if (this.sRow >= 0) {
            this.editor.rowSelected(this.sRow);
        } else {
            this.editor.columnSelected(this.sCol);
        }
    }

    private void setCopyCutDeleteContext(String string, int n, int n2) {
        this.mCopy.setText("Copy " + string);
        this.mCut.setText("Cut " + string);
        this.mDel.setText("Delete " + string);
        if (n == n2) {
            this.mCopy.setEnabled(true);
            this.mCut.setEnabled(true);
            this.mDel.setEnabled(true);
        } else {
            this.mCopy.setEnabled(false);
            this.mCut.setEnabled(false);
            this.mDel.setEnabled(false);
        }
    }

    private void setPasteContext(String string, int n, int n2) {
        this.mPaste.setText("Paste " + string);
        if (n == n2) {
            this.mPaste.setEnabled(true);
        } else {
            this.mPaste.setEnabled(false);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                PredicateTablePopupMenu.this.editor.stopEditing();
                PredicateTablePopupMenu.this.src = mouseEvent.getComponent();
                PredicateTablePopupMenu.this.sCol = PredicateTablePopupMenu.this.editor.getSelectedColumn();
                PredicateTablePopupMenu.this.sRow = PredicateTablePopupMenu.this.editor.getSelectedRow();
                if (PredicateTablePopupMenu.this.src == PredicateTablePopupMenu.this.th) {
                    PredicateTablePopupMenu.this.col = PredicateTablePopupMenu.this.th.columnAtPoint(mouseEvent.getPoint());
                    PredicateTablePopupMenu.this.row = -1;
                    if (PredicateTablePopupMenu.this.col < 4) {
                        return;
                    }
                    if (PredicateTablePopupMenu.this.col != PredicateTablePopupMenu.this.sCol) {
                        PredicateTablePopupMenu.this.editor.clearSelection();
                        PredicateTablePopupMenu.this.sCol = -1;
                    }
                    PredicateTablePopupMenu.this.mAddCol.setEnabled(true);
                    PredicateTablePopupMenu.this.mAddRow.setEnabled(false);
                    PredicateTablePopupMenu.this.setCopyCutDeleteContext("column", PredicateTablePopupMenu.this.col, PredicateTablePopupMenu.this.sCol);
                    PredicateTablePopupMenu.this.setPasteContext("column", PredicateTablePopupMenu.this.cpMode, 2);
                } else if (PredicateTablePopupMenu.this.src == PredicateTablePopupMenu.this.table) {
                    PredicateTablePopupMenu.this.col = PredicateTablePopupMenu.this.table.columnAtPoint(mouseEvent.getPoint());
                    PredicateTablePopupMenu.this.row = PredicateTablePopupMenu.this.table.rowAtPoint(mouseEvent.getPoint());
                    if (PredicateTablePopupMenu.this.row == PredicateTablePopupMenu.this.tm.getRowCount() - 1 && PredicateTablePopupMenu.this.col < 4) {
                        return;
                    }
                    if (PredicateTablePopupMenu.this.row != PredicateTablePopupMenu.this.sRow && PredicateTablePopupMenu.this.col != PredicateTablePopupMenu.this.sCol) {
                        PredicateTablePopupMenu.this.editor.clearSelection();
                        PredicateTablePopupMenu.this.sRow = -1;
                        PredicateTablePopupMenu.this.sCol = -1;
                    }
                    if (PredicateTablePopupMenu.this.col > 3) {
                        PredicateTablePopupMenu.this.mAddCol.setEnabled(true);
                        PredicateTablePopupMenu.this.mAddRow.setEnabled(true);
                        if (PredicateTablePopupMenu.this.sRow == PredicateTablePopupMenu.this.row) {
                            PredicateTablePopupMenu.this.setCopyCutDeleteContext("row", PredicateTablePopupMenu.this.row, PredicateTablePopupMenu.this.sRow);
                            PredicateTablePopupMenu.this.setPasteContext("row", PredicateTablePopupMenu.this.cpMode, 0);
                        } else if (PredicateTablePopupMenu.this.sCol == PredicateTablePopupMenu.this.col) {
                            PredicateTablePopupMenu.this.setCopyCutDeleteContext("column", PredicateTablePopupMenu.this.col, PredicateTablePopupMenu.this.sCol);
                            PredicateTablePopupMenu.this.setPasteContext("column", PredicateTablePopupMenu.this.cpMode, 2);
                        } else {
                            PredicateTablePopupMenu.this.setCopyCutDeleteContext("cell", 1, 1);
                            PredicateTablePopupMenu.this.setPasteContext("cell", PredicateTablePopupMenu.this.cpMode, 1);
                        }
                    } else if (PredicateTablePopupMenu.this.col > 0) {
                        PredicateTablePopupMenu.this.mAddCol.setEnabled(false);
                        PredicateTablePopupMenu.this.mAddRow.setEnabled(true);
                        if (PredicateTablePopupMenu.this.sRow == PredicateTablePopupMenu.this.row) {
                            PredicateTablePopupMenu.this.setCopyCutDeleteContext("row", PredicateTablePopupMenu.this.row, PredicateTablePopupMenu.this.sRow);
                            PredicateTablePopupMenu.this.setPasteContext("row", PredicateTablePopupMenu.this.cpMode, 0);
                        } else {
                            PredicateTablePopupMenu.this.setCopyCutDeleteContext("cell", 1, 1);
                            PredicateTablePopupMenu.this.setPasteContext("cell", PredicateTablePopupMenu.this.cpMode, 1);
                        }
                    } else {
                        PredicateTablePopupMenu.this.mAddCol.setEnabled(false);
                        PredicateTablePopupMenu.this.mAddRow.setEnabled(true);
                        PredicateTablePopupMenu.this.setCopyCutDeleteContext("row", PredicateTablePopupMenu.this.row, PredicateTablePopupMenu.this.sRow);
                        PredicateTablePopupMenu.this.setPasteContext("row", PredicateTablePopupMenu.this.cpMode, 0);
                    }
                } else {
                    return;
                }
                PredicateTablePopupMenu.this.show(PredicateTablePopupMenu.this.src, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

